/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.media.file.misc;

import com.apple.jingle.leghorn.audio.wav.beans.StreamDescriptionDocument;
import com.apple.jingle.leghorn.media.MediaUtil;
import com.apple.jingle.leghorn.media.MediaValidationCode;
import com.apple.jingle.leghorn.media.MediaValue;
import com.apple.jingle.leghorn.media.MediaValueImpl;
import com.apple.jingle.leghorn.media.XmlObjectMediaBase;
import com.apple.jingle.leghorn.media.feature.MediaAudioChannel;
import com.apple.jingle.leghorn.media.file.MediaSoundTrack;
import com.apple.jingle.leghorn.media.file.MediaTrackKind;
import com.apple.jingle.leghorn.media.file.misc.BWFAudioMediaFileImpl;
import com.apple.jingle.leghorn.media.xml.XmlObjectMediaParser;
import com.apple.jingle.leghorn.timecode.MediaTime;
import com.apple.jingle.locale.LocaleCode;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.xmlbeans.XmlObject;

public class BWFAudioMediaTrackImpl
extends XmlObjectMediaBase<StreamDescriptionDocument.StreamDescription>
implements MediaSoundTrack {
    @Nonnull
    private final BWFAudioMediaFileImpl _mediaFile;
    @Nonnull
    private final MediaValue<MediaTime> _duration;
    @Nonnull
    private final MediaValue<BigDecimal> _dataSize;
    @Nonnull
    private final MediaValue<BigDecimal> _sampleRate;
    @Nonnull
    private final MediaValue<String> _codec;
    @Nonnull
    private final MediaValue<BigDecimal> _bitdepth;
    @Nonnull
    private final MediaValue<BigDecimal> dataRateInBps;

    BWFAudioMediaTrackImpl(BWFAudioMediaFileImpl mediaFile, StreamDescriptionDocument.StreamDescription xmlObject) {
        super(mediaFile.getMediaFileMetaData(), mediaFile.getMediaName() + "#1", xmlObject);
        XmlObjectMediaParser parser = new XmlObjectMediaParser(mediaFile.getMediaFileMetaData(), this.getMediaName(), (XmlObject)xmlObject);
        this._mediaFile = mediaFile;
        this._dataSize = parser.toMediaDataSize("/stream_description/data_chunk/chunk_size", "/stream_description/data_chunk/chunk_size/@units", null);
        this._duration = parser.toMediaDuration("/stream_description/overview/duration", "/stream_description/overview/duration/@units", null);
        this._sampleRate = parser.toMediaDecimal("/stream_description/format_chunk/sample_rate", null);
        this._codec = parser.toMediaString("/stream_description/format_chunk/format_type", null);
        this._bitdepth = parser.toMediaDecimal("/stream_description/format_chunk/bit_depth", null);
        this.dataRateInBps = parser.toMediaError(MediaValidationCode.AUDIO_DATARATE_MISSING, MediaUtil.dictionary);
    }

    @Override
    @Nonnull
    public List<MediaAudioChannel> channels() {
        return Arrays.asList(MediaAudioChannel.L, MediaAudioChannel.R);
    }

    @Override
    @Nonnull
    public MediaValue<MediaTime> duration() {
        return this._duration;
    }

    @Override
    @Nonnull
    public BigDecimal getSampleRate() {
        return this._sampleRate.get();
    }

    @Override
    @Nonnull
    public MediaValue<BigDecimal> dataRateInBps() {
        return this.dataRateInBps;
    }

    @Override
    @Nonnull
    public String getMediaName() {
        return this.name;
    }

    @Override
    @Nonnull
    public MediaTrackKind getMediaTrackKind() {
        return MediaTrackKind.AUDIO;
    }

    @Override
    @Nonnull
    public BigInteger getTrackId() {
        return BigInteger.ONE;
    }

    @Override
    @Nullable
    public LocaleCode getLocale() {
        return null;
    }

    @Override
    @Nonnull
    public MediaValue<BigDecimal> bitDepth() {
        return this._bitdepth;
    }

    @Override
    @Nonnull
    public MediaValue<String> codec() {
        return this._codec;
    }

    @Override
    public MediaValue<Map<String, Double>> loudness() {
        return new MediaValueImpl<Map<String, Double>>(Collections.emptyMap());
    }

    @Override
    public boolean isTrackEnabled() {
        return true;
    }
}

