/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.media.file.misc;

import com.apple.jingle.leghorn.audio.wav.beans.StreamDescriptionDocument;
import com.apple.jingle.leghorn.media.MediaTrackCriteria;
import com.apple.jingle.leghorn.media.MediaUtil;
import com.apple.jingle.leghorn.media.MediaValidationCode;
import com.apple.jingle.leghorn.media.MediaValue;
import com.apple.jingle.leghorn.media.XmlObjectMediaBase;
import com.apple.jingle.leghorn.media.file.MediaFileBackedByXmlDescription;
import com.apple.jingle.leghorn.media.file.MediaFileContext;
import com.apple.jingle.leghorn.media.file.MediaFileType;
import com.apple.jingle.leghorn.media.file.MediaTrack;
import com.apple.jingle.leghorn.media.file.misc.BWFAudioMediaTrackImpl;
import com.apple.jingle.leghorn.media.xml.XmlObjectMediaParser;
import com.apple.jingle.leghorn.timecode.MediaTime;
import java.math.BigInteger;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import javax.annotation.Nonnull;
import org.apache.mahout.math.Arrays;
import org.apache.xmlbeans.XmlObject;

public class BWFAudioMediaFileImpl
extends XmlObjectMediaBase<StreamDescriptionDocument.StreamDescription>
implements MediaFileBackedByXmlDescription {
    @Nonnull
    private final MediaFileType mediaFileType = MediaFileType.bwfAudioFile;
    @Nonnull
    private final BWFAudioMediaTrackImpl track;

    public BWFAudioMediaFileImpl(@Nonnull MediaFileContext metaData, @Nonnull StreamDescriptionDocument.StreamDescription xmlObject) {
        super(metaData, metaData.getMediaName(), xmlObject);
        XmlObjectMediaParser parser = new XmlObjectMediaParser(metaData, this.getMediaName(), (XmlObject)xmlObject);
        this.track = new BWFAudioMediaTrackImpl(this, xmlObject);
        parser.processNotificationList(xmlObject.getNotifications(), MediaValidationCode.FILE_ALERT_PASSTHROUGH);
    }

    @Nonnull
    MediaFileContext getMediaFileMetaData() {
        return this.metaFile;
    }

    @Override
    @Nonnull
    public MediaFileType getMediaFileType() {
        return this.mediaFileType;
    }

    @Override
    @Nonnull
    public String getMediaName() {
        return this.name;
    }

    @Override
    @Nonnull
    public List<? extends MediaTrack> getTracks() {
        return Collections.singletonList(this.track);
    }

    @Override
    public boolean hasTrack(MediaTrackCriteria ... criteria) {
        return MediaUtil.meetsCriteria(this.track, criteria);
    }

    @Override
    @Nonnull
    public <T extends MediaTrack> List<T> getTracks(Class<T> trackType, MediaTrackCriteria ... criteria) {
        if (trackType.isInstance(this.track) && MediaUtil.meetsCriteria(this.track, criteria)) {
            return Collections.singletonList(trackType.cast(this.track));
        }
        return Collections.emptyList();
    }

    @Override
    @Nonnull
    public <T extends MediaTrack> T getFirstTrack(Class<T> trackType, MediaTrackCriteria ... criteria) throws NoSuchElementException {
        if (trackType.isInstance(this.track) && MediaUtil.meetsCriteria(this.track, criteria)) {
            return (T)((MediaTrack)trackType.cast(this.track));
        }
        throw new NoSuchElementException(trackType.getSimpleName() + Arrays.toString((Object[])criteria));
    }

    @Override
    @Nonnull
    public MediaValue<MediaTime> duration() {
        return this.track.duration();
    }

    @Override
    @Nonnull
    public MediaTrack getTrackById(@Nonnull BigInteger mediaTrackId) throws NoSuchElementException {
        if (this.track.getTrackId().equals(mediaTrackId)) {
            return this.track;
        }
        throw new NoSuchElementException("CAFMediaTrack[" + mediaTrackId + "]");
    }
}

