/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.media.file.misc;

import com.apple.jingle.leghorn.media.MediaValue;
import com.apple.jingle.leghorn.media.MediaValueImpl;
import com.apple.jingle.leghorn.media.XmlObjectMediaBase;
import com.apple.jingle.leghorn.media.feature.MediaAudioChannel;
import com.apple.jingle.leghorn.media.file.MediaSoundTrack;
import com.apple.jingle.leghorn.media.file.MediaTrackKind;
import com.apple.jingle.leghorn.media.file.misc.Ac3MediaFileImpl;
import com.apple.jingle.leghorn.media.xml.XmlObjectMediaParser;
import com.apple.jingle.leghorn.timecode.MediaTime;
import com.apple.jingle.locale.LocaleCode;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.xmlbeans.XmlObject;

public class Ac3MediaTrackImpl
extends XmlObjectMediaBase<XmlObject>
implements MediaSoundTrack {
    @Nonnull
    private final Ac3MediaFileImpl mediaFile;
    @Nonnull
    private final MediaValue<BigDecimal> dataSize;
    @Nonnull
    private final MediaValue<MediaTime> duration;
    @Nonnull
    private final MediaValue<BigDecimal> durationMillis;
    @Nonnull
    private final MediaValue<BigDecimal> dataRate;
    @Nonnull
    private final MediaValue<BigDecimal> sampleRate;
    @Nonnull
    private final MediaValue<String> codec;
    @Nonnull
    private final MediaValue<BigDecimal> bitDepth;
    @Nonnull
    private final MediaValue<Map<String, Double>> loudness;
    @Nonnull
    private final List<MediaAudioChannel> ac3ChannelMap = Arrays.asList(MediaAudioChannel.L, MediaAudioChannel.R, MediaAudioChannel.C, MediaAudioChannel.LFE, MediaAudioChannel.Ls, MediaAudioChannel.Rs);

    Ac3MediaTrackImpl(Ac3MediaFileImpl mediaFile, XmlObject xmlObject) {
        super(mediaFile.getMediaFileMetaData(), mediaFile.getMediaName() + "#1", xmlObject);
        XmlObjectMediaParser parser = new XmlObjectMediaParser(mediaFile.getMediaFileMetaData(), this.getMediaName(), xmlObject);
        this.mediaFile = mediaFile;
        this.codec = new MediaValueImpl<String>("AC-3");
        this.bitDepth = parser.toMediaValue(BigDecimal.ZERO);
        this.loudness = parser.toMediaValue(Collections.emptyMap());
        this.dataSize = parser.toMediaDecimal("/container/stream/@bytes", null);
        this.sampleRate = parser.toMediaDecimal("/container/stream/sound/@sample_rate", null);
        this.durationMillis = parser.toMediaDecimal("/container/stream/@duration", null);
        this.duration = this.durationMillis.hasNonNullValue() ? parser.toMediaValue(new MediaTime(this.durationMillis.get().longValue(), 1000L)) : parser.toMediaValue(null);
        this.dataRate = this.dataSize.hasNonNullValue() && this.duration.hasNonNullValue() ? parser.toMediaValue(new BigDecimal(this.dataSize.get().doubleValue() / this.duration.get().getSeconds() * 8.0)) : parser.toMediaValue(null);
    }

    @Override
    @Nonnull
    public MediaValue<BigDecimal> dataRateInBps() {
        return this.dataRate;
    }

    @Nonnull
    public MediaValue<BigDecimal> durationMillis() {
        return this.durationMillis;
    }

    @Override
    @Nonnull
    public MediaValue<MediaTime> duration() {
        return this.duration;
    }

    @Override
    public String getMediaName() {
        return this.name;
    }

    @Override
    public MediaTrackKind getMediaTrackKind() {
        return MediaTrackKind.AUDIO;
    }

    @Override
    public BigInteger getTrackId() {
        return BigInteger.ONE;
    }

    @Override
    @Nullable
    public LocaleCode getLocale() {
        return null;
    }

    @Override
    public List<MediaAudioChannel> channels() {
        return this.ac3ChannelMap;
    }

    @Override
    public BigDecimal getSampleRate() {
        return this.sampleRate.get();
    }

    @Override
    public MediaValue<BigDecimal> bitDepth() {
        return this.bitDepth;
    }

    @Override
    public MediaValue<String> codec() {
        return this.codec;
    }

    @Override
    public MediaValue<Map<String, Double>> loudness() {
        return this.loudness;
    }

    @Override
    public boolean isTrackEnabled() {
        return true;
    }
}

