/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.media.file.misc;

import com.apple.jingle.leghorn.media.MediaTrackCriteria;
import com.apple.jingle.leghorn.media.MediaUtil;
import com.apple.jingle.leghorn.media.MediaValue;
import com.apple.jingle.leghorn.media.XmlObjectMediaBase;
import com.apple.jingle.leghorn.media.file.MediaFileBackedByXmlDescription;
import com.apple.jingle.leghorn.media.file.MediaFileContext;
import com.apple.jingle.leghorn.media.file.MediaFileType;
import com.apple.jingle.leghorn.media.file.MediaTrack;
import com.apple.jingle.leghorn.media.file.misc.Ac3MediaTrackImpl;
import com.apple.jingle.leghorn.timecode.MediaTime;
import java.math.BigInteger;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import javax.annotation.Nonnull;
import org.apache.mahout.math.Arrays;
import org.apache.xmlbeans.XmlObject;

public class Ac3MediaFileImpl
extends XmlObjectMediaBase<XmlObject>
implements MediaFileBackedByXmlDescription {
    @Nonnull
    private final MediaFileType mediaFileType = MediaFileType.ac3;
    @Nonnull
    private final Ac3MediaTrackImpl track;

    public Ac3MediaFileImpl(@Nonnull MediaFileContext metaData, @Nonnull XmlObject xmlObject) {
        super(metaData, metaData.getMediaName(), xmlObject);
        this.track = new Ac3MediaTrackImpl(this, xmlObject);
    }

    @Nonnull
    MediaFileContext getMediaFileMetaData() {
        return this.metaFile;
    }

    @Override
    @Nonnull
    public MediaFileType getMediaFileType() {
        return this.mediaFileType;
    }

    @Override
    public String getMediaName() {
        return this.name;
    }

    @Nonnull
    public Ac3MediaTrackImpl getTrack() {
        return this.track;
    }

    @Nonnull
    public List<? extends Ac3MediaTrackImpl> getTracks() {
        return Collections.singletonList(this.track);
    }

    @Override
    @Nonnull
    public <T extends MediaTrack> List<T> getTracks(@Nonnull Class<T> trackType, MediaTrackCriteria ... criteria) {
        if (trackType.isInstance(this.track) && MediaUtil.meetsCriteria(this.track, criteria)) {
            return Collections.singletonList(trackType.cast(this.track));
        }
        return Collections.emptyList();
    }

    @Override
    public boolean hasTrack(MediaTrackCriteria ... criteria) {
        return MediaUtil.meetsCriteria(this.track, criteria);
    }

    @Override
    @Nonnull
    public <T extends MediaTrack> T getFirstTrack(@Nonnull Class<T> trackType, MediaTrackCriteria ... criteria) {
        if (trackType.isInstance(this.track) && MediaUtil.meetsCriteria(this.track, criteria)) {
            return (T)((MediaTrack)trackType.cast(this.track));
        }
        throw new NoSuchElementException(trackType.getSimpleName() + Arrays.toString((Object[])criteria));
    }

    @Override
    @Nonnull
    public MediaTrack getTrackById(@Nonnull BigInteger mediaTrackId) throws NoSuchElementException {
        if (this.track.getTrackId().equals(mediaTrackId)) {
            return this.track;
        }
        throw new NoSuchElementException("Ac3MediaTrack[" + mediaTrackId + "]");
    }

    @Override
    @Nonnull
    public MediaValue<MediaTime> duration() {
        return this.track.duration();
    }
}

