/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.media.file;

import com.apple.jingle.g5.MediaKind;
import com.apple.jingle.leghorn.media.MediaTrackCriteria;
import com.apple.jingle.leghorn.media.file.MediaTrack;
import java.util.EnumMap;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public enum MediaTrackKind implements MediaTrackCriteria
{
    VIDEO(MediaKind.VIDEO),
    AUDIO(MediaKind.AUDIO),
    DVS(MediaKind.DVS),
    SUBTITLES(MediaKind.SUBTITLES),
    SDH(MediaKind.SDH),
    CAPTIONS(MediaKind.CAPTIONS),
    CHAPTERS(MediaKind.CHAPTERS),
    THUMBNAILS(MediaKind.THUMBNAILS),
    DUB_CREDIT(MediaKind.DUB_CREDIT),
    PREVIEW_IMAGE(MediaKind.PREVIEW_IMAGE),
    QUALITY_STATS(MediaKind.QUALITY_STATS),
    WEBVTT(null),
    CHAPTER_IMAGE(null),
    TIME_CODE(null),
    HDR_VIDEO(null),
    HDR_CONTENT_MAPPING(null),
    UNKNOWN(null);

    @Nullable
    private final MediaKind mediaKind;
    @Nonnull
    private static final Map<MediaKind, MediaTrackKind> xlateTable;

    private MediaTrackKind(MediaKind mediaKind) {
        this.mediaKind = mediaKind;
    }

    @Nonnull
    private static final EnumMap<MediaKind, MediaTrackKind> calcXlateTable() {
        EnumMap<MediaKind, MediaTrackKind> map = new EnumMap<MediaKind, MediaTrackKind>(MediaKind.class);
        for (MediaTrackKind value : MediaTrackKind.values()) {
            MediaKind mk = value.mediaKind;
            if (null == mk) continue;
            map.put(mk, value);
        }
        return map;
    }

    @Nonnull
    public static final MediaTrackKind valueOf(@Nonnull MediaKind mediaKind) {
        MediaTrackKind value = xlateTable.get((Object)mediaKind);
        if (null != value) {
            return value;
        }
        throw new NoSuchElementException(mediaKind.toString());
    }

    @Override
    public boolean meetsCriteria(@Nonnull MediaTrack track) {
        return track.getMediaTrackKind() == this;
    }

    static {
        xlateTable = MediaTrackKind.calcXlateTable();
    }
}

