/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.media.file;

import com.apple.jingle.media.foundation.types.UniformTypeIdentifier;
import java.io.Serializable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public enum MediaFileType implements Serializable
{
    quickTime(UniformTypeIdentifier.COM_APPLE_QUICKTIME_MOVIE),
    mpeg2(UniformTypeIdentifier.PUBLIC_MPEG_2_VIDEO),
    ac3(UniformTypeIdentifier.PUBLIC_AC3_AUDIO),
    subtitle(UniformTypeIdentifier.COM_APPLE_ITUNES_TIMED_TEXT),
    scc(UniformTypeIdentifier.COM_SONIC_SCENARIST_SCC),
    jpeg(UniformTypeIdentifier.PUBLIC_JPEG),
    mpeg4(UniformTypeIdentifier.PUBLIC_MPEG_4_VIDEO),
    tx3g(UniformTypeIdentifier.COM_APPLE_QUICKTIME_TX3G),
    wvtt(UniformTypeIdentifier.COM_APPLE_QUICKTIME_WVTT),
    dolbyContentMapping(UniformTypeIdentifier.COM_DOLBY_CONTENTMAPPING),
    coreAudioFile(UniformTypeIdentifier.COM_APPLE_COREAUDIO_FORMAT),
    bwfAudioFile(UniformTypeIdentifier.COM_MICROSOFT_WAVEFORM_AUDIO),
    unknown(UniformTypeIdentifier.PUBLIC_DATA);

    @Nonnull
    private final UniformTypeIdentifier uti;

    private MediaFileType(UniformTypeIdentifier uti) {
        this.uti = uti;
    }

    @Nonnull
    public UniformTypeIdentifier getUti() {
        return this.uti;
    }

    @Nullable
    public static MediaFileType lookupByUti(@Nullable String utiName) {
        if (null != utiName) {
            for (MediaFileType ft : MediaFileType.values()) {
                if (!ft.uti.name().equalsIgnoreCase(utiName)) continue;
                return ft;
            }
        }
        return null;
    }

    @Nonnull
    public static MediaFileType lookupByUti(@Nullable UniformTypeIdentifier uti, @Nonnull MediaFileType defaultValue) {
        for (MediaFileType ft : MediaFileType.values()) {
            if (ft.uti != uti) continue;
            return ft;
        }
        return defaultValue;
    }
}

