/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.media.file;

import java.io.Serializable;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.TreeMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public enum MediaFileRole implements Serializable
{
    SOURCE("source"),
    MASTER("master"),
    SETTING("setting"),
    BASE("base"),
    BASE256("base256"),
    FINAL("final"),
    CHAPTERS("chapters"),
    INTERMEDIATE("intermediate"),
    AUDIO("audio"),
    AUDIO_7_1("audio.7_1"),
    AUDIO_OBJECT_BASED("audio.object_based"),
    NOTES("notes"),
    SCRATCH("scratch"),
    CAPTIONS("captions"),
    SUBTITLES("subtitles"),
    FORCED_SUBTITLES("forced_subtitles"),
    VIDEO_END_DUB_CREDITS("video.end.dub_credits"),
    SUBTITLES_HEARING_IMPAIRED("subtitles.hearing_impaired"),
    AUDIO_VISUALLY_IMPAIRED("audio.visually_impaired"),
    AUDIO_COMMENTARY("audio.commentary"),
    SUBTITLES_COMMENTARY("subtitles.commentary"),
    FORCED_SUBTITLES_COMMENTARY("forced_subtitles.commentary"),
    SUBTITLES_HEARING_IMPAIRED_COMMENTARY("subtitles.hearing_impaired.commentary"),
    SOURCE_HDR("source.hdr"),
    MAPPING_HDR("mapping.hdr"),
    PRODUCTION_STILL_IMAGE("production_still_image");

    @Nonnull
    private final String roleName;
    @Nonnull
    private static final Map<String, MediaFileRole> lookupMap;

    private MediaFileRole(String roleName) {
        this.roleName = roleName;
    }

    @Nonnull
    public String getRoleName() {
        return this.roleName;
    }

    @Nonnull
    private static final Map<String, MediaFileRole> createLookupMap() {
        TreeMap<String, MediaFileRole> map = new TreeMap<String, MediaFileRole>(String.CASE_INSENSITIVE_ORDER);
        for (MediaFileRole role : MediaFileRole.values()) {
            map.put(role.name(), role);
            map.put(role.getRoleName(), role);
        }
        return map;
    }

    @Nonnull
    public static final MediaFileRole get(@Nonnull String name) {
        MediaFileRole role = MediaFileRole.lookup(name);
        if (null != role) {
            return role;
        }
        throw new NoSuchElementException(name);
    }

    @Nullable
    public static final MediaFileRole lookup(@Nonnull String name) {
        return lookupMap.get(name);
    }

    static {
        lookupMap = MediaFileRole.createLookupMap();
    }
}

