/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.media.file;

import com.apple.jingle.leghorn.media.MediaProperties;
import com.apple.jingle.leghorn.media.MediaValidationCode;
import com.apple.jingle.leghorn.media.file.MediaFileContext;
import com.apple.jingle.leghorn.media.validator.SimpleDictionary;
import com.apple.jingle.leghorn.media.validator.ValidationLevel;
import com.apple.jingle.leghorn.media.validator.ValidationResult;
import com.apple.jingle.leghorn.media.validator.ValidationResultSet;
import com.apple.jingle.media.foundation.types.UniformTypeIdentifier;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class MediaFileMetaDataImpl
implements MediaFileContext {
    @Nonnull
    private final String name;
    @Nonnull
    private final UniformTypeIdentifier uti;
    @Nonnull
    private final ValidationResultSet resultSet;
    @Nonnull
    private final MediaProperties properties;
    @Nonnull
    private final Map<String, String> attributes;
    @Nonnull
    private final String toolName;
    @Nonnull
    private final String toolVersion;
    @Nullable
    private final String locale;

    public MediaFileMetaDataImpl(@Nonnull String name, @Nonnull UniformTypeIdentifier uti, @Nonnull ValidationResultSet results, @Nonnull MediaProperties properties, Map<String, String> attributes, @Nullable String locale, String toolName, String toolVersion) {
        this.name = name;
        this.uti = uti;
        this.resultSet = results;
        this.properties = properties;
        this.attributes = attributes;
        this.locale = locale;
        this.toolName = toolName;
        this.toolVersion = toolVersion;
    }

    @Override
    @Nonnull
    public String getMediaName() {
        return this.name;
    }

    @Override
    @Nonnull
    public ValidationResult addIssue(@Nonnull MediaValidationCode code, @Nonnull String assetId, @Nonnull SimpleDictionary parameters) {
        return this.resultSet.addResult(code, assetId, parameters);
    }

    @Override
    @Nonnull
    public ValidationResult addIssue(@Nonnull MediaValidationCode code, @Nonnull ValidationLevel defaultLevel, @Nonnull String assetId, @Nonnull SimpleDictionary parameters) {
        return this.resultSet.addResult(code, defaultLevel, assetId, parameters);
    }

    @Override
    @Nonnull
    public UniformTypeIdentifier getUniformTypeIdentifier() {
        return this.uti;
    }

    @Override
    @Nonnull
    public MediaProperties getMediaProperties() {
        return this.properties;
    }

    @Override
    @Nonnull
    public Map<String, String> getMediaAttributes() {
        return this.attributes;
    }

    @Override
    @Nullable
    public String getDescriptionToolVersion() {
        return this.toolVersion;
    }

    @Override
    @Nullable
    public String getDescriptionToolName() {
        return this.toolName;
    }

    @Override
    public String getMediaLocale() {
        return this.locale;
    }

    public String toString() {
        return "MediaFileMeta[" + this.name + "(" + this.uti + ")" + "]";
    }

    @Override
    public MediaFileMetaDataImpl child(String childLabel) {
        return new MediaFileMetaDataImpl(this.getMediaName() + "#" + childLabel, this.uti, this.resultSet, this.properties, this.attributes, childLabel, childLabel, childLabel);
    }

    @Override
    public Set<MediaValidationCode> getSkipValidations() {
        return null;
    }
}

