/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.media.feature.quicktime;

import com.apple.jingle.foghorn.media.FrameGeometry;
import com.apple.jingle.foghorn.media.types.ColorSpace;
import com.apple.jingle.foghorn.media.types.FieldOrdering;
import com.apple.jingle.g5.MediaGrade;
import com.apple.jingle.g5.util.DataDump;
import com.apple.jingle.g5.util.DataDumpable;
import com.apple.jingle.leghorn.media.MediaUtil;
import com.apple.jingle.leghorn.media.feature.FeatureKind;
import com.apple.jingle.leghorn.media.feature.MediaScope;
import com.apple.jingle.leghorn.media.feature.MediaVideoLikeFeature;
import com.apple.jingle.leghorn.media.feature.quicktime.QtTimeFeatureBase;
import com.apple.jingle.leghorn.media.file.MediaFileContext;
import com.apple.jingle.leghorn.media.file.quicktime.QtVideoTrack;
import com.apple.jingle.leghorn.quicktime.GraphicsMode;
import com.apple.jingle.leghorn.timecode.MediaTime;
import com.apple.jingle.leghorn.timecode.SampleRate;
import com.apple.jingle.locale.LocaleCode;
import java.math.BigDecimal;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class QtVideoLikeFeature
extends QtTimeFeatureBase
implements MediaVideoLikeFeature,
DataDumpable {
    private static final long serialVersionUID = 1L;
    @Nonnull
    public static final BigDecimal defaultGammaValue = new BigDecimal("2.2");
    @Nonnull
    protected final QtVideoTrack videoTrack;
    @Nullable
    protected final ColorSpace colorSpace;
    @Nullable
    protected final LocaleCode locale;

    QtVideoLikeFeature(@Nonnull MediaFileContext ctx, @Nonnull QtVideoTrack videoTrack, @Nonnull MediaScope scope, @Nonnull FeatureKind featureKind, @Nonnull MediaGrade grade) {
        super(ctx, videoTrack.getMediaFile(), scope, featureKind, grade);
        this.videoTrack = videoTrack;
        this.locale = MediaUtil.parseLocaleCode(ctx, videoTrack.getLocale());
        ColorSpace colorSpace = videoTrack.actualColorSpace().tryGet();
        if (null == colorSpace) {
            int colorPrimaries = videoTrack.getTrackData("mdia.minf.stbl.stsd.0.avcC.0.sps.0.vui.videoSignalType.colorDescription.colorPrimaries", 0);
            int matrixCoefficient = videoTrack.getTrackData("mdia.minf.stbl.stsd.0.avcC.0.sps.0.vui.videoSignalType.colorDescription.matrixCoefficients", 0);
            int transferCharacteristics = videoTrack.getTrackData("mdia.minf.stbl.stsd.0.avcC.0.sps.0.vui.videoSignalType.colorDescription.transferCharacteristics", 0);
            colorSpace = ColorSpace.guess(colorPrimaries, matrixCoefficient, transferCharacteristics);
        }
        if (null == colorSpace) {
            colorSpace = ColorSpace.BT601;
        }
        this.colorSpace = colorSpace;
    }

    public String toString() {
        return this.getFeatureKind() + "[" + this.videoTrack + "]";
    }

    @Nonnull
    public QtVideoTrack videoTrack() {
        return this.videoTrack;
    }

    @Nullable
    public String getFrameRateMode() {
        return this.videoTrack.frameRateMode().tryGet();
    }

    @Override
    @Nonnull
    public FrameGeometry.Dimensions getVideoDisplayDimensions() throws IllegalStateException {
        return this.videoTrack.displayDimensions().get();
    }

    @Override
    @Nonnull
    public FrameGeometry.Dimensions getVideoEncodedDimensions() throws IllegalStateException {
        return this.videoTrack.encodedDimensions().get();
    }

    @Override
    @Nonnull
    public SampleRate getNominalFrameRate() throws IllegalStateException {
        return this.videoTrack.nominalFrameRate().get();
    }

    @Override
    public boolean getUniformFrameRate() throws IllegalStateException {
        return this.videoTrack.uniformFrameRate().get();
    }

    @Override
    public long getTimeScale() {
        return this.videoTrack.timeScale().get().longValue();
    }

    @Override
    public FrameGeometry getVideoFrameGeometry() {
        FrameGeometry.Dimensions videoEncodedDimensions = this.getVideoEncodedDimensions();
        return new FrameGeometry(new FrameGeometry.Dimensions(videoEncodedDimensions.getWidth(), videoEncodedDimensions.getHeight()), this.getVideoPasp());
    }

    @Nullable
    public FrameGeometry.Pasp getPasp() {
        return this.videoTrack.getPasp();
    }

    @Override
    @Nonnull
    public FrameGeometry.Pasp getVideoPasp() {
        FrameGeometry.Pasp pasp = this.videoTrack.getPasp();
        if (null != pasp) {
            return pasp;
        }
        return FrameGeometry.Pasp.identity();
    }

    public byte[] getAvcc() {
        return this.videoTrack.getAvcc();
    }

    @Override
    public long getFieldCount() {
        return this.videoTrack.getFieldCount();
    }

    @Override
    @Nonnull
    public FieldOrdering getFieldOrdering() {
        return this.videoTrack.getEffectiveFieldOrdering();
    }

    @Override
    @Nonnull
    public ColorSpace colorSpace() {
        return this.colorSpace;
    }

    @Nullable
    public QtVideoTrack.QtVideoMatrix getMatrix() {
        return this.videoTrack.matrix().tryGet();
    }

    @Override
    public boolean isProgressive() {
        return this.videoTrack.isProgressive();
    }

    @Override
    public double getGamma() {
        return this.videoTrack.gamma().get(defaultGammaValue).doubleValue();
    }

    @Override
    @Nonnull
    public MediaTime getDuration() {
        return this.videoTrack.duration().get();
    }

    @Override
    public long getSampleCount() {
        return this.videoTrack.getSampleCount();
    }

    @Override
    public int getSampleDescriptionCount() {
        return this.videoTrack.getSampleDescriptionCount();
    }

    @Override
    @Nonnull
    public GraphicsMode getGraphicsMode() {
        return this.videoTrack.graphicsMode().get();
    }

    @Override
    @Nonnull
    public String getCodecName() throws IllegalStateException {
        return this.videoTrack.codecName().get();
    }

    @Override
    public String getMediaName() {
        return this.mediaFile.getMediaName() + "#" + this.featureKind.name() + "-" + this.videoTrack.getTrackId();
    }

    @Override
    @Nullable
    public LocaleCode getLocale() {
        return this.locale;
    }

    @Override
    public boolean is4k() {
        return MediaVideoLikeFeature.Util.is4k(this);
    }

    @Override
    public void dumpData(DataDump dump) {
        dump.write("frameRateMode", this.getFrameRateMode()).write("displayDimensions", this.getVideoDisplayDimensions()).write("encodedDimensions", this.getVideoEncodedDimensions()).write("nominalFrameRate", this.getNominalFrameRate()).write("timeScale", this.getTimeScale()).write("pasp", this.getPasp()).write("videoPasp", this.getVideoPasp()).write("colorSpace", (Object)this.colorSpace).write("matrix", this.getMatrix()).write("progressive", this.isProgressive()).write("gamma", this.getGamma()).write("duration", this.getDuration()).write("sampleCount", this.getSampleCount()).write("sampleDescriptionCount", this.getSampleDescriptionCount()).write("graphicsMode", (Object)this.getGraphicsMode()).write("codec", this.getCodecName()).write("locale", this.getLocale());
    }
}

