/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.media.feature.quicktime;

import com.apple.jingle.g5.MediaGrade;
import com.apple.jingle.leghorn.media.MediaUtil;
import com.apple.jingle.leghorn.media.feature.FeatureKind;
import com.apple.jingle.leghorn.media.feature.MediaFeatureKey;
import com.apple.jingle.leghorn.media.feature.MediaInstance;
import com.apple.jingle.leghorn.media.feature.MediaScope;
import com.apple.jingle.leghorn.media.feature.quicktime.QtTimeFeatureBase;
import com.apple.jingle.leghorn.media.file.MediaFileContext;
import com.apple.jingle.leghorn.media.file.quicktime.QuickTimeMediaFile;
import com.apple.jingle.leghorn.media.file.quicktime.QuickTimeTrack;
import com.apple.jingle.leghorn.media.index.IndexedMapKeySet;
import com.apple.jingle.locale.LocaleCode;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class QtUnknownFeature
extends QtTimeFeatureBase {
    private static final long serialVersionUID = 1L;
    @Nonnull
    private final QuickTimeTrack<?> track;
    @Nullable
    private final LocaleCode locale;
    @Nonnull
    private final MediaFeatureKey mediaFeatureKey;
    @Nonnull
    private final IndexedMapKeySet indexKeys;

    public QtUnknownFeature(@Nonnull MediaFileContext ctx, @Nonnull QuickTimeMediaFile mediaFile, @Nonnull QuickTimeTrack<?> track, @Nonnull MediaScope scope, @Nonnull FeatureKind featureKind, @Nonnull MediaGrade grade) {
        super(ctx, mediaFile, scope, featureKind, grade);
        this.track = track;
        this.locale = MediaUtil.parseLocaleCode(ctx, track.getLocale());
        this.mediaFeatureKey = new MediaFeatureKey(scope, featureKind, null, new MediaInstance.MediaInstanceString(this.getMediaName()), grade, this.getLocale());
        this.indexKeys = this.mediaFeatureKey.buildIndexKey(new IndexedMapKeySet());
    }

    @Override
    @Nonnull
    public IndexedMapKeySet indexKeys() {
        return this.indexKeys;
    }

    @Override
    @Nonnull
    public MediaFeatureKey mediaFeatureKey() {
        return this.mediaFeatureKey;
    }

    public String toString() {
        return this.getFeatureKind() + "[" + this.track + "]";
    }

    @Override
    public String getMediaName() {
        return this.mediaFile.getMediaName() + "#unknown-" + this.track.getTrackId();
    }

    @Override
    @Nullable
    public LocaleCode getLocale() {
        return this.locale;
    }
}

