/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.media.feature.quicktime;

import com.apple.jingle.g5.MediaGrade;
import com.apple.jingle.leghorn.media.MediaUtil;
import com.apple.jingle.leghorn.media.feature.FeatureKind;
import com.apple.jingle.leghorn.media.feature.MediaScope;
import com.apple.jingle.leghorn.media.feature.MediaSubtitleLikeFeature;
import com.apple.jingle.leghorn.media.feature.quicktime.QtTimeFeatureBase;
import com.apple.jingle.leghorn.media.file.MediaFileContext;
import com.apple.jingle.leghorn.media.file.quicktime.QtSubtitleTrack;
import com.apple.jingle.leghorn.timecode.MediaTime;
import com.apple.jingle.locale.LocaleCode;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class QtSubtitleLikeFeature
extends QtTimeFeatureBase
implements MediaSubtitleLikeFeature {
    private static final long serialVersionUID = 1L;
    @Nonnull
    private final QtSubtitleTrack subtitleTrack;
    @Nullable
    private final LocaleCode locale;

    QtSubtitleLikeFeature(@Nonnull MediaFileContext ctx, @Nonnull QtSubtitleTrack subtitleTrack, @Nonnull MediaScope scope, @Nonnull FeatureKind featureKind, @Nonnull MediaGrade grade) {
        super(ctx, subtitleTrack.getMediaFile(), scope, featureKind, grade);
        this.subtitleTrack = subtitleTrack;
        this.locale = MediaUtil.parseLocaleCode(ctx, subtitleTrack.getLocale());
    }

    @Override
    public String getMediaName() {
        return this.scope + "." + this.getFeatureKind() + "." + this.grade;
    }

    public String toString() {
        return this.getFeatureKind() + "[" + this.grade + "," + "scope=" + this.scope + ", " + "lang=" + this.locale + ", " + "dur=" + this.getDuration().getSeconds() + "s" + "]";
    }

    @Override
    public MediaTime getDuration() {
        return this.subtitleTrack.duration().get();
    }

    @Override
    @Nullable
    public LocaleCode getLocale() {
        return this.locale;
    }
}

