/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.media.feature.quicktime;

import com.apple.jingle.g5.MediaGrade;
import com.apple.jingle.leghorn.media.MediaUtil;
import com.apple.jingle.leghorn.media.MediaValidationCode;
import com.apple.jingle.leghorn.media.MediaValue;
import com.apple.jingle.leghorn.media.MediaValueError;
import com.apple.jingle.leghorn.media.MediaValueImpl;
import com.apple.jingle.leghorn.media.feature.FeatureKind;
import com.apple.jingle.leghorn.media.feature.MediaAudioChannel;
import com.apple.jingle.leghorn.media.feature.MediaAudioLikeFeature;
import com.apple.jingle.leghorn.media.feature.MediaScope;
import com.apple.jingle.leghorn.media.feature.quicktime.QtTimeFeatureBase;
import com.apple.jingle.leghorn.media.file.MediaFileContext;
import com.apple.jingle.leghorn.media.file.quicktime.QtSoundTrack;
import com.apple.jingle.leghorn.media.file.quicktime.QuickTimeMediaFile;
import com.apple.jingle.leghorn.timecode.MediaTime;
import com.apple.jingle.locale.LocaleCode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class QtAudioLikeFeature
extends QtTimeFeatureBase
implements MediaAudioLikeFeature {
    private static final long serialVersionUID = 1L;
    @Nonnull
    protected final EnumMap<MediaAudioChannel, QtSoundTrack> chTrackMap;
    @Nonnull
    protected final List<QtSoundTrack> tracks;
    protected final long sampleRateInHz;
    protected final long dataRateInBps;
    @Nullable
    protected final LocaleCode locale;
    @Nonnull
    protected final MediaValue<MediaTime> duration;

    QtAudioLikeFeature(@Nonnull MediaFileContext ctx, @Nonnull QuickTimeMediaFile mediaFile, EnumMap<MediaAudioChannel, QtSoundTrack> chTrackMap, @Nonnull MediaScope scope, @Nonnull FeatureKind featureKind, @Nonnull MediaGrade grade) {
        super(ctx, mediaFile, scope, featureKind, grade);
        this.chTrackMap = chTrackMap;
        ArrayList<QtSoundTrack> tracks = new ArrayList<QtSoundTrack>(chTrackMap.size());
        for (QtSoundTrack t : this.chTrackMap.values()) {
            if (tracks.contains(t)) continue;
            tracks.add(t);
        }
        this.tracks = Collections.unmodifiableList(tracks);
        this.locale = MediaUtil.parseLocaleCode(ctx, this.calcLocale(ctx));
        this.duration = this.calcDuration(ctx);
        long sampleRate = -1L;
        for (QtSoundTrack track : tracks) {
            long trackSampleRate = track.getSampleRate().longValue();
            if (sampleRate == -1L) {
                sampleRate = trackSampleRate;
            }
            if (Math.abs(trackSampleRate - sampleRate) / 1000L > 1L) {
                ctx.addIssue(MediaValidationCode.AUDIO_SAMPLERATE_MISMATCH, track.getMediaName(), MediaUtil.dictionary.add("value", (double)sampleRate / 1000.0 + "kHz").add("expectedValue", (double)trackSampleRate / 1000.0 + "kHz"));
            }
            if (sampleRate >= trackSampleRate) continue;
            sampleRate = trackSampleRate;
        }
        this.sampleRateInHz = sampleRate;
        long dataRate = -1L;
        for (QtSoundTrack track : tracks) {
            if (!track.dataRateInBps().hasNonNullValue()) continue;
            long trackDataRate = track.dataRateInBps().get().longValue();
            if (dataRate == -1L) {
                dataRate = trackDataRate;
            }
            if (Math.abs(trackDataRate - dataRate) / 1000L > 1L) {
                ctx.addIssue(MediaValidationCode.AUDIO_DATARATE_MISMATCH, track.getMediaName(), MediaUtil.dictionary.add("value", (double)sampleRate / 1000.0 + "kb/s").add("expectedValue", dataRate + "kb/s"));
            }
            if (dataRate >= trackDataRate) continue;
            dataRate = trackDataRate;
        }
        this.dataRateInBps = dataRate;
    }

    @Override
    @Nullable
    public LocaleCode getLocale() {
        return this.locale;
    }

    @Nullable
    protected final LocaleCode calcLocale(@Nonnull MediaFileContext ctx) {
        LocaleCode locale = null;
        for (QtSoundTrack track : this.tracks) {
            LocaleCode trackLocale = track.getLocale();
            if (null == trackLocale) continue;
            if (null == locale) {
                locale = trackLocale;
                continue;
            }
            if (locale.equals(trackLocale)) continue;
            ctx.addIssue(MediaValidationCode.AUDIO_LOCALE_MISMATCH, track.getMediaName(), MediaUtil.dictionary.add("localeCode", trackLocale.toString()).add("expectedLocaleCode", locale.toString()));
        }
        return locale;
    }

    @Nonnull
    protected MediaValue<MediaTime> calcDuration(@Nonnull MediaFileContext ctx) {
        MediaTime duration = null;
        for (QtSoundTrack track : this.tracks) {
            MediaTime trackDuration = track.duration().tryGet();
            if (null == trackDuration) continue;
            if (null == duration) {
                duration = trackDuration;
            } else {
                double delta = Math.abs(duration.getTotalMilliseconds() - trackDuration.getTotalMilliseconds());
                if ((delta /= (double)trackDuration.getTotalMilliseconds()) > 0.5) {
                    ctx.addIssue(MediaValidationCode.AUDIO_DURATION_MISMATCH, track.getMediaName(), MediaUtil.dictionary.add("duration", trackDuration.toString()).add("expectedDuration", duration.toString()));
                }
            }
            if (duration.compareTo(trackDuration) >= 0) continue;
            duration = trackDuration;
        }
        if (null == duration) {
            return new MediaValueError<MediaTime>(ctx.addIssue(MediaValidationCode.AUDIO_DURATION_MISSING, this.getMediaName(), MediaUtil.dictionary));
        }
        return new MediaValueImpl<Object>(duration);
    }

    @Override
    @Nonnull
    public String getMediaName() {
        return this.mediaFile.getMediaName() + "#" + this.scope + "." + this.getFeatureKind() + "." + this.grade;
    }

    public String toString() {
        return this.getFeatureKind() + "[" + this.grade + ", " + "scope=" + this.scope + ", " + "rate=" + (double)this.dataRateInBps / 1000.0 + "kbps @ " + (double)this.sampleRateInHz / 1000.0 + "kHz, " + "lang=" + this.locale + ", " + "dur=" + this.duration + ", " + "chs=" + this.chTrackMap.keySet() + "]";
    }

    @Override
    @Nonnull
    public Set<MediaAudioChannel> channels() {
        return this.chTrackMap.keySet();
    }
}

