/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.media.feature.quicktime;

import com.apple.jingle.foghorn.media.types.ColorSpace;
import com.apple.jingle.foghorn.media.types.HDR10Metadata;
import com.apple.jingle.g5.MediaGrade;
import com.apple.jingle.leghorn.dolby.contentmapping.DolbyCmDisplay;
import com.apple.jingle.leghorn.media.MediaUtil;
import com.apple.jingle.leghorn.media.MediaValidationCode;
import com.apple.jingle.leghorn.media.dolbymapping.file.DolbyContentMappingVideoTrack;
import com.apple.jingle.leghorn.media.feature.FeatureKind;
import com.apple.jingle.leghorn.media.feature.MediaFeatureKey;
import com.apple.jingle.leghorn.media.feature.MediaHDRVideoFeature;
import com.apple.jingle.leghorn.media.feature.MediaInstance;
import com.apple.jingle.leghorn.media.feature.MediaScope;
import com.apple.jingle.leghorn.media.feature.quicktime.QtVideoLikeFeature;
import com.apple.jingle.leghorn.media.file.MediaFileContext;
import com.apple.jingle.leghorn.media.file.quicktime.QtVideoTrack;
import com.apple.jingle.leghorn.media.index.IndexedMapKeySet;
import com.apple.jingle.leghorn.timecode.MediaTime;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class QTHDRVideoFeature
extends QtVideoLikeFeature
implements MediaHDRVideoFeature {
    private static final long serialVersionUID = 1L;
    @Nonnull
    protected final DolbyContentMappingVideoTrack hdrMappingTrack;
    @Nonnull
    private final MediaFeatureKey mediaFeatureKey;
    @Nonnull
    private final IndexedMapKeySet indexKeys;

    public QTHDRVideoFeature(@Nonnull MediaFileContext ctx, @Nonnull QtVideoTrack videoTrack, @Nonnull MediaScope scope, @Nonnull MediaGrade grade, @Nonnull DolbyContentMappingVideoTrack hdrMappingTrack) {
        super(ctx, videoTrack, scope, FeatureKind.VIDEO, grade);
        this.hdrMappingTrack = hdrMappingTrack;
        this.mediaFeatureKey = new MediaFeatureKey(scope, this.featureKind, null, new MediaInstance.MediaInstanceString(this.getMediaName()), grade, this.getLocale());
        this.indexKeys = this.mediaFeatureKey.buildIndexKey(new IndexedMapKeySet());
        if (null != hdrMappingTrack) {
            double diff;
            MediaTime duration = this.getDuration();
            MediaTime mapDuration = hdrMappingTrack.endTime().tryGet();
            if (null != mapDuration && (diff = mapDuration.getSeconds() - duration.getSeconds()) > 1.0) {
                ctx.addIssue(MediaValidationCode.HDR_MAPPING_VIDEO_DURATION_MISMATCH, hdrMappingTrack.getMediaName(), MediaUtil.dictionary.add("actualValue", String.format("%,.1f", mapDuration.getSeconds())).add("expectedValue", String.format("%,.1f", duration.getSeconds())));
            }
        }
        switch (scope) {
            case source: {
                ColorSpace colorSpace = videoTrack.actualColorSpace().tryGet();
                if (colorSpace == null || !colorSpace.isHDR()) {
                    ctx.addIssue(MediaValidationCode.HDR_SOURCE_COLORSPACE_INVALID, videoTrack.getMediaName(), MediaUtil.dictionary.add("colorSpace", colorSpace != null ? colorSpace.getToolParameter() : "null"));
                }
                if (null == hdrMappingTrack) break;
                boolean has100NitTarget = false;
                boolean has500NitTarget = false;
                boolean has1000NitTarget = false;
                TreeSet<Integer> peakBrightnessValues = new TreeSet<Integer>();
                for (DolbyCmDisplay display : hdrMappingTrack.targetDisplays()) {
                    if (!display.getPeakBrightness().hasNonNullValue()) continue;
                    int nits = display.getPeakBrightness().get().intValue();
                    peakBrightnessValues.add(nits);
                    if (nits >= 50 && nits < 200) {
                        has100NitTarget = true;
                        continue;
                    }
                    if (nits >= 250 && nits < 650) {
                        has500NitTarget = true;
                        continue;
                    }
                    if (nits < 900 || nits >= 1100) continue;
                    has1000NitTarget = true;
                }
                if (!has100NitTarget) {
                    ctx.addIssue(MediaValidationCode.HDR_MAPPING_NO_100NIT_TARGET, hdrMappingTrack.getMediaName(), MediaUtil.dictionary.add("values", peakBrightnessValues.toString()));
                }
                if (!has500NitTarget) {
                    ctx.addIssue(MediaValidationCode.HDR_MAPPING_NO_500NIT_TARGET, hdrMappingTrack.getMediaName(), MediaUtil.dictionary.add("values", peakBrightnessValues.toString()));
                }
                if (has1000NitTarget) break;
                ctx.addIssue(MediaValidationCode.HDR_MAPPING_NO_1000NIT_TARGET, hdrMappingTrack.getMediaName(), MediaUtil.dictionary.add("values", peakBrightnessValues.toString()));
                break;
            }
        }
    }

    @Override
    @Nonnull
    public IndexedMapKeySet indexKeys() {
        return this.indexKeys;
    }

    @Override
    @Nonnull
    public MediaFeatureKey mediaFeatureKey() {
        return this.mediaFeatureKey;
    }

    @Nullable
    public DolbyContentMappingVideoTrack hdrMappingTrack() {
        return this.hdrMappingTrack;
    }

    @Override
    public String toString() {
        return this.getFeatureKind() + "[" + this.videoTrack + ", HDRMAP=" + this.hdrMappingTrack + "]";
    }

    @Override
    @Nullable
    public HDR10Metadata hdr10Metadata() {
        return this.videoTrack.hdr10Metadata().tryGet();
    }
}

