/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.media.feature.mpeg2ps;

import com.apple.jingle.foghorn.media.FrameGeometry;
import com.apple.jingle.foghorn.media.types.ColorSpace;
import com.apple.jingle.foghorn.media.types.FieldOrdering;
import com.apple.jingle.g5.MediaGrade;
import com.apple.jingle.leghorn.media.MediaUtil;
import com.apple.jingle.leghorn.media.feature.FeatureKind;
import com.apple.jingle.leghorn.media.feature.MediaFeatureKey;
import com.apple.jingle.leghorn.media.feature.MediaInstance;
import com.apple.jingle.leghorn.media.feature.MediaScope;
import com.apple.jingle.leghorn.media.feature.MediaVideoFeature;
import com.apple.jingle.leghorn.media.feature.MediaVideoLikeFeature;
import com.apple.jingle.leghorn.media.feature.mpeg2ps.Mpeg2psFeature;
import com.apple.jingle.leghorn.media.feature.quicktime.QtVideoFeature;
import com.apple.jingle.leghorn.media.file.MediaFileContext;
import com.apple.jingle.leghorn.media.file.mpeg2ps.Mpeg2psVideoTrack;
import com.apple.jingle.leghorn.media.index.IndexedMapKeySet;
import com.apple.jingle.leghorn.quicktime.GraphicsMode;
import com.apple.jingle.leghorn.timecode.MediaTime;
import com.apple.jingle.leghorn.timecode.SampleRate;
import com.apple.jingle.locale.LocaleCode;
import java.math.BigDecimal;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class Mpeg2psVideoFeature
extends Mpeg2psFeature
implements MediaVideoFeature {
    private static final long serialVersionUID = 1L;
    @Nonnull
    public static final BigDecimal defaultGammaValue = new BigDecimal("2.2");
    @Nonnull
    private final MediaFeatureKey mediaFeatureKey;
    @Nonnull
    protected final IndexedMapKeySet indexKeys;
    @Nullable
    private final LocaleCode locale;
    @Nonnull
    private final Mpeg2psVideoTrack videoTrack;

    public Mpeg2psVideoFeature(@Nonnull MediaFileContext ctx, @Nonnull Mpeg2psVideoTrack videoTrack, @Nonnull MediaScope scope, @Nonnull MediaGrade grade) {
        super(ctx, videoTrack.getMediaFile(), scope, FeatureKind.VIDEO, grade);
        this.videoTrack = videoTrack;
        this.locale = MediaUtil.parseLocaleCode(ctx, null);
        this.mediaFeatureKey = new MediaFeatureKey(scope, this.featureKind, null, new MediaInstance.MediaInstanceString(this.getMediaName()), grade, this.getLocale());
        this.indexKeys = this.mediaFeatureKey.buildIndexKey(new IndexedMapKeySet());
    }

    @Override
    @Nonnull
    public IndexedMapKeySet indexKeys() {
        return this.indexKeys;
    }

    @Override
    @Nonnull
    public MediaFeatureKey mediaFeatureKey() {
        return this.mediaFeatureKey;
    }

    public String toString() {
        return this.getFeatureKind() + "[" + this.videoTrack + "]";
    }

    @Override
    @Nonnull
    public FrameGeometry.Dimensions getVideoDisplayDimensions() throws IllegalStateException {
        return this.videoTrack.displayDimensions().tryGet();
    }

    @Override
    @Nonnull
    public FrameGeometry.Dimensions getVideoEncodedDimensions() throws IllegalStateException {
        return this.videoTrack.encodedDimensions().get();
    }

    @Override
    public String getMediaName() {
        return this.mediaFile.getMediaName() + "#video-" + this.videoTrack.getTrackId();
    }

    @Override
    @Nullable
    public LocaleCode getLocale() {
        return this.locale;
    }

    @Override
    public SampleRate getNominalFrameRate() {
        return this.videoTrack.frameRate().get();
    }

    @Override
    public boolean getUniformFrameRate() {
        return this.videoTrack.uniformFrameRate().get();
    }

    @Override
    public long getTimeScale() {
        return this.videoTrack.timeScale().get();
    }

    @Override
    @Nonnull
    public FrameGeometry getVideoFrameGeometry() {
        FrameGeometry.Dimensions encodedDims = this.videoTrack.encodedDimensions().get();
        if (this.videoTrack.displayDimensions().hasNonNullValue()) {
            FrameGeometry.Dimensions displayDims = this.videoTrack.displayDimensions().get();
            FrameGeometry.Pasp pasp = new FrameGeometry.Pasp(encodedDims, displayDims).reduce();
            return new FrameGeometry(encodedDims, pasp);
        }
        return new FrameGeometry(encodedDims);
    }

    @Override
    @Nonnull
    public FieldOrdering getFieldOrdering() {
        return this.videoTrack.fieldOrdering().get();
    }

    @Override
    public boolean isProgressive() {
        return this.videoTrack.fieldOrdering().get() == FieldOrdering.PROGRESSIVE;
    }

    @Override
    public double getGamma() {
        return QtVideoFeature.defaultGammaValue.doubleValue();
    }

    @Override
    public long getSampleCount() {
        Long sampleCount = this.videoTrack.getSampleCount();
        if (sampleCount != null) {
            return sampleCount;
        }
        return 0L;
    }

    @Override
    public int getSampleDescriptionCount() {
        return 0;
    }

    @Override
    @Nullable
    public FrameGeometry.Pasp getVideoPasp() {
        return null;
    }

    @Override
    @Nonnull
    public MediaTime getDuration() {
        return this.mediaFile.getMaximumTrackDuration();
    }

    @Override
    @Nonnull
    public String getCodecName() {
        return this.videoTrack.codecName().get();
    }

    @Override
    public GraphicsMode getGraphicsMode() {
        return GraphicsMode.NOT_APPLICABLE;
    }

    @Override
    public long getFieldCount() {
        if (this.isProgressive()) {
            return 1L;
        }
        return 2L;
    }

    @Override
    public ColorSpace colorSpace() {
        return null;
    }

    @Override
    public boolean is4k() {
        return MediaVideoLikeFeature.Util.is4k(this);
    }
}

