/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.media.feature.mpeg2ps;

import com.apple.jingle.g5.MediaGrade;
import com.apple.jingle.leghorn.media.MediaUtil;
import com.apple.jingle.leghorn.media.MediaValue;
import com.apple.jingle.leghorn.media.MediaValueImpl;
import com.apple.jingle.leghorn.media.feature.FeatureKind;
import com.apple.jingle.leghorn.media.feature.MediaAudioChannel;
import com.apple.jingle.leghorn.media.feature.MediaAudioFeature;
import com.apple.jingle.leghorn.media.feature.MediaFeatureKey;
import com.apple.jingle.leghorn.media.feature.MediaInstance;
import com.apple.jingle.leghorn.media.feature.MediaScope;
import com.apple.jingle.leghorn.media.feature.mpeg2ps.Mpeg2psFeature;
import com.apple.jingle.leghorn.media.file.MediaFileContext;
import com.apple.jingle.leghorn.media.file.mpeg2ps.Mpeg2psMediaFile;
import com.apple.jingle.leghorn.media.file.mpeg2ps.Mpeg2psSoundTrack;
import com.apple.jingle.leghorn.media.index.IndexedMapKeySet;
import com.apple.jingle.leghorn.timecode.MediaTime;
import com.apple.jingle.locale.LocaleCode;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class Mpeg2psAudioFeature
extends Mpeg2psFeature
implements MediaAudioFeature {
    private static final long serialVersionUID = 1L;
    @Nonnull
    private final MediaFeatureKey mediaFeatureKey;
    @Nonnull
    private final IndexedMapKeySet indexKeys;
    @Nonnull
    private final EnumMap<MediaAudioChannel, Mpeg2psSoundTrack> chTrackMap;
    @Nullable
    protected final LocaleCode locale;
    @Nonnull
    protected final MediaValue<MediaTime> duration;

    public Mpeg2psAudioFeature(@Nonnull MediaFileContext ctx, @Nonnull Mpeg2psMediaFile mediaFile, @Nonnull FeatureKind featureKind, @Nonnull EnumMap<MediaAudioChannel, Mpeg2psSoundTrack> chTrackMap, @Nonnull MediaScope scope, @Nonnull MediaGrade grade) {
        super(ctx, mediaFile, scope, featureKind, grade);
        Mpeg2psSoundTrack track;
        this.chTrackMap = chTrackMap;
        this.locale = MediaUtil.parseLocaleCode(ctx, null);
        MediaValue<MediaTime> duration = null;
        Iterator<Mpeg2psSoundTrack> i$ = chTrackMap.values().iterator();
        while (i$.hasNext() && !(duration = (track = i$.next()).duration()).hasNonNullValue()) {
        }
        this.duration = duration != null ? duration : new MediaValueImpl<Object>(null);
        this.mediaFeatureKey = new MediaFeatureKey(scope, featureKind, null, new MediaInstance.MediaInstanceString(this.getMediaName()), grade, this.getLocale());
        this.indexKeys = this.mediaFeatureKey.buildIndexKey(new IndexedMapKeySet());
    }

    @Override
    @Nonnull
    public IndexedMapKeySet indexKeys() {
        return this.indexKeys;
    }

    @Override
    @Nonnull
    public MediaFeatureKey mediaFeatureKey() {
        return this.mediaFeatureKey;
    }

    public String toString() {
        return this.getFeatureKind() + "[" + this.chTrackMap + "]";
    }

    @Override
    public String getMediaName() {
        return this.mediaFile.getMediaName() + "#" + this.scope + "." + this.getFeatureKind() + "." + this.grade;
    }

    @Override
    @Nullable
    public LocaleCode getLocale() {
        return this.locale;
    }

    @Override
    public Set<MediaAudioChannel> channels() {
        return this.chTrackMap.keySet();
    }

    @Override
    public MediaValue<MediaTime> duration() {
        return this.duration;
    }
}

