/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.media.feature.misc;

import com.apple.jingle.g5.MediaGrade;
import com.apple.jingle.leghorn.media.MediaUtil;
import com.apple.jingle.leghorn.media.feature.FeatureKind;
import com.apple.jingle.leghorn.media.feature.MediaScope;
import com.apple.jingle.leghorn.media.feature.MediaSubtitleLikeFeature;
import com.apple.jingle.leghorn.media.file.MediaFileContext;
import com.apple.jingle.leghorn.media.file.misc.IttMediaTrackImpl;
import com.apple.jingle.leghorn.timecode.MediaTime;
import com.apple.jingle.leghorn.timecode.SMPTETimeCode;
import com.apple.jingle.leghorn.timecode.SampleRate;
import com.apple.jingle.locale.LocaleCode;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class SubtitleLikeFeature
implements MediaSubtitleLikeFeature {
    private static final long serialVersionUID = 1L;
    @Nonnull
    protected final IttMediaTrackImpl track;
    @Nonnull
    protected final MediaScope scope;
    @Nonnull
    protected final MediaGrade grade;
    @Nonnull
    protected final FeatureKind featureKind;
    @Nullable
    protected final LocaleCode locale;

    SubtitleLikeFeature(@Nonnull MediaFileContext ctx, @Nonnull IttMediaTrackImpl track, @Nonnull MediaScope scope, @Nonnull FeatureKind featureKind, @Nonnull MediaGrade grade) {
        this.track = track;
        this.scope = scope;
        this.featureKind = featureKind;
        this.grade = grade;
        this.locale = MediaUtil.parseLocaleCode(ctx, null);
    }

    public String toString() {
        return this.featureKind + "[lang=" + this.locale + "]";
    }

    @Override
    @Nonnull
    public final MediaScope getMediaFeatureScope() {
        return this.scope;
    }

    @Override
    @Nonnull
    public final FeatureKind getFeatureKind() {
        return this.featureKind;
    }

    @Override
    @Nonnull
    public final MediaGrade getMediaGrade() {
        return this.grade;
    }

    @Override
    public String getMediaName() {
        return this.track.getMediaName();
    }

    @Override
    @Nullable
    public LocaleCode getLocale() {
        return this.locale;
    }

    @Override
    @Nonnull
    public MediaTime getDuration() {
        return this.track.getDuration();
    }

    @Nonnull
    public SampleRate getSampleRate() {
        return this.track.getSampleRate();
    }

    public SMPTETimeCode.Mode getDropMode() {
        return this.track.getDropMode();
    }

    @Nullable
    public MediaTime getOffset() {
        return this.track.getOffset();
    }
}

