/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.media.feature.misc;

import com.apple.jingle.g5.MediaGrade;
import com.apple.jingle.leghorn.media.MediaUtil;
import com.apple.jingle.leghorn.media.feature.FeatureKind;
import com.apple.jingle.leghorn.media.feature.MediaCaptionsFeature;
import com.apple.jingle.leghorn.media.feature.MediaFeature;
import com.apple.jingle.leghorn.media.feature.MediaFeatureKey;
import com.apple.jingle.leghorn.media.feature.MediaInstance;
import com.apple.jingle.leghorn.media.feature.MediaScope;
import com.apple.jingle.leghorn.media.file.MediaFileContext;
import com.apple.jingle.leghorn.media.file.misc.SccMediaTrackImpl;
import com.apple.jingle.leghorn.media.index.IndexedMapKeySet;
import com.apple.jingle.leghorn.timecode.MediaTime;
import com.apple.jingle.locale.BCP47TagSupport;
import com.apple.jingle.locale.LocaleCode;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class SccFeature
implements MediaCaptionsFeature {
    private static final long serialVersionUID = 1L;
    @Nonnull
    protected final SccMediaTrackImpl track;
    @Nonnull
    protected final MediaScope scope;
    @Nonnull
    protected final MediaGrade grade;
    @Nonnull
    protected final FeatureKind featureKind;
    @Nonnull
    protected final LocaleCode locale;
    @Nonnull
    private final MediaFeatureKey mediaFeatureKey;
    @Nonnull
    private final IndexedMapKeySet indexKeys;

    public SccFeature(@Nonnull MediaFileContext ctx, @Nonnull SccMediaTrackImpl track, @Nonnull MediaScope scope, @Nonnull MediaGrade grade) {
        this.track = track;
        this.scope = scope;
        this.featureKind = FeatureKind.CAPTIONS;
        this.grade = grade;
        this.locale = MediaUtil.parseLocaleCode(ctx, BCP47TagSupport.ENGLISH);
        this.mediaFeatureKey = new MediaFeatureKey(scope, this.featureKind, null, new MediaInstance.MediaInstanceString(this.getMediaName()), grade, this.getLocale());
        this.indexKeys = this.mediaFeatureKey.buildIndexKey(new IndexedMapKeySet());
    }

    @Override
    public int compareTo(@Nonnull MediaFeature comp) {
        return this.mediaFeatureKey().compareTo(comp.mediaFeatureKey());
    }

    @Override
    @Nonnull
    public IndexedMapKeySet indexKeys() {
        return this.indexKeys;
    }

    @Override
    @Nonnull
    public MediaFeatureKey mediaFeatureKey() {
        return this.mediaFeatureKey;
    }

    public String toString() {
        return this.featureKind + "[lang=" + this.locale + "]";
    }

    @Override
    @Nonnull
    public final MediaScope getMediaFeatureScope() {
        return this.scope;
    }

    @Override
    @Nonnull
    public final FeatureKind getFeatureKind() {
        return this.featureKind;
    }

    @Override
    @Nonnull
    public final MediaGrade getMediaGrade() {
        return this.grade;
    }

    @Override
    public String getMediaName() {
        return this.track.getMediaName();
    }

    @Override
    @Nullable
    public LocaleCode getLocale() {
        return this.locale;
    }

    @Override
    @Nonnull
    public MediaTime getDuration() {
        return this.track.getLastTimeCode().getMediaTime();
    }
}

