/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.media.feature.extractor;

import com.apple.jingle.leghorn.media.feature.AudioFormat;
import com.apple.jingle.leghorn.media.feature.MediaAudioChannel;
import com.apple.jingle.leghorn.media.file.MediaFile;
import com.apple.jingle.leghorn.media.file.MediaSoundTrack;
import com.apple.jingle.leghorn.media.file.MediaTrackKind;
import com.apple.jingle.leghorn.media.file.quicktime.QtSoundTrack;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;

public class FeatureExtractor {
    public static final Set<MediaAudioChannel> surround51Channels = EnumSet.of(MediaAudioChannel.L, new MediaAudioChannel[]{MediaAudioChannel.R, MediaAudioChannel.C, MediaAudioChannel.LFE, MediaAudioChannel.Ls, MediaAudioChannel.Rs});
    public static final Set<MediaAudioChannel> surround71Channels = EnumSet.of(MediaAudioChannel.L, new MediaAudioChannel[]{MediaAudioChannel.R, MediaAudioChannel.C, MediaAudioChannel.LFE, MediaAudioChannel.Ls, MediaAudioChannel.Rs, MediaAudioChannel.Lrs, MediaAudioChannel.Rrs});
    public static final Set<MediaAudioChannel> stereoOnlyChannels = EnumSet.of(MediaAudioChannel.L, MediaAudioChannel.R);
    public static final Set<MediaAudioChannel> matrixStereoOnlyChannels = EnumSet.of(MediaAudioChannel.Lt, MediaAudioChannel.Rt);
    public static final Set<MediaAudioChannel> stereoVariants = EnumSet.of(MediaAudioChannel.L, MediaAudioChannel.R, MediaAudioChannel.Lt, MediaAudioChannel.Rt);
    @Nonnull
    protected List<MediaSoundTrack> audioTracks;
    @Nonnull
    protected List<MediaSoundTrack> enabledAudioTracks = new ArrayList<MediaSoundTrack>();
    @Nonnull
    protected List<MediaAudioChannel> allChannels;
    @Nonnull
    protected List<MediaAudioChannel> enabledTrackChannels = new ArrayList<MediaAudioChannel>();
    @Nonnull
    protected EnumMap<MediaAudioChannel, MediaSoundTrack> stereoMap;
    @Nonnull
    protected EnumMap<MediaAudioChannel, MediaSoundTrack> surroundMap;
    @Nonnull
    protected EnumSet<AudioFormat> detectedFormats;
    protected boolean validChannelMap;
    protected String channelLayoutDescription;

    public FeatureExtractor(@Nonnull MediaFile mediaFile) {
        this(mediaFile.getTracks(MediaSoundTrack.class, MediaTrackKind.AUDIO));
    }

    public FeatureExtractor(@Nonnull MediaSoundTrack audioTrack) {
        this(Collections.singletonList(audioTrack));
    }

    public FeatureExtractor(@Nonnull List<MediaSoundTrack> audioTracks) {
        this.audioTracks = audioTracks;
        for (MediaSoundTrack mst : audioTracks) {
            if (!mst.isTrackEnabled()) continue;
            this.enabledAudioTracks.add(mst);
        }
        this.allChannels = new LinkedList<MediaAudioChannel>();
        StringBuilder chList = new StringBuilder();
        for (MediaSoundTrack track : audioTracks) {
            this.allChannels.addAll(track.channels());
            if (track.isTrackEnabled()) {
                this.enabledTrackChannels.addAll(track.channels());
            }
            chList.append(track.channels().toString().replaceAll(" ", ""));
        }
        this.channelLayoutDescription = chList.toString();
        this.stereoMap = new EnumMap(MediaAudioChannel.class);
        this.surroundMap = new EnumMap(MediaAudioChannel.class);
        if (this.enabledAudioTracks.size() == 1) {
            for (MediaSoundTrack track : this.enabledAudioTracks) {
                List<MediaAudioChannel> channels = track.channels();
                if (channels.size() == 2) {
                    for (MediaAudioChannel ch : channels) {
                        if (!stereoVariants.contains((Object)ch)) continue;
                        this.stereoMap.put(ch, track);
                    }
                    continue;
                }
                if (channels.size() == 8 && track instanceof QtSoundTrack) {
                    if ("SMPTE DTV (L R C LFE Ls Rs Lt Rt)".equalsIgnoreCase(((QtSoundTrack)track).getChannelLayoutName())) {
                        for (MediaAudioChannel ch : channels) {
                            if (surround51Channels.contains((Object)ch)) {
                                this.surroundMap.put(ch, track);
                                continue;
                            }
                            this.stereoMap.put(ch, track);
                        }
                        continue;
                    }
                    if (!"7.1 (L R C LFE Ls Rs Rls Rrs)".equalsIgnoreCase(((QtSoundTrack)track).getChannelLayoutName())) continue;
                    for (MediaAudioChannel ch : channels) {
                        if (!surround71Channels.contains((Object)ch)) continue;
                        this.surroundMap.put(ch, track);
                    }
                    continue;
                }
                if (channels.size() != 6) continue;
                for (MediaAudioChannel ch : channels) {
                    if (!surround51Channels.contains((Object)ch)) continue;
                    this.surroundMap.put(ch, track);
                }
            }
        } else if (this.enabledAudioTracks.size() == 3) {
            for (MediaSoundTrack track : this.enabledAudioTracks) {
                List<MediaAudioChannel> channels = track.channels();
                if (channels.size() == 6) {
                    for (MediaAudioChannel ch : channels) {
                        if (!surround51Channels.contains((Object)ch)) continue;
                        this.surroundMap.put(ch, track);
                    }
                    continue;
                }
                if (channels.size() != 1) continue;
                for (MediaAudioChannel ch : channels) {
                    if (!stereoVariants.contains((Object)ch)) continue;
                    this.stereoMap.put(ch, track);
                }
            }
        } else if (this.enabledAudioTracks.size() == 2) {
            for (MediaSoundTrack track : this.enabledAudioTracks) {
                List<MediaAudioChannel> channels = track.channels();
                if (channels.size() == 6) {
                    for (MediaAudioChannel ch : channels) {
                        if (!surround51Channels.contains((Object)ch)) continue;
                        this.surroundMap.put(ch, track);
                    }
                    continue;
                }
                if (channels.size() > 2) continue;
                for (MediaAudioChannel ch : channels) {
                    if (!stereoVariants.contains((Object)ch)) continue;
                    this.stereoMap.put(ch, track);
                }
            }
        } else if (this.enabledAudioTracks.size() == 8 || this.enabledAudioTracks.size() == 10) {
            for (MediaSoundTrack track : this.enabledAudioTracks) {
                List<MediaAudioChannel> channels = track.channels();
                if (channels.size() != 1) continue;
                for (MediaAudioChannel ch : channels) {
                    if (surround71Channels.contains((Object)ch) && !this.surroundMap.containsKey((Object)ch)) {
                        this.surroundMap.put(ch, track);
                        continue;
                    }
                    if (!stereoVariants.contains((Object)ch)) continue;
                    this.stereoMap.put(ch, track);
                }
            }
        } else if (this.enabledAudioTracks.size() == 7) {
            for (MediaSoundTrack track : this.enabledAudioTracks) {
                List<MediaAudioChannel> channels = track.channels();
                if (channels.size() == 1) {
                    for (MediaAudioChannel ch : channels) {
                        if (!surround51Channels.contains((Object)ch)) continue;
                        this.surroundMap.put(ch, track);
                    }
                    continue;
                }
                if (channels.size() != 2) continue;
                for (MediaAudioChannel ch : channels) {
                    if (!stereoVariants.contains((Object)ch)) continue;
                    this.stereoMap.put(ch, track);
                }
            }
        } else if (this.enabledAudioTracks.size() == 6) {
            for (MediaSoundTrack track : this.enabledAudioTracks) {
                List<MediaAudioChannel> channels = track.channels();
                if (channels.size() != 1) continue;
                for (MediaAudioChannel ch : channels) {
                    if (!surround51Channels.contains((Object)ch)) continue;
                    this.surroundMap.put(ch, track);
                }
            }
        }
        if (this.stereoMap.containsKey((Object)MediaAudioChannel.Lt) || this.stereoMap.containsKey((Object)MediaAudioChannel.Rt)) {
            this.stereoMap.remove((Object)MediaAudioChannel.L);
            this.stereoMap.remove((Object)MediaAudioChannel.R);
        }
    }

    @Nonnull
    public Set<AudioFormat> detectedFormats() {
        return this.detectedFormats;
    }

    @Nonnull
    public String getChannelLayoutDescription() {
        return this.channelLayoutDescription;
    }

    @Nonnull
    public List<MediaAudioChannel> getAllChannels() {
        return this.allChannels;
    }

    public int trackCount() {
        return this.audioTracks.size();
    }

    public int enabledTrackCount() {
        return this.enabledAudioTracks.size();
    }

    public boolean hasValidChannelMap() {
        return this.validChannelMap;
    }

    protected boolean complyChannels(@Nonnull Set<MediaAudioChannel> channels, @Nonnull AudioFormat audioFormat) {
        switch (audioFormat) {
            case stereo: {
                return this.complyStereo(channels);
            }
            case surround_5_1: {
                return this.complySurround51(channels);
            }
            case surround_7_1: {
                return this.complySurround71(channels);
            }
        }
        return true;
    }

    public Map<MediaAudioChannel, MediaSoundTrack> getChannels(@Nonnull AudioFormat audioFormat) {
        if (this.detectedFormats.contains((Object)audioFormat)) {
            switch (audioFormat) {
                case stereo: {
                    return Collections.unmodifiableMap(this.stereoMap);
                }
                case surround_5_1: 
                case surround_7_1: {
                    return Collections.unmodifiableMap(this.surroundMap);
                }
            }
        }
        return Collections.emptyMap();
    }

    private boolean complySurround71(@Nonnull Set<MediaAudioChannel> surround71Channels) {
        return Sets.difference(surround71Channels, FeatureExtractor.surround71Channels).size() == 0;
    }

    private boolean complySurround51(@Nonnull Set<MediaAudioChannel> surround51Channels) {
        return Sets.difference(surround51Channels, FeatureExtractor.surround51Channels).size() == 0;
    }

    private boolean complyStereo(@Nonnull Set<MediaAudioChannel> stereoOnlyChannels) {
        return Sets.difference(stereoOnlyChannels, stereoVariants).size() == 0;
    }

    public String toString() {
        return "[tracks=" + this.audioTracks.size() + ", enabledTracks=" + this.enabledAudioTracks.size() + ", channels=" + this.channelLayoutDescription + ", surround=" + this.surroundMap.size() + ", stereo=" + this.stereoMap.size() + "]" + (this.hasValidChannelMap() ? "" : " NOT VALID");
    }
}

