/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.media.feature.extractor;

import com.apple.jingle.leghorn.media.MediaFactory;
import com.apple.jingle.leghorn.media.feature.AudioFormat;
import com.apple.jingle.leghorn.media.feature.FeatureKind;
import com.apple.jingle.leghorn.media.feature.MediaDvsFeature;
import com.apple.jingle.leghorn.media.feature.MediaScope;
import com.apple.jingle.leghorn.media.feature.SourceAudioGrade;
import com.apple.jingle.leghorn.media.feature.extractor.FeatureExtractor;
import com.apple.jingle.leghorn.media.file.MediaFile;
import com.apple.jingle.leghorn.media.file.MediaFileContext;
import com.apple.jingle.leghorn.media.file.MediaSoundTrack;
import com.apple.jingle.leghorn.media.file.MediaTrackKind;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nonnull;

public class DvsFeatureExtractor
extends FeatureExtractor {
    public DvsFeatureExtractor(@Nonnull MediaFile mediaFile) {
        this(mediaFile.getTracks(MediaSoundTrack.class, MediaTrackKind.AUDIO));
    }

    public DvsFeatureExtractor(@Nonnull MediaSoundTrack audioTrack) {
        this(Collections.singletonList(audioTrack));
    }

    public DvsFeatureExtractor(@Nonnull List<MediaSoundTrack> audioTracks) {
        super(audioTracks);
        if (this.allChannels.size() == 8 && this.surroundMap.size() == 6 && this.stereoMap.size() == 2) {
            this.detectedFormats = EnumSet.of(AudioFormat.stereo, AudioFormat.surround_5_1);
            this.validChannelMap = true;
        } else if (this.allChannels.size() == 2 && this.surroundMap.size() == 0 && this.stereoMap.size() == 2) {
            this.detectedFormats = EnumSet.of(AudioFormat.stereo);
            this.validChannelMap = true;
        } else {
            this.detectedFormats = EnumSet.noneOf(AudioFormat.class);
            this.validChannelMap = false;
        }
    }

    @Nonnull
    public Collection<MediaDvsFeature> createFeatures(@Nonnull MediaFileContext ctx) {
        if (!this.validChannelMap) {
            return Collections.emptyList();
        }
        ArrayList<MediaDvsFeature> features = new ArrayList<MediaDvsFeature>(2);
        if (!this.surroundMap.isEmpty() && this.surroundMap.size() < 8) {
            features.add(MediaFactory.newDvsFeature(ctx, MediaScope.source, FeatureKind.DVS, SourceAudioGrade.surround_5_1, this.surroundMap));
        }
        if (!this.stereoMap.isEmpty()) {
            features.add(MediaFactory.newDvsFeature(ctx, MediaScope.source, FeatureKind.DVS, SourceAudioGrade.stereo, this.stereoMap));
        }
        return features;
    }

    @Override
    public String toString() {
        return "DvsFeatureExtractor" + super.toString();
    }
}

