/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.media.feature.extractor;

import com.apple.jingle.leghorn.media.MediaFactory;
import com.apple.jingle.leghorn.media.feature.AudioFormat;
import com.apple.jingle.leghorn.media.feature.FeatureKind;
import com.apple.jingle.leghorn.media.feature.MediaAudioFeature;
import com.apple.jingle.leghorn.media.feature.MediaScope;
import com.apple.jingle.leghorn.media.feature.SourceAudioGrade;
import com.apple.jingle.leghorn.media.feature.extractor.FeatureExtractor;
import com.apple.jingle.leghorn.media.file.MediaFile;
import com.apple.jingle.leghorn.media.file.MediaFileContext;
import com.apple.jingle.leghorn.media.file.MediaSoundTrack;
import com.apple.jingle.leghorn.media.file.MediaTrackKind;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nonnull;

public class AudioFeatureExtractor
extends FeatureExtractor {
    public AudioFeatureExtractor(@Nonnull MediaFile mediaFile) {
        this(mediaFile.getTracks(MediaSoundTrack.class, MediaTrackKind.AUDIO));
    }

    public AudioFeatureExtractor(@Nonnull MediaSoundTrack audioTrack) {
        this(Collections.singletonList(audioTrack));
    }

    public AudioFeatureExtractor(@Nonnull List<MediaSoundTrack> audioTracks) {
        super(audioTracks);
        if (this.enabledTrackChannels.size() == 10 && this.surroundMap.size() == 8 && this.stereoMap.size() == 2) {
            this.detectedFormats = EnumSet.of(AudioFormat.stereo, AudioFormat.surround_7_1);
            this.validChannelMap = true;
        } else if (this.enabledTrackChannels.size() == 8 && this.surroundMap.size() == 6 && this.complyChannels(this.surroundMap.keySet(), AudioFormat.surround_5_1) && this.stereoMap.size() == 2) {
            this.detectedFormats = EnumSet.of(AudioFormat.stereo, AudioFormat.surround_5_1);
            this.validChannelMap = true;
        } else if (this.enabledTrackChannels.size() == 6 && this.surroundMap.size() == 6 && this.stereoMap.size() == 0) {
            this.detectedFormats = EnumSet.of(AudioFormat.surround_5_1);
            this.validChannelMap = true;
        } else if (this.enabledTrackChannels.size() == 8 && this.surroundMap.size() == 8 && this.stereoMap.size() == 0) {
            this.detectedFormats = EnumSet.of(AudioFormat.surround_7_1);
            this.validChannelMap = true;
        } else if (this.enabledTrackChannels.size() == 2 && this.surroundMap.size() == 0 && this.stereoMap.size() == 2) {
            this.detectedFormats = EnumSet.of(AudioFormat.stereo);
            this.validChannelMap = true;
        } else {
            this.detectedFormats = EnumSet.noneOf(AudioFormat.class);
            this.validChannelMap = false;
        }
    }

    @Nonnull
    public Collection<MediaAudioFeature> createFeatures(@Nonnull MediaFileContext ctx) {
        if (!this.validChannelMap) {
            return Collections.emptyList();
        }
        ArrayList<MediaAudioFeature> features = new ArrayList<MediaAudioFeature>(2);
        if (!this.surroundMap.isEmpty()) {
            if (this.surroundMap.size() >= 8) {
                features.add(MediaFactory.newAudioFeature(ctx, MediaScope.source, FeatureKind.AUDIO, SourceAudioGrade.surround_7_1, this.surroundMap));
            } else {
                features.add(MediaFactory.newAudioFeature(ctx, MediaScope.source, FeatureKind.AUDIO, SourceAudioGrade.surround_5_1, this.surroundMap));
            }
        }
        if (!this.stereoMap.isEmpty()) {
            features.add(MediaFactory.newAudioFeature(ctx, MediaScope.source, FeatureKind.AUDIO, SourceAudioGrade.stereo, this.stereoMap));
        }
        return features;
    }

    @Override
    public String toString() {
        return "AudioFeatureExtractor" + super.toString();
    }
}

