/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.media.feature;

import com.apple.jingle.g5.MediaGrade;
import com.apple.jingle.leghorn.media.feature.AudioFormat;
import com.apple.jingle.leghorn.media.feature.MediaFeature;
import com.apple.jingle.leghorn.media.index.IndexedMap;
import com.apple.jingle.leghorn.media.index.IndexedMapKey;
import com.apple.jingle.leghorn.media.index.ValueSet;
import java.util.NoSuchElementException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public enum SourceAudioGrade implements MediaGrade
{
    stereo,
    surround_5_1,
    surround_7_1,
    objectBased;

    @Nullable
    private transient IndexedMapKey<MediaGrade> indexKey;

    @Override
    public boolean meetsCriteria(@Nonnull MediaFeature feature) {
        return feature.getMediaGrade() == this;
    }

    @Override
    public IndexedMapKey<MediaGrade> indexKey() {
        if (this.indexKey == null) {
            this.indexKey = new IndexedMapKey<SourceAudioGrade>(indexKeyType, this);
        }
        return this.indexKey;
    }

    @Override
    public void filter(@Nonnull IndexedMap<? extends Object> indexedMap, @Nonnull ValueSet<? extends Object> values) {
        values.retainAll(indexedMap.getValuesForKey(this.indexKey()));
    }

    @Override
    public int getMediaGradeTypeId() {
        return 0;
    }

    @Override
    public String getName() {
        return this.name();
    }

    @Nonnull
    public AudioFormat toAudioFormat() {
        switch (this) {
            case objectBased: {
                return AudioFormat.objectBased;
            }
            case stereo: {
                return AudioFormat.stereo;
            }
            case surround_5_1: {
                return AudioFormat.surround_5_1;
            }
            case surround_7_1: {
                return AudioFormat.surround_7_1;
            }
        }
        throw new NoSuchElementException(this.toString());
    }

    @Nonnull
    public static SourceAudioGrade valueOf(@Nonnull AudioFormat format) {
        switch (format) {
            case objectBased: {
                return objectBased;
            }
            case stereo: {
                return stereo;
            }
            case surround_5_1: {
                return surround_5_1;
            }
            case surround_7_1: {
                return surround_7_1;
            }
        }
        throw new NoSuchElementException(format.toString());
    }
}

