/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.media.feature;

import com.apple.jingle.foghorn.media.FrameGeometry;
import com.apple.jingle.foghorn.media.types.ColorSpace;
import com.apple.jingle.foghorn.media.types.FieldOrdering;
import com.apple.jingle.leghorn.media.feature.MediaFeature;
import com.apple.jingle.leghorn.quicktime.GraphicsMode;
import com.apple.jingle.leghorn.timecode.MediaTime;
import com.apple.jingle.leghorn.timecode.SampleRate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface MediaVideoLikeFeature
extends MediaFeature {
    @Nonnull
    public FrameGeometry.Dimensions getVideoDisplayDimensions();

    @Nonnull
    public FrameGeometry.Dimensions getVideoEncodedDimensions();

    @Nonnull
    public GraphicsMode getGraphicsMode();

    @Nonnull
    public SampleRate getNominalFrameRate();

    public boolean getUniformFrameRate();

    public long getTimeScale();

    @Nullable
    public FrameGeometry.Pasp getVideoPasp();

    @Nonnull
    public FrameGeometry getVideoFrameGeometry();

    @Nonnull
    public FieldOrdering getFieldOrdering();

    @Nullable
    public ColorSpace colorSpace();

    public boolean isProgressive();

    public boolean is4k();

    public double getGamma();

    @Nonnull
    public MediaTime getDuration();

    public long getSampleCount();

    public int getSampleDescriptionCount();

    @Nonnull
    public String getCodecName();

    public long getFieldCount();

    public static final class Util {
        public static boolean is4k(MediaVideoLikeFeature feature) {
            FrameGeometry.Dimensions dimensions2 = feature.getVideoDisplayDimensions();
            return Math.max(dimensions2.getWidth(), dimensions2.getHeight()) > 1920L;
        }
    }
}

