/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.media.feature;

import com.apple.jingle.leghorn.media.feature.MediaFeature;
import com.apple.jingle.leghorn.media.index.IndexedMap;
import com.apple.jingle.leghorn.media.index.IndexedMapFilter;
import com.apple.jingle.leghorn.media.index.IndexedMapKey;
import com.apple.jingle.leghorn.media.index.IndexedMapKeySupplier;
import com.apple.jingle.leghorn.media.index.IndexedMapKeyType;
import com.apple.jingle.leghorn.media.index.ValueSet;
import com.apple.jingle.leghorn.media.index.ValueSetFilter;
import java.io.Serializable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public enum MediaScope implements ValueSetFilter<MediaFeature>,
IndexedMapKeySupplier<MediaScope>,
IndexedMapFilter<MediaFeature>,
Serializable
{
    raw,
    source,
    transformedSource,
    proposed,
    intermediate,
    bundled,
    liveOnSite;

    @Nonnull
    public static final IndexedMapKeyType<MediaScope> indexKeyType;
    @Nullable
    private transient IndexedMapKey<MediaScope> indexKey;

    @Override
    public boolean meetsCriteria(@Nonnull MediaFeature feature) {
        return feature.getMediaFeatureScope() == this;
    }

    @Override
    public IndexedMapKey<MediaScope> indexKey() {
        if (this.indexKey == null) {
            this.indexKey = new IndexedMapKey<MediaScope>(indexKeyType, this);
        }
        return this.indexKey;
    }

    @Override
    @Nonnull
    public void filter(@Nonnull IndexedMap<? extends MediaFeature> indexedMap, ValueSet<? extends MediaFeature> values) {
        values.retainAll(indexedMap.getValuesForKey(this.indexKey()));
    }

    @Nullable
    public static final MediaScope mediaScopeForName(@Nonnull String name) {
        return MediaScope.valueOf(name);
    }

    static {
        indexKeyType = IndexedMapKeyType.of("scope", MediaScope.class);
    }
}

