/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.media.feature;

import com.apple.jingle.leghorn.media.MediaUtil;
import com.apple.jingle.leghorn.media.feature.MediaFeature;
import com.apple.jingle.leghorn.media.index.IndexedMap;
import com.apple.jingle.leghorn.media.index.IndexedMapFilter;
import com.apple.jingle.leghorn.media.index.IndexedMapKey;
import com.apple.jingle.leghorn.media.index.IndexedMapKeySupplier;
import com.apple.jingle.leghorn.media.index.IndexedMapKeyType;
import com.apple.jingle.leghorn.media.index.ValueSet;
import java.io.Serializable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface MediaInstance
extends IndexedMapKeySupplier<MediaInstance>,
IndexedMapFilter<MediaFeature>,
Serializable {
    public static final IndexedMapKeyType<MediaInstance> indexKeyType = IndexedMapKeyType.of("uid", MediaInstance.class, MediaUtil.nullSafeGenericComparator());

    public static class MediaInstanceString
    implements MediaInstance,
    Comparable<MediaInstanceString> {
        private static final long serialVersionUID = 1L;
        @Nullable
        private transient IndexedMapKey<MediaInstance> indexKey;
        @Nonnull
        private final String value;

        public MediaInstanceString(@Nonnull String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        public boolean equals(Object obj) {
            return obj instanceof MediaInstanceString && ((MediaInstanceString)obj).value.equals(this.value);
        }

        @Override
        public IndexedMapKey<MediaInstance> indexKey() {
            if (this.indexKey == null) {
                this.indexKey = new IndexedMapKey<MediaInstanceString>(indexKeyType, this);
            }
            return this.indexKey;
        }

        @Override
        @Nonnull
        public void filter(@Nonnull IndexedMap<? extends MediaFeature> indexedMap, ValueSet<? extends MediaFeature> values) {
            values.retainAll(indexedMap.getValuesForKey(this.indexKey()));
        }

        @Override
        public int compareTo(@Nonnull MediaInstanceString o) {
            return this.value.compareTo(o.value);
        }
    }
}

