/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.media.feature;

import com.apple.jingle.leghorn.media.MediaUtil;
import com.apple.jingle.leghorn.media.index.IndexedMap;
import com.apple.jingle.leghorn.media.index.IndexedMapFilter;
import com.apple.jingle.leghorn.media.index.IndexedMapKey;
import com.apple.jingle.leghorn.media.index.IndexedMapKeySupplier;
import com.apple.jingle.leghorn.media.index.IndexedMapKeyType;
import com.apple.jingle.leghorn.media.index.ValueSet;
import java.io.Serializable;
import java.util.NoSuchElementException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface MediaFormat
extends IndexedMapKeySupplier<MediaFormat>,
IndexedMapFilter<Object>,
Serializable {
    public static final IndexedMapKeyType<MediaFormat> indexKeyType = IndexedMapKeyType.of("format", MediaFormat.class, MediaUtil.nullSafeGenericComparator());

    public String getName();

    public int getMediaFormatTypeId();

    public static enum CutPreviewFormat implements MediaFormat
    {
        generic,
        tvCutPreview;

        @Nullable
        private transient IndexedMapKey<MediaFormat> indexKey;

        @Override
        public IndexedMapKey<MediaFormat> indexKey() {
            if (this.indexKey == null) {
                this.indexKey = new IndexedMapKey<CutPreviewFormat>(indexKeyType, this);
            }
            return this.indexKey;
        }

        @Override
        @Nonnull
        public void filter(@Nonnull IndexedMap<? extends Object> indexedMap, ValueSet<? extends Object> values) {
            values.retainAll(indexedMap.getValuesForKey(this.indexKey()));
        }

        @Nonnull
        public static final ThumbnailFormat mediaFormatForName(String name) {
            return Util.mediaFormatForName(ThumbnailFormat.class, name);
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[" + this.name() + "]";
        }

        @Override
        @Nonnull
        public String getName() {
            return this.name();
        }

        @Override
        public int getMediaFormatTypeId() {
            return 10;
        }
    }

    public static enum PreviewImageFormat implements MediaFormat
    {
        video,
        nonVideo;

        @Nullable
        private transient IndexedMapKey<MediaFormat> indexKey;

        @Override
        public IndexedMapKey<MediaFormat> indexKey() {
            if (this.indexKey == null) {
                this.indexKey = new IndexedMapKey<PreviewImageFormat>(indexKeyType, this);
            }
            return this.indexKey;
        }

        @Override
        @Nonnull
        public void filter(@Nonnull IndexedMap<? extends Object> indexedMap, ValueSet<? extends Object> values) {
            values.retainAll(indexedMap.getValuesForKey(this.indexKey()));
        }

        @Nonnull
        public static final ThumbnailFormat mediaFormatForName(String name) {
            return Util.mediaFormatForName(ThumbnailFormat.class, name);
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[" + this.name() + "]";
        }

        @Override
        @Nonnull
        public String getName() {
            return this.name();
        }

        @Override
        public int getMediaFormatTypeId() {
            return 9;
        }
    }

    public static enum ProductionStillType implements MediaFormat
    {
        provided,
        generated,
        preview;

        @Nullable
        private transient IndexedMapKey<MediaFormat> indexKey;

        @Override
        public IndexedMapKey<MediaFormat> indexKey() {
            if (this.indexKey == null) {
                this.indexKey = new IndexedMapKey<ProductionStillType>(indexKeyType, this);
            }
            return this.indexKey;
        }

        @Override
        @Nonnull
        public void filter(@Nonnull IndexedMap<? extends Object> indexedMap, ValueSet<? extends Object> values) {
            values.retainAll(indexedMap.getValuesForKey(this.indexKey()));
        }

        @Nonnull
        public static final ProductionStillType mediaFormatForName(String name) {
            return Util.mediaFormatForName(ProductionStillType.class, name);
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[" + this.name() + "]";
        }

        @Override
        @Nonnull
        public String getName() {
            return this.name();
        }

        @Override
        public int getMediaFormatTypeId() {
            return 8;
        }
    }

    public static enum ThumbnailFormat implements MediaFormat
    {
        provided,
        generated;

        @Nullable
        private transient IndexedMapKey<MediaFormat> indexKey;

        @Override
        public IndexedMapKey<MediaFormat> indexKey() {
            if (this.indexKey == null) {
                this.indexKey = new IndexedMapKey<ThumbnailFormat>(indexKeyType, this);
            }
            return this.indexKey;
        }

        @Override
        @Nonnull
        public void filter(@Nonnull IndexedMap<? extends Object> indexedMap, ValueSet<? extends Object> values) {
            values.retainAll(indexedMap.getValuesForKey(this.indexKey()));
        }

        @Nonnull
        public static final ThumbnailFormat mediaFormatForName(String name) {
            return Util.mediaFormatForName(ThumbnailFormat.class, name);
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[" + this.name() + "]";
        }

        @Override
        @Nonnull
        public String getName() {
            return this.name();
        }

        @Override
        public int getMediaFormatTypeId() {
            return 7;
        }
    }

    public static enum SubtitlesFormat implements MediaFormat
    {
        itt,
        texml,
        vtt,
        vttv2,
        vttv3,
        tx3g,
        quickTimeContainer;

        @Nullable
        private transient IndexedMapKey<MediaFormat> indexKey;

        @Override
        public IndexedMapKey<MediaFormat> indexKey() {
            if (this.indexKey == null) {
                this.indexKey = new IndexedMapKey<SubtitlesFormat>(indexKeyType, this);
            }
            return this.indexKey;
        }

        @Override
        @Nonnull
        public void filter(@Nonnull IndexedMap<? extends Object> indexedMap, ValueSet<? extends Object> values) {
            values.retainAll(indexedMap.getValuesForKey(this.indexKey()));
        }

        @Nonnull
        public static final SubtitlesFormat mediaFormatForName(String name) {
            return Util.mediaFormatForName(SubtitlesFormat.class, name);
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[" + this.name() + "]";
        }

        @Override
        @Nonnull
        public String getName() {
            return this.name();
        }

        @Override
        public int getMediaFormatTypeId() {
            return 3;
        }
    }

    public static enum CaptionsFormat implements MediaFormat
    {
        scc,
        quickTimeContainer,
        sliced;

        @Nullable
        private transient IndexedMapKey<MediaFormat> indexKey;

        @Override
        public IndexedMapKey<MediaFormat> indexKey() {
            if (this.indexKey == null) {
                this.indexKey = new IndexedMapKey<CaptionsFormat>(indexKeyType, this);
            }
            return this.indexKey;
        }

        @Override
        @Nonnull
        public void filter(@Nonnull IndexedMap<? extends Object> indexedMap, ValueSet<? extends Object> values) {
            values.retainAll(indexedMap.getValuesForKey(this.indexKey()));
        }

        @Nonnull
        public static final CaptionsFormat mediaFormatForName(String name) {
            return Util.mediaFormatForName(CaptionsFormat.class, name);
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[" + this.name() + "]";
        }

        @Override
        @Nonnull
        public String getName() {
            return this.name();
        }

        @Override
        public int getMediaFormatTypeId() {
            return 2;
        }
    }

    public static enum CommonFormat implements MediaFormat
    {
        unknown,
        generic;

        @Nullable
        private transient IndexedMapKey<MediaFormat> indexKey;

        @Override
        public IndexedMapKey<MediaFormat> indexKey() {
            if (this.indexKey == null) {
                this.indexKey = new IndexedMapKey<CommonFormat>(indexKeyType, this);
            }
            return this.indexKey;
        }

        @Override
        @Nonnull
        public void filter(@Nonnull IndexedMap<? extends Object> indexedMap, ValueSet<? extends Object> values) {
            values.retainAll(indexedMap.getValuesForKey(this.indexKey()));
        }

        @Nonnull
        public static final CommonFormat mediaFormatForName(String name) {
            return Util.mediaFormatForName(CommonFormat.class, name, unknown);
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[" + this.name() + "]";
        }

        @Override
        @Nonnull
        public String getName() {
            return this.name();
        }

        @Override
        public int getMediaFormatTypeId() {
            return 1;
        }
    }

    public static class Util {
        public static final <MF extends Enum<MF>> MF mediaFormatForName(Class<MF> type, String key, MF defaultValue) {
            try {
                if (key != null) {
                    return Enum.valueOf(type, key);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return defaultValue;
        }

        public static final <MF extends Enum<MF>> MF mediaFormatForName(Class<MF> type, String key) throws NoSuchElementException {
            try {
                if (key != null) {
                    return Enum.valueOf(type, key);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new NoSuchElementException(type.getSimpleName() + "[" + key + "]");
        }
    }
}

