/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.media.feature;

import com.apple.jingle.g5.MediaGrade;
import com.apple.jingle.leghorn.media.feature.FeatureKind;
import com.apple.jingle.leghorn.media.feature.MediaFeature;
import com.apple.jingle.leghorn.media.feature.MediaFormat;
import com.apple.jingle.leghorn.media.feature.MediaScope;
import com.apple.jingle.leghorn.media.index.IndexedMapFilter;
import com.apple.jingle.leghorn.media.index.IndexedMapKeyType;
import com.apple.jingle.locale.LocaleCode;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class MediaFeatureKeys {
    public static final IndexedMapKeyType<LocaleCode> localeCodeIdx = IndexedMapKeyType.of("localeCode", LocaleCode.class, LocaleCodeComparator.INSTANCE);
    public static final IndexedMapKeyType<String> mediaNameIdx = IndexedMapKeyType.of("name", String.class);
    public static final IndexedMapKeyType<String> countryCodeIdx = IndexedMapKeyType.of("cc", String.class);

    private MediaFeatureKeys() {
    }

    public static IndexedMapFilter.KeyInCriteria<MediaScope, MediaFeature> withScope(MediaScope ... values) {
        if (values == null || values.length == 0 || values.length == 1 && values[0] == null) {
            return null;
        }
        return new IndexedMapFilter.KeyInCriteria(MediaScope.indexKeyType, (Serializable[])values);
    }

    public static IndexedMapFilter.KeyInCriteria<FeatureKind, MediaFeature> withKind(FeatureKind ... values) {
        if (values == null || values.length == 0 || values.length == 1 && values[0] == null) {
            return null;
        }
        return new IndexedMapFilter.KeyInCriteria(FeatureKind.indexKeyType, (Serializable[])values);
    }

    public static IndexedMapFilter.KeyInCriteria<FeatureKind, MediaFeature> withKind(@Nonnull Collection<? extends FeatureKind> values) {
        return new IndexedMapFilter.KeyInCriteria<FeatureKind, MediaFeature>(FeatureKind.indexKeyType, values);
    }

    public static IndexedMapFilter.KeyInCriteria<MediaGrade, MediaFeature> withGrade(@Nonnull Collection<? extends MediaGrade> values) {
        return new IndexedMapFilter.KeyInCriteria<MediaGrade, MediaFeature>(MediaGrade.indexKeyType, values);
    }

    public static IndexedMapFilter.KeyInCriteria<MediaGrade, MediaFeature> withGrade(MediaGrade ... values) {
        if (values == null || values.length == 0 || values.length == 1 && values[0] == null) {
            return null;
        }
        return new IndexedMapFilter.KeyInCriteria(MediaGrade.indexKeyType, (Serializable[])values);
    }

    public static IndexedMapFilter.KeyInCriteria<LocaleCode, MediaFeature> withLocale(LocaleCode ... values) {
        if (values == null || values.length == 0 || values.length == 1 && values[0] == null) {
            return null;
        }
        return MediaFeatureKeys.withLocale(new HashSet<LocaleCode>(Arrays.asList(values)));
    }

    public static IndexedMapFilter.KeyInCriteria<LocaleCode, MediaFeature> withLocale(@Nonnull Set<LocaleCode> values) {
        return new IndexedMapFilter.KeyInCriteria<LocaleCode, MediaFeature>(localeCodeIdx, (Collection<LocaleCode>)values);
    }

    public static IndexedMapFilter.KeyInCriteria<MediaFormat, MediaFeature> withFormat(@Nonnull Collection<? extends MediaFormat> values) {
        return new IndexedMapFilter.KeyInCriteria<MediaFormat, MediaFeature>(MediaFormat.indexKeyType, values);
    }

    public static IndexedMapFilter.KeyInCriteria<MediaFormat, Object> withFormat(MediaFormat ... values) {
        if (values == null || values.length == 0 || values.length == 1 && values[0] == null) {
            return null;
        }
        return new IndexedMapFilter.KeyInCriteria(MediaFormat.indexKeyType, (Serializable[])values);
    }

    @Nullable
    public static IndexedMapFilter.KeyInCriteria<String, MediaFeature> withCountryCode(String ... values) {
        if (values == null || values.length == 0 || values.length == 1 && values[0] == null) {
            return null;
        }
        return new IndexedMapFilter.KeyInCriteria(countryCodeIdx, (Serializable[])values);
    }

    @Nonnull
    public static IndexedMapFilter.KeyInCriteria<String, MediaFeature> withCountryCode(@Nonnull Collection<String> values) {
        return new IndexedMapFilter.KeyInCriteria<String, MediaFeature>(countryCodeIdx, values);
    }

    public static enum LocaleCodeComparator implements Comparator<LocaleCode>
    {
        INSTANCE{

            @Override
            public int compare(@Nonnull LocaleCode o1, @Nonnull LocaleCode o2) {
                return o1.getName().compareToIgnoreCase(o2.getName());
            }
        };

    }
}

