/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.media.feature;

import com.apple.jingle.g5.MediaGrade;
import com.apple.jingle.leghorn.media.MediaUtil;
import com.apple.jingle.leghorn.media.feature.CountryCodeList;
import com.apple.jingle.leghorn.media.feature.FeatureKind;
import com.apple.jingle.leghorn.media.feature.MediaFeature;
import com.apple.jingle.leghorn.media.feature.MediaFeatureKeys;
import com.apple.jingle.leghorn.media.feature.MediaFormat;
import com.apple.jingle.leghorn.media.feature.MediaInstance;
import com.apple.jingle.leghorn.media.feature.MediaScope;
import com.apple.jingle.leghorn.media.index.IndexedMapKeySet;
import com.apple.jingle.locale.LocaleCode;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
@Immutable
public class MediaFeatureKey
implements Comparable<MediaFeatureKey>,
Serializable {
    private static final long serialVersionUID = 1L;
    @Nullable
    private final MediaScope mediaScope;
    @Nonnull
    private final FeatureKind featureKind;
    @Nullable
    private final MediaFormat mediaFormat;
    @Nullable
    private final MediaInstance mediaInstance;
    @Nullable
    private final MediaGrade mediaGrade;
    @Nullable
    private final LocaleCode localeCode;
    @Nonnull
    private final CountryCodeList countryCodes;

    public MediaFeatureKey(@Nonnull MediaFeature mediaFeature) {
        this(null, mediaFeature.getFeatureKind(), null, new MediaInstance.MediaInstanceString(mediaFeature.getMediaName()), null, mediaFeature.getLocale());
    }

    public MediaFeatureKey(@Nullable MediaScope mediaFeatureScope, @Nonnull FeatureKind featureKind) {
        this(mediaFeatureScope, featureKind, null, null, null, null);
    }

    public MediaFeatureKey(@Nullable MediaScope mediaFeatureScope, @Nonnull FeatureKind featureKind, @Nullable MediaFormat mediaFormat, @Nullable MediaInstance mediaInstance, @Nullable MediaGrade mediaGrade, @Nullable LocaleCode localeCode) {
        this.mediaScope = mediaFeatureScope;
        this.featureKind = featureKind;
        this.mediaFormat = mediaFormat;
        this.mediaInstance = mediaInstance;
        this.mediaGrade = mediaGrade;
        this.localeCode = localeCode;
        this.countryCodes = CountryCodeList.emptyCountryCodeList;
    }

    public MediaFeatureKey(@Nullable MediaScope mediaFeatureScope, @Nonnull FeatureKind featureKind, @Nullable MediaFormat mediaFormat, @Nullable MediaInstance mediaInstance, @Nullable MediaGrade mediaGrade, @Nullable LocaleCode localeCode, @Nonnull CountryCodeList countryCodes) {
        this.mediaScope = mediaFeatureScope;
        this.featureKind = featureKind;
        this.mediaFormat = mediaFormat;
        this.mediaInstance = mediaInstance;
        this.mediaGrade = mediaGrade;
        this.localeCode = localeCode;
        this.countryCodes = countryCodes;
    }

    @Nullable
    public MediaScope mediaScope() {
        return this.mediaScope;
    }

    @Nonnull
    public FeatureKind featureKind() {
        return this.featureKind;
    }

    @Nullable
    public MediaFormat mediaFormat() {
        return this.mediaFormat;
    }

    @Nullable
    public MediaInstance mediaInstance() {
        return this.mediaInstance;
    }

    @Nullable
    public MediaGrade mediaGrade() {
        return this.mediaGrade;
    }

    @Nullable
    public LocaleCode localeCode() {
        return this.localeCode;
    }

    @Nonnull
    public CountryCodeList countryCodes() {
        return this.countryCodes;
    }

    @Nonnull
    public MediaFeatureKey setCountryCodes(CountryCodeList countryCodes) {
        if (countryCodes == null || countryCodes.isEmpty()) {
            if (this.countryCodes.isEmpty()) {
                return this;
            }
            return new MediaFeatureKey(this.mediaScope, this.featureKind, this.mediaFormat, this.mediaInstance, this.mediaGrade, this.localeCode, CountryCodeList.emptyCountryCodeList);
        }
        return new MediaFeatureKey(this.mediaScope, this.featureKind, this.mediaFormat, this.mediaInstance, this.mediaGrade, this.localeCode, countryCodes);
    }

    public int hashCode() {
        return Objects.hash(this.mediaScope, this.featureKind, this.mediaFormat, this.mediaInstance, this.mediaGrade, this.localeCode, this.countryCodes);
    }

    public boolean equals(Object obj) {
        if (obj instanceof MediaFeatureKey) {
            MediaFeatureKey comp = (MediaFeatureKey)obj;
            return Objects.equals(this.mediaScope, comp.mediaScope) && Objects.equals(this.featureKind, comp.featureKind) && Objects.equals(this.mediaFormat, comp.mediaFormat) && Objects.equals(this.mediaInstance, comp.mediaInstance) && Objects.equals(this.mediaGrade, comp.mediaGrade) && Objects.equals(this.localeCode, comp.localeCode) && this.countryCodes.equals(comp.countryCodes);
        }
        return false;
    }

    @Override
    public int compareTo(@Nonnull MediaFeatureKey o) {
        int diff = MediaUtil.nullSafeComparator().compare(this.mediaScope, o.mediaScope);
        if (diff != 0) {
            return diff;
        }
        diff = this.featureKind.compareTo(o.featureKind);
        if (diff != 0) {
            return diff;
        }
        diff = MediaUtil.nullSafeGenericComparator().compare(this.mediaFormat, o.mediaFormat);
        if (diff != 0) {
            return diff;
        }
        diff = MediaUtil.nullSafeGenericComparator().compare(this.mediaInstance, o.mediaInstance);
        if (diff != 0) {
            return diff;
        }
        diff = MediaUtil.nullSafeGenericComparator().compare(this.mediaGrade, o.mediaGrade);
        if (diff != 0) {
            return diff;
        }
        diff = MediaUtil.nullSafeGenericComparator().compare(this.localeCode, o.localeCode);
        if (diff != 0) {
            return diff;
        }
        diff = this.countryCodes.compareTo(o.countryCodes);
        return diff;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.mediaScope != null) {
            if (sb.length() != 0) {
                sb.append('.');
            }
            sb.append(this.mediaScope.name());
        }
        if (this.featureKind != null) {
            if (sb.length() != 0) {
                sb.append('.');
            }
            sb.append(this.featureKind.name());
        }
        if (this.mediaFormat != null) {
            if (sb.length() != 0) {
                sb.append('.');
            }
            sb.append(this.mediaFormat);
        }
        if (this.mediaInstance != null) {
            if (sb.length() != 0) {
                sb.append('.');
            }
            sb.append(this.mediaInstance);
        }
        if (this.mediaGrade != null) {
            if (sb.length() != 0) {
                sb.append('.');
            }
            sb.append(this.mediaGrade);
        }
        if (this.localeCode != null) {
            if (sb.length() != 0) {
                sb.append('.');
            }
            sb.append(this.localeCode.toString());
        }
        if (this.countryCodes.isEmpty()) {
            return "MediaFeatureKey[" + sb + "]";
        }
        return "MediaFeatureKey[" + sb + "] " + this.countryCodes;
    }

    @Nonnull
    public IndexedMapKeySet buildIndexKey(@Nonnull IndexedMapKeySet indexKeys) {
        indexKeys.add(MediaScope.indexKeyType, this.mediaScope);
        indexKeys.add(FeatureKind.indexKeyType, this.featureKind);
        indexKeys.add(MediaFormat.indexKeyType, this.mediaFormat);
        indexKeys.add(MediaInstance.indexKeyType, this.mediaInstance);
        indexKeys.add(MediaGrade.indexKeyType, this.mediaGrade);
        indexKeys.add(MediaFeatureKeys.localeCodeIdx, this.localeCode);
        return indexKeys;
    }

    @Nullable
    public MediaFeatureKey lessSpecific() {
        if (!this.countryCodes.isEmpty()) {
            return new MediaFeatureKey(this.mediaScope, this.featureKind, this.mediaFormat, this.mediaInstance, this.mediaGrade, this.localeCode);
        }
        if (this.localeCode != null) {
            return new MediaFeatureKey(this.mediaScope, this.featureKind, this.mediaFormat, this.mediaInstance, this.mediaGrade, null);
        }
        if (this.mediaGrade != null) {
            return new MediaFeatureKey(this.mediaScope, this.featureKind, this.mediaFormat, this.mediaInstance, null, null);
        }
        if (this.mediaInstance != null) {
            return new MediaFeatureKey(this.mediaScope, this.featureKind, this.mediaFormat, null, null, null);
        }
        if (this.mediaFormat != null) {
            return new MediaFeatureKey(this.mediaScope, this.featureKind, null, null, null, null);
        }
        if (this.featureKind != null && this.mediaScope != null) {
            return new MediaFeatureKey(this.mediaScope, null, null, null, null, null);
        }
        return null;
    }
}

