/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.media.feature;

import java.util.Map;
import java.util.NoSuchElementException;
import java.util.TreeMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public enum MediaAudioChannel {
    L("Left"),
    R("Right"),
    C("Center", "Centre"),
    Ls("Left Surround"),
    Rs("Right Surround"),
    LFE("LFE Screen"),
    Lt("Left Total"),
    Rt("Right Total"),
    Lrs("Left Rear Surround", "Rls", "Rear Surround Left"),
    Rrs("Right Rear Surround", "Rear Surround Right"),
    Mono(new String[0]),
    Unknown(new String[0]);

    @Nonnull
    private final String[] altNames;
    private static volatile Map<String, MediaAudioChannel> labelToChannelMap;

    private MediaAudioChannel(String ... altNames) {
        this.altNames = altNames;
    }

    private static final Map<String, MediaAudioChannel> mkChMap() {
        TreeMap<String, MediaAudioChannel> chMap = new TreeMap<String, MediaAudioChannel>(String.CASE_INSENSITIVE_ORDER);
        for (MediaAudioChannel ch : MediaAudioChannel.values()) {
            chMap.put(ch.name(), ch);
            for (String altName : ch.altNames) {
                chMap.put(altName, ch);
            }
        }
        return chMap;
    }

    @Nullable
    public static MediaAudioChannel tryGet(@Nullable String chLabel) {
        if (null != chLabel) {
            return labelToChannelMap.get(chLabel);
        }
        return null;
    }

    @Nonnull
    public static MediaAudioChannel get(@Nullable String chLabel, @Nonnull MediaAudioChannel defaultValue) {
        MediaAudioChannel value;
        if (null != chLabel && null != (value = labelToChannelMap.get(chLabel))) {
            return value;
        }
        return defaultValue;
    }

    @Nonnull
    public static MediaAudioChannel get(@Nullable String chLabel) throws NoSuchElementException {
        MediaAudioChannel ch = MediaAudioChannel.tryGet(chLabel);
        if (null != ch) {
            return ch;
        }
        throw new NoSuchElementException("Channel[" + chLabel + "]");
    }

    static {
        labelToChannelMap = MediaAudioChannel.mkChMap();
    }
}

