/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.media.feature;

import com.apple.jingle.g5.MediaKind;
import com.apple.jingle.leghorn.media.feature.MediaFeature;
import com.apple.jingle.leghorn.media.index.IndexedMap;
import com.apple.jingle.leghorn.media.index.IndexedMapFilter;
import com.apple.jingle.leghorn.media.index.IndexedMapKey;
import com.apple.jingle.leghorn.media.index.IndexedMapKeyType;
import com.apple.jingle.leghorn.media.index.ValueSet;
import com.apple.jingle.leghorn.media.index.ValueSetFilter;
import java.io.Serializable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public enum FeatureKind implements ValueSetFilter<MediaFeature>,
IndexedMapFilter<MediaFeature>,
Serializable
{
    VIDEO(MediaKind.VIDEO),
    VIDEO_HDR_MAPPING(MediaKind.VIDEO),
    CUT_PREVIEW(MediaKind.VIDEO),
    AUDIO(MediaKind.AUDIO),
    AUDIO_DEMUX(MediaKind.AUDIO_DEMUX),
    NORMAL_LOUDNESS_AUDIO(MediaKind.AUDIO),
    INSERT_LOUDNESS_STEREO_AUDIO(MediaKind.AUDIO),
    AUDIO_ENVELOPE(MediaKind.AUDIO_ENVELOPE),
    DVS(MediaKind.DVS),
    DVS_DEMUX(MediaKind.DVS_DEMUX),
    NORMAL_LOUDNESS_DVS(MediaKind.DVS),
    DVS_ENVELOPE(MediaKind.DVS_ENVELOPE),
    SUBTITLES(MediaKind.SUBTITLES),
    FORCED_SUBTITLES(MediaKind.SUBTITLES),
    COMMENTARY_SUBTITLES(MediaKind.SUBTITLES),
    SDH(MediaKind.SDH),
    CAPTIONS(MediaKind.CAPTIONS),
    CHAPTERS(MediaKind.CHAPTERS),
    THUMBNAILS(MediaKind.THUMBNAILS),
    PRODUCTION_STILL(MediaKind.PRODUCTION_STILL),
    DUB_CREDIT(MediaKind.DUB_CREDIT),
    PREVIEW_IMAGE(MediaKind.PREVIEW_IMAGE),
    QUALITY_STATS(MediaKind.QUALITY_STATS),
    LOUDNESS_ANALYSIS(MediaKind.LOUDNESS_ANALYSIS),
    INTERLEAVE_ANALYSIS(MediaKind.INTERLEAVE_ANALYSIS),
    DUPFRAME_ANALYSIS(MediaKind.DUPFRAME_ANALYSIS),
    DETECTUPSCALING_ANALYSIS(MediaKind.DETECTUPSCALING_ANALYSIS),
    COMPARE_VIDEO_SOURCES_ANALYSIS(MediaKind.COMPARE_VIDEO_SOURCES_ANALYSIS),
    FACEDETECT_ANALYSIS(MediaKind.FACEDETECT_ANALYSIS),
    MONOAUDIO_ANALYSIS(MediaKind.MONOAUDIO_ANALYSIS),
    AUDIOCLIPPING_ANALYSIS(MediaKind.AUDIOCLIPPING_ANALYSIS),
    ALIGNSCENECUTS_ANALYSIS(MediaKind.ALIGNSCENECUTS_ANALYSIS),
    JPEG_TRICKPLAY(null),
    IFRAME_TRICKPLAY(MediaKind.IFRAME_TRICKPLAY),
    HLS_TRICKPLAY(MediaKind.HLS_TRICKPLAY),
    PROXY(null),
    FIRST_FRAME_ANALYSIS(null),
    CROP_ANALYSIS(null),
    VOD_BUNDLE(null),
    HLS_BUNDLE(MediaKind.HLS_BUNDLE),
    VTT_STYLE_PLIST(MediaKind.VTT_STYLE_PLIST),
    VIDEO_QUALITY_REPORT(MediaKind.VIDEO_QUALITY_REPORT),
    SPATIAL_COMPLEXITY_ANALYSIS(MediaKind.SPATIAL_COMPLEXITY_ANALYSIS),
    STANDALONE_AUDIO(null),
    UNKNOWN(null);

    @Nullable
    private final MediaKind mediaKind;
    public static final IndexedMapKeyType<FeatureKind> indexKeyType;
    @Nullable
    private transient IndexedMapKey<FeatureKind> indexKey;

    @Nullable
    public static final FeatureKind featureKindForName(@Nonnull String featureKindName) {
        return FeatureKind.valueOf(featureKindName);
    }

    private FeatureKind(MediaKind mediaKind) {
        this.mediaKind = mediaKind;
    }

    @Nullable
    public MediaKind getMediaKind() {
        return this.mediaKind;
    }

    @Nonnull
    public IndexedMapKey<FeatureKind> indexKey() {
        if (this.indexKey == null) {
            this.indexKey = new IndexedMapKey<FeatureKind>(indexKeyType, this);
        }
        return this.indexKey;
    }

    @Override
    @Nonnull
    public void filter(@Nonnull IndexedMap<? extends MediaFeature> indexedMap, ValueSet<? extends MediaFeature> values) {
        values.retainAll(indexedMap.getValuesForKey(this.indexKey()));
    }

    @Override
    public boolean meetsCriteria(@Nonnull MediaFeature feature) {
        return feature.getFeatureKind() == this;
    }

    public static IndexedMapFilter.KeyInCriteria<FeatureKind, MediaFeature> byKind(FeatureKind ... kinds) {
        return new IndexedMapFilter.KeyInCriteria(indexKeyType, (Serializable[])kinds);
    }

    static {
        indexKeyType = IndexedMapKeyType.of("kind", FeatureKind.class);
    }
}

