/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.media.feature;

import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
@Immutable
public class CountryCodeList
implements Iterable<String>,
Comparable<CountryCodeList>,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final CountryCodeList emptyCountryCodeList = new CountryCodeList(Collections.emptySet());
    @Nonnull
    protected final Set<String> countries;
    @Nullable
    private transient String stringValue;
    @Nullable
    private transient Integer hashCode;

    private CountryCodeList(@Nonnull Set<String> countries) {
        this.countries = countries;
    }

    @Nonnull
    public static final CountryCodeList valueOf(@Nullable TreeSet<String> countries) {
        if (countries == null || countries.isEmpty()) {
            return emptyCountryCodeList;
        }
        return new CountryCodeList(Sets.unmodifiableNavigableSet(countries));
    }

    @Nonnull
    public Set<String> toSet() {
        return this.countries;
    }

    public boolean isEmpty() {
        return this.countries.isEmpty();
    }

    @Nullable
    public CountryCodeList splitOutCountries(@Nonnull CountryCodeList countryCodeList) {
        return this.splitOutCountries(countryCodeList.countries);
    }

    @Nullable
    public CountryCodeList splitOutCountries(@Nonnull Set<String> countriesToRemove) {
        if (this.isEmpty()) {
            return this;
        }
        TreeSet<String> originalCountries = new TreeSet<String>(this.countries);
        originalCountries.removeAll(countriesToRemove);
        return CountryCodeList.valueOf(originalCountries);
    }

    @Override
    public Iterator<String> iterator() {
        return this.countries.iterator();
    }

    public int hashCode() {
        if (this.hashCode == null) {
            this.hashCode = this.countries.hashCode();
        }
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (obj instanceof CountryCodeList) {
            return this.toString().equals(((CountryCodeList)obj).toString());
        }
        return false;
    }

    @Override
    public int compareTo(@Nonnull CountryCodeList o) {
        if (this.isEmpty()) {
            if (o.isEmpty()) {
                return 0;
            }
            return -1;
        }
        return this.toString().compareTo(o.toString());
    }

    public boolean intersects(@Nonnull CountryCodeList obj) {
        if (this.isEmpty() && obj.isEmpty()) {
            return true;
        }
        return !Collections.disjoint(this.countries, obj.countries);
    }

    public String toString() {
        if (this.stringValue == null) {
            StringBuilder sb = new StringBuilder(this.countries.size() * 3);
            boolean first = true;
            for (String cc : this.countries) {
                if (!first) {
                    sb.append(',');
                } else {
                    first = false;
                }
                sb.append(cc);
            }
            this.stringValue = sb.toString();
        }
        return this.stringValue;
    }
}

