/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.media.dolbymapping.file;

import com.apple.jingle.leghorn.dolby.contentmapping.DolbyCmShot;
import com.apple.jingle.leghorn.dolby.contentmapping.DolbyCmTrack;
import com.apple.jingle.leghorn.media.MediaValue;
import com.apple.jingle.leghorn.media.MediaValueImpl;
import com.apple.jingle.leghorn.media.dolbymapping.file.DolbyContentMappingMediaFile;
import com.apple.jingle.leghorn.media.file.MediaFile;
import com.apple.jingle.leghorn.media.file.MediaTrack;
import com.apple.jingle.leghorn.media.file.MediaTrackKind;
import com.apple.jingle.leghorn.timecode.MediaTime;
import com.apple.jingle.locale.LocaleCode;
import java.math.BigInteger;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DolbyContentMappingTrack<T extends DolbyCmTrack>
implements MediaTrack {
    @Nonnull
    protected final MediaFile mediaFile;
    @Nonnull
    protected final T track;
    @Nonnull
    protected final String mediaName;
    @Nonnull
    protected final BigInteger trackId;
    @Nonnull
    protected final MediaValue<MediaTime> startTime;
    @Nonnull
    protected final MediaValue<MediaTime> endTime;

    public DolbyContentMappingTrack(@Nonnull DolbyContentMappingMediaFile mediaFile, @Nonnull T track) {
        this.track = track;
        this.mediaFile = mediaFile;
        this.trackId = BigInteger.valueOf(((DolbyCmTrack)track).uniqueId());
        this.mediaName = mediaFile.getMediaName() + "#" + this.trackId;
        MediaTime maxEndTime = null;
        MediaTime minStartTime = null;
        for (DolbyCmShot shot : ((DolbyCmTrack)track).shots()) {
            MediaTime endTime;
            MediaTime startTime = shot.startTime();
            if (null != startTime && (null == minStartTime || minStartTime.compareTo(startTime) > 0)) {
                minStartTime = startTime;
            }
            if (null == (endTime = shot.endTime()) || null != maxEndTime && maxEndTime.compareTo(endTime) >= 0) continue;
            maxEndTime = endTime;
        }
        this.startTime = new MediaValueImpl<Object>(minStartTime);
        this.endTime = new MediaValueImpl<Object>(maxEndTime);
    }

    @Nonnull
    public MediaValue<MediaTime> startTime() {
        return this.startTime;
    }

    @Nonnull
    public MediaValue<MediaTime> endTime() {
        return this.endTime;
    }

    @Nonnull
    public List<DolbyCmShot> shots() {
        return ((DolbyCmTrack)this.track).shots();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.trackId + "," + "duration=" + this.endTime.tryGet() + "," + "shots=" + this.shots().size() + "]";
    }

    @Override
    @Nonnull
    public String getMediaName() {
        return this.mediaName;
    }

    @Override
    @Nonnull
    public MediaTrackKind getMediaTrackKind() {
        return MediaTrackKind.HDR_CONTENT_MAPPING;
    }

    @Override
    @Nonnull
    public BigInteger getTrackId() {
        return this.trackId;
    }

    @Override
    @Nullable
    public LocaleCode getLocale() {
        return null;
    }
}

