/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.media.dolbymapping.file;

import com.apple.jingle.leghorn.beans.dolby.contentmapping.DolbyContentMappingDocument;
import com.apple.jingle.leghorn.dolby.contentmapping.DolbyCmOutput;
import com.apple.jingle.leghorn.dolby.contentmapping.DolbyCmVideoTrack;
import com.apple.jingle.leghorn.dolby.contentmapping.DolbyContentMap;
import com.apple.jingle.leghorn.media.MediaTrackCriteria;
import com.apple.jingle.leghorn.media.MediaUtil;
import com.apple.jingle.leghorn.media.MediaValidationCode;
import com.apple.jingle.leghorn.media.MediaValue;
import com.apple.jingle.leghorn.media.MediaValueImpl;
import com.apple.jingle.leghorn.media.XmlObjectMediaBase;
import com.apple.jingle.leghorn.media.dolbymapping.file.DolbyContentMappingTrack;
import com.apple.jingle.leghorn.media.dolbymapping.file.DolbyContentMappingVideoTrack;
import com.apple.jingle.leghorn.media.file.MediaFileBackedByXmlDescription;
import com.apple.jingle.leghorn.media.file.MediaFileContext;
import com.apple.jingle.leghorn.media.file.MediaFileType;
import com.apple.jingle.leghorn.media.file.MediaTrack;
import com.apple.jingle.leghorn.media.xml.XmlObjectMediaParser;
import com.apple.jingle.leghorn.timecode.MediaTime;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import noNamespace.AlertItemQT;
import noNamespace.AlertListQT;
import org.apache.mahout.math.Arrays;
import org.apache.xmlbeans.XmlObject;

public class DolbyContentMappingMediaFile
extends XmlObjectMediaBase<DolbyContentMappingDocument.DolbyContentMapping>
implements MediaFileBackedByXmlDescription {
    @Nonnull
    private final DolbyContentMap cm;
    @Nonnull
    private final List<DolbyContentMappingTrack<?>> tracks;
    @Nonnull
    private final MediaValue<MediaTime> duration;

    public DolbyContentMappingMediaFile(@Nonnull MediaFileContext metaFile, @Nonnull DolbyContentMappingDocument.DolbyContentMapping xmlObject) {
        super(metaFile, metaFile.getMediaName(), xmlObject);
        XmlObjectMediaParser parser = new XmlObjectMediaParser(metaFile, this.getMediaName(), (XmlObject)xmlObject);
        parser.processNotificationList(xmlObject.getNotifications(), MediaValidationCode.FILE_ALERT_PASSTHROUGH);
        this.cm = new DolbyContentMap(metaFile, xmlObject);
        MediaTime maxEndTime = null;
        this.tracks = new ArrayList();
        for (DolbyCmOutput output : this.cm.outputs()) {
            for (DolbyCmVideoTrack track : output.videoTracks()) {
                DolbyContentMappingVideoTrack vt = new DolbyContentMappingVideoTrack(this, track);
                this.tracks.add(vt);
                MediaTime endTime = vt.endTime().tryGet();
                if (null == endTime || null != maxEndTime && maxEndTime.compareTo(endTime) >= 0) continue;
                maxEndTime = endTime;
            }
        }
        this.duration = new MediaValueImpl<Object>(maxEndTime);
    }

    public String toString() {
        return this.cm.toString();
    }

    protected void processAlertList(@Nonnull XmlObjectMediaParser parser, @Nullable AlertListQT alertList, @Nonnull MediaValidationCode code) {
        if (null != alertList) {
            for (AlertItemQT item : alertList.getAlertArray()) {
                String message = item.getMessage();
                if (message.toLowerCase().contains("Atom size extends beyond the end of the file".toLowerCase())) {
                    parser.addIssue(MediaValidationCode.QT_ATOM_EXTENDS_BEYOND_FILE, MediaUtil.dictionary.add("message", message));
                    continue;
                }
                if (message.toLowerCase().contains("Zero length input file cannot be described".toLowerCase())) {
                    parser.addIssue(MediaValidationCode.FILE_EMPTY, MediaUtil.dictionary.add("message", message));
                    continue;
                }
                if (message.toLowerCase().contains("There is more than one metadata header (moov atom) in the file".toLowerCase()) || message.toLowerCase().contains("There is more that one metadata header (moov atom) in the file".toLowerCase())) {
                    parser.addIssue(MediaValidationCode.MOV_CONTAINER_TWO_OR_MORE_MOOVS, MediaUtil.dictionary.add("message", message));
                    continue;
                }
                parser.addIssue(code, MediaUtil.dictionary.add("message", message));
            }
        }
    }

    @Override
    public MediaFileType getMediaFileType() {
        return MediaFileType.quickTime;
    }

    @Override
    @Nonnull
    public String getMediaName() {
        return this.name;
    }

    public List<? extends DolbyContentMappingTrack<?>> getTracks() {
        return this.tracks;
    }

    @Override
    @Nonnull
    public DolbyContentMappingTrack<?> getTrackById(@Nullable BigInteger mediaTrackId) throws NoSuchElementException {
        for (DolbyContentMappingTrack<?> t : this.tracks) {
            if (!t.getTrackId().equals(mediaTrackId)) continue;
            return t;
        }
        throw new NoSuchElementException(this.name + "#" + mediaTrackId);
    }

    @Override
    @Nonnull
    public <T extends MediaTrack> T getFirstTrack(@Nonnull Class<T> trackType, MediaTrackCriteria ... criteria) throws NoSuchElementException {
        for (MediaTrack mediaTrack : this.tracks) {
            MediaTrack track;
            if (!trackType.isInstance(mediaTrack) || !MediaUtil.meetsCriteria(track = (MediaTrack)trackType.cast(mediaTrack), criteria)) continue;
            return (T)track;
        }
        throw new NoSuchElementException(trackType.getName() + Arrays.toString((Object[])criteria));
    }

    @Override
    @Nonnull
    public <T extends MediaTrack> List<T> getTracks(@Nonnull Class<T> trackType, MediaTrackCriteria ... criteria) {
        ArrayList<MediaTrack> tracks = new ArrayList<MediaTrack>(this.tracks.size());
        for (MediaTrack mediaTrack : this.tracks) {
            MediaTrack track;
            if (!trackType.isInstance(mediaTrack) || !MediaUtil.meetsCriteria(track = (MediaTrack)trackType.cast(mediaTrack), criteria)) continue;
            tracks.add(track);
        }
        return Collections.unmodifiableList(tracks);
    }

    @Override
    public boolean hasTrack(MediaTrackCriteria ... criteria) {
        for (MediaTrack mediaTrack : this.tracks) {
            if (!MediaUtil.meetsCriteria(mediaTrack, criteria)) continue;
            return true;
        }
        return false;
    }

    @Override
    public MediaValue<MediaTime> duration() {
        return this.duration;
    }
}

