/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.media.criteria;

import com.apple.jingle.locale.BCP47TagParseException;
import com.apple.jingle.locale.BCP47TagSupport;
import com.apple.jingle.locale.LocaleCode;
import javax.annotation.Nonnull;

public class MediaLocaleMatcher {
    public static final String EXCLUSION_PREFIX = "/";
    public static final String WILDCARD_SUFFIX = "*";
    public final LocaleCode locale;
    public final boolean useLanguageOnly;
    public final boolean isExcluded;

    public MediaLocaleMatcher(@Nonnull String locStr) {
        try {
            boolean isExcluded = false;
            if (locStr.startsWith(EXCLUSION_PREFIX)) {
                locStr = locStr.substring(EXCLUSION_PREFIX.length());
                isExcluded = true;
            }
            boolean isLanguageOnlyWildcard = false;
            if (locStr.endsWith(WILDCARD_SUFFIX)) {
                locStr = locStr.substring(0, locStr.length() - WILDCARD_SUFFIX.length());
                isLanguageOnlyWildcard = true;
            }
            this.locale = BCP47TagSupport.createBCP47Tag((String)locStr);
            this.useLanguageOnly = isLanguageOnlyWildcard;
            this.isExcluded = isExcluded;
        }
        catch (BCP47TagParseException re) {
            throw new IllegalArgumentException("Locale string not valid: " + locStr, re);
        }
        if (this.useLanguageOnly && !this.locale.getRFC4646Language().equals(this.locale.toString())) {
            throw new IllegalArgumentException("Locale: " + this.locale + " cannot be used as language only wildcard");
        }
    }

    public MediaLocaleMatcher(LocaleCode locale, boolean useLanguageOnly, boolean isExcluded) {
        this.locale = locale;
        this.useLanguageOnly = useLanguageOnly;
        this.isExcluded = isExcluded;
        if (this.useLanguageOnly && !locale.getRFC4646Language().equals(locale.toString())) {
            throw new IllegalArgumentException("Locale: " + locale + " cannot be used as language only wildcard");
        }
    }

    public boolean isExclusion() {
        return this.isExcluded;
    }

    public boolean matches(@Nonnull LocaleCode localeCode) {
        if (this.useLanguageOnly) {
            return this.locale.getRFC4646Language().equals(localeCode.getRFC4646Language());
        }
        return this.locale.equals(localeCode);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(11);
        if (this.isExcluded) {
            sb.append('!');
        }
        if (this.useLanguageOnly) {
            sb.append(this.locale.getISO2Language()).append('*');
        } else {
            sb.append(this.locale.toString());
        }
        return sb.toString();
    }
}

