/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.media;

import com.apple.jingle.leghorn.media.DottedString;
import com.apple.jingle.leghorn.media.notification.MediaNotificationCode;
import com.apple.jingle.leghorn.media.validator.ValidationLevel;
import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.collections.CollectionUtils;

public enum MediaValidationCode implements MediaNotificationCode<ValidationLevel>
{
    DATA_INFO(39, "mediaValidation.data", "data", ValidationLevel.INFO, new OptionValue[0]),
    ASSET_VALIDATOR_FAILURE(40, "mediaValidation.genericFailure", "Asset validation failed due to ${errorMessage}", ValidationLevel.WARNING, new OptionValue[0]),
    ASSET_VALIDATOR_NOT_SUPPORTED(41, "mediaValidation.validatorNotSupported", "Validator ${validator} does not support ${value}", ValidationLevel.DEBUG, new OptionValue[0]),
    ASSET_VALIDATOR_ERROR(42, "mediaValidation.genericError", "Asset validation failed due to ${errorMessage}", ValidationLevel.ERROR, new OptionValue[0]),
    ASSET_VALIDATOR_FATAL_ERROR(43, "mediaValidation.fatalError", "Asset validation failed due to ${errorMessage}", ValidationLevel.FATAL, new OptionValue[0]),
    ASSET_VALIDATOR_SHADOW_UNKNOWN_ERRORS(44, "mediaValidation.unknownFatalError", "Asset validation failed due to ${errorMessage}", "The file could not be validated. Make sure this file opens correctly in a viewer before you try again.", ValidationLevel.SHADOW, new OptionValue[0]),
    FILE_EXTENSION_NOT_ACCEPTED(51, "mediaValidation.file.invalidFileType", "com.apple.jingle.video.validateSourceFileNameAgainstAcceptedExtensionsForRole", "Your ${role} file does not match any of the accepted extensions ${validExtensions}.", null, ValidationLevel.ERROR, new OptionValue[0]),
    FILE_APPEARS_CORRUPT(52, "mediaValidation.file.corrupt", "The file could not be parsed successfully. Details: ${errorMessage}", "${errorMessage}", ValidationLevel.FATAL, new OptionValue[0]),
    NO_SUCH_CONFORMANCE_PROFILE(53, new OptionValue[0]),
    EXISTING_VIDEO_FILE_COMPONENT_MISSING_DESCRIPTION_XML(54, "mediaValidation.file.description.missingExisting", "File is missing a description", "We failed to extract useful information from the file. (internal error for existing file)", ValidationLevel.SHADOW, new OptionValue(Option.grandfatherable)),
    NEW_VIDEO_FILE_COMPONENT_MISSING_DESCRIPTION_XML(55, "mediaValidation.file.description.missingNew", "File is missing a description", "We failed to extract useful information from the file. Please check that the file is valid and try again.", ValidationLevel.WARNING, new OptionValue(Option.grandfatherable)),
    FILE_FAILS_CONFORMANCE_CHECK(56, "mediaValidation.file.conformance.failure", "${errorMessage}", "${errorMessage}", ValidationLevel.ERROR, new OptionValue[0]),
    FILE_HAS_UNEXPETED_CONTENT(57, "mediaValidation.file.content.unexpected", "File with role ${role} is not expected to contain ${trackKind} track: ${trackName}", "You can't have a ${trackKind} track in a ${role} file", ValidationLevel.SHADOW, new OptionValue[0]),
    PREVIEW_STARTTIME_INVALID(58, "mediaValidation.preview.starttime.invalid", "Your specified preview start time, ${previewStartTime} secs, is beyond the end of the video. Please either specify a corrected value or omit the attribute in which case we will use the default value of ${defaultPreviewStartTime} secs.", ValidationLevel.ERROR, new OptionValue[0]),
    PREVIEW_LENGTH_INVALID("mediaValidation.preview.length.invalid", "Your specified preview length, ${previewLength} secs, is longer than the limit of 10 minutes. Please correct or resubmit the preview with a reasonable time length less than 10 minutes.", ValidationLevel.ERROR, new OptionValue[0]),
    FILE_CANNOT_BE_WRITTEN(60, "mediaTool.fileCannotBeWrittenTo", "File ${fileName} cannot be written to", ValidationLevel.SHADOW, new OptionValue[0]),
    FILE_CANNOT_BE_CONVERTED(61, "mediaTool.fileCannotBeConverted", "File ${fileName} cannot be converted", ValidationLevel.SHADOW, new OptionValue[0]),
    FILE_INVALID_LOCALE(62, "mediaValidation.fileLocaleInvalid", "Locale code ${localeCode} is not supported", ValidationLevel.SHADOW, new OptionValue[0]),
    FILE_ATOM_EXCEEDS_PARENT("mediaValidation.file.atom.exceedsParent", "${javaClass}: Video track ${id} type ${type} extends beyond parent ${parentType} atom of size ${parentSize}.", "Video track has inconsistent metadata atom sizes. Type: ${type}.", ValidationLevel.WARNING, new OptionValue[0]),
    FILE_ATOM_EXCEEDS_PARENT_ERROR("mediaValidation.file.atom.exceedsParent.error", "${javaClass}: Video track ${id} type ${type} extends beyond parent ${parentType} atom of size ${parentSize}.", "Video track has inconsistent metadata atom sizes. Type: ${type}.", ValidationLevel.ERROR, new OptionValue[0]),
    FILE_ATOM_EXTRA_BYTES("mediaValidation.file.atom.extraBytes", "${javaClass}: Extra bytes found at end of parent ${type} atom of size ${size}.", "Video track has inconsistent metadata atom sizes. Type: ${type}.", ValidationLevel.WARNING, new OptionValue[0]),
    FILE_GEOJSON_FIELD_NOT_SUPPORTED(80, new OptionValue[0]),
    IMG_FILESIZE_TOO_LARGE(100, new OptionValue[0]),
    IMG_DIMENSIONS_TOO_SMALL(101, new OptionValue[0]),
    IMG_DIMENSIONS_TOO_LARGE(102, new OptionValue[0]),
    IMG_FORMAT_INCOMPATIBLE(103, new OptionValue[0]),
    IMG_CONTAINER_INCOMPATIBLE(104, new OptionValue[0]),
    IMG_APPEARS_CORRUPT(105, new OptionValue[0]),
    IMG_MISSING_DATA(106, new OptionValue[0]),
    IMG_UNKNOWN_ERROR(107, new OptionValue[0]),
    IMG_ALPHA_NOT_ALLOWED(108, new OptionValue[0]),
    IMG_BAD_ASPECT_RATIO(109, new OptionValue[0]),
    IMG_BAD_COLOR_SPACE(110, new OptionValue[0]),
    IMG_BAD_DIMENSIONS(111, new OptionValue[0]),
    IMG_BAD_DATA(112, new OptionValue[0]),
    IMG_LSR_TOO_FEW_LAYERS(113, new OptionValue[0]),
    IMG_LSR_TOO_MANY_LAYERS(114, new OptionValue[0]),
    IMG_BAD_LSR(115, new OptionValue[0]),
    IMG_LSR_FILENAME_TOO_LARGE(116, new OptionValue[0]),
    IMG_LSR_FILE_MISSING(117, new OptionValue[0]),
    IMG_LSR_NO_FILENAME_FOR_LAYER(118, new OptionValue[0]),
    IMG_LSR_FILENAME_CONTAINS_BACKSLASH(119, new OptionValue[0]),
    IMG_LSR_FILENAME_STARTS_WITH_DOT(120, new OptionValue[0]),
    IMG_LSR_DUPLICATE_IMAGE_SET(121, new OptionValue[0]),
    IMG_LSR_SYMLINK_NOT_ALLOWED(122, new OptionValue[0]),
    IMG_LSR_DUPLICATE_IMAGE(123, new OptionValue[0]),
    IMG_LSR_INVALID_IMAGE_FILENAME(124, new OptionValue[0]),
    IMG_LSR_MISSING_INFO(125, new OptionValue[0]),
    IMG_LSR_VERSION_NOT_SUPPORTED(126, new OptionValue[0]),
    IMG_LSR_DUPLICATE_FILE(127, new OptionValue[0]),
    IMG_LSR_INVALID_JSON_FILENAME(128, new OptionValue[0]),
    IMG_LSR_FILE_NOT_SUPPORTED(129, new OptionValue[0]),
    IMG_LSR_UNKNOWN_FILE_TYPE(130, new OptionValue[0]),
    IMG_LSR_JSON_MAPPING_EXCEPTION(131, new OptionValue[0]),
    IMG_LSR_MISSING_CONTENTS(132, new OptionValue[0]),
    IMG_LSR_MISSING_PROPERTIES(133, new OptionValue[0]),
    IMG_LSR_MISSING_CANVAS_SIZE(134, new OptionValue[0]),
    IMG_LSR_MISSING_FILENAME_FOR_LAYER(135, new OptionValue[0]),
    IMG_LSR_MISSING_CONTENT_IN_LAYERSET(136, new OptionValue[0]),
    IMG_LSR_NO_IMAGES_IN_IMAGESET(137, new OptionValue[0]),
    IMG_LSR_MISSING_IMAGE_IN_IMAGESET(138, new OptionValue[0]),
    IMG_LSR_NO_LAYERS(139, new OptionValue[0]),
    IMG_LSR_UNREFERENCED_FILES(140, new OptionValue[0]),
    IMG_LSR_MISSING_FRAME_SIZE(141, new OptionValue[0]),
    IMG_NONUNIQUE_RULESET(142, new OptionValue[0]),
    MOV_FILESIZE_TOO_LARGE(200, new OptionValue[0]),
    MOV_DURATION_TOO_LONG(201, new OptionValue[0]),
    MOV_FORMAT_INCOMPATIBLE(202, new OptionValue[0]),
    MOV_MISSING_DATA(203, new OptionValue[0]),
    MOV_CONTAINER_INCOMPATIBLE(204, "mediaValidation.file.container.incompatible", "${errorMessage}", ValidationLevel.ERROR, new OptionValue(Option.grandfatherable)),
    MOV_DIMENSIONS_TOO_SMALL(205, new OptionValue[0]),
    MOV_APPEARS_CORRUPT(206, "mediaValidation.movfile.corrupt", "${errorMessage}", ValidationLevel.FATAL, new OptionValue[0]),
    MOV_REFERENCES_EXTERNAL_FILES(207, new OptionValue[0]),
    MOV_UNKNOWN_ERROR(208, new OptionValue[0]),
    MOV_ITUNES_PROTECTED_CONTENT(209, new OptionValue[0]),
    MOV_INVALID_AUDIO_FORMAT(210, new OptionValue[0]),
    MOV_DIMENSIONS_TOO_LARGE(211, new OptionValue[0]),
    MOV_DIMENSIONS_TOO_LARGE_FOR_H264(212, new OptionValue[0]),
    MOV_MAX_FRAME_RATE_EXCEEDED(213, new OptionValue[0]),
    MOV_VIDEO_IS_NOT_PROGRESSIVE(214, new OptionValue[0]),
    MOV_DURATION_TOO_SHORT(215, "mediaValidation.video.duration.tooShort", "Video must be at least two (2) seconds in duration.", ValidationLevel.ERROR, new OptionValue[0]),
    MOV_VIDEO_WIDTH_TOO_NARROW(216, new OptionValue[0]),
    MOV_VIDEO_WIDTH_TOO_WIDE(217, new OptionValue[0]),
    MOV_VIDEO_HEIGHT_TOO_SHORT(218, new OptionValue[0]),
    MOV_VIDEO_HEIGTH_TOO_TALL(219, new OptionValue[0]),
    MOV_DIMENSIONS_NOT_ACCEPTABLE(220, new OptionValue[0]),
    MOV_MISSING_DESCRIPTION(222, new OptionValue[0]),
    MOV_MISSING_PASP(223, "mediaValidation.video.pasp.missing", "Your video asset needs to be encoded with a pixel aspect ratio (PASP) because it's a ProRes SD video source asset.", ValidationLevel.SHADOW, new OptionValue[0]),
    MOV_NON_CONFORMING_DAR(224, "mediaValidation.video.dar.notsupported", "ProRes SD video source with display dimensions of ${displayDimensions} must have either a 4:3 or 16:9 Display Aspect Ratio (DAR)", ValidationLevel.SHADOW, new OptionValue[0]),
    MOV_VIDEOCODEC_NOT_ACCEPTABLE_FOR_VIDEOTYPE(225, "mediaValidation.video.codec.notsupported", "Video source (codec ${codec}) does not match any of the accepted video codecs ${validCodecs} for type ${videoFileType}, UTI ${uti}", "The video codec ${codec} is invalid. Use only supported video codecs listed in the iTunes Video and Audio Asset Guide.", ValidationLevel.FATAL, new OptionValue(Option.grandfatherable), new OptionValue(Option.conformanceNames, Arrays.asList("testNonHQProRes"))),
    MOV_23976_FRAMERATE_NOTSUPPORTED(227, "mediaValidation.video.frameRateOf23_976.withoutSubtitles.notsupported", "Your 24fps video cannot be encoded at ${frameRate} fps.", ValidationLevel.SHADOW, new OptionValue[0]),
    MOV_23976_FRAMERATE_NOTSUPPORTED_WITHSUBTITLES(228, "mediaValidation.video.frameRateOf23_976.withSubtitles.notsupported", "Your 24fps video with subtitles cannot be encoded at ${frameRate} fps.", ValidationLevel.SHADOW, new OptionValue[0]),
    MOV_CONTAINER_HAS_UNACCEPTABLE_TRACK_TYPES(226, new OptionValue[0]),
    MOV_ATOM_EXTENDS_BEYOND_FILE_END(227, "mediaValidation.video.atomExtendsBeyondFileEnd", "Atom size extends beyond the end of the file", "The Quicktime metadata includes an atom with size that extends beyond the end of the file.", ValidationLevel.ERROR, new OptionValue(Option.grandfatherable)),
    MOV_CONTAINER_TWO_OR_MORE_MOOVS(228, "mediaValidation.video.containerTwoOrMoreMOOVs", "You\u2019ve included more than one metadata header ('moov' atom). Remux your asset using Compressor with passthrough settings. If your file plays in QuickTime, you don\u2019t have to re-encode it.", ValidationLevel.SHADOW, new OptionValue[0]),
    MOV_H264_LEVEL_TOO_HIGH(229, new OptionValue[0]),
    MOV_IDENTICAL_DISPLAY_TIME_FOR_TWO_SAMPLES(230, "mediaValidation.video.compositionOffsetTable.displayTimeOverlap", "Overlap detected in display time: ${displayTime}", ValidationLevel.SHADOW, new OptionValue[0]),
    MOV_CONTAINER_NO_MOOVS(231, "mediaValidation.video.container.zeroMOOVs", "Found zero \"moov\" atoms; expected exactly one.", ValidationLevel.ERROR, new OptionValue[0]),
    MOV_CONTAINER_NO_MVHD(231, "mediaValidation.video.container.mvhd.missing", "Found zero \"mvhd\" atoms.", ValidationLevel.ERROR, new OptionValue[0]),
    MOV_CONTAINER_NO_MDAT(232, "mediaValidation.video.container.zeroMDATs", "Found zero \"mdat\" atoms; expected one or more.", ValidationLevel.FATAL, new OptionValue[0]),
    MOV_INVALID_ASEPCT_RATIO(233, new OptionValue[0]),
    MOV_VIDEO_TRACK_CONTAINS_EMPTY_EDITLIST_ENTRY(351, new OptionValue[0]),
    MOV_VIDEO_CODEC_IS_PRORES_NONHQ(352, new OptionValue[0]),
    MOV_TOO_MANY_SAMPLE_DESCRIPTORS(353, "mediaValidation.video.container.sampleDescriptor.toomany", "Only one sample descriptor per track is supported", ValidationLevel.ERROR, new OptionValue[0]),
    MOV_AUDIO_CHANNEL_LAYOUT_IS_LABELED_MONO(501, new OptionValue[0]),
    MOV_AUDIO_CHANNEL_LAYOUT_IS_DISCRETE(502, new OptionValue[0]),
    MOV_AUDIO_TRACKS_CONTAIN_COMPRESSED_AUDIO(503, new OptionValue[0]),
    MOV_AUDIO_SAMPLE_RATE_LESS_THAN_44100(504, new OptionValue[0]),
    MOV_AUDIO_BIT_DEPTH_SHOULD_BE_AT_LEAST_16(505, new OptionValue[0]),
    MOV_AUDIO_ALL_TRACKS_MUST_BE_ENABLED(506, new OptionValue[0]),
    MOV_AUDIO_IS_MISSING(507, new OptionValue[0]),
    MOV_AUDIO_CODEC_NOT_ACCEPTABLE(508, new OptionValue[0]),
    MOV_AUDIO_SAMPLE_RATE_LESS_THAN_22050(509, new OptionValue[0]),
    MOV_DEFAULT_AUDIO_TRACK_MUST_BE_FIRST(510, "mediaValidation.container.audio.defaultTrackMustBeFirst", "Audio track layout is invalid, first track ${firstTrack} and current track ${currentTrack} are swapped for locale ${localeCode}", ValidationLevel.ERROR, new OptionValue[0]),
    MOV_AUDIO_TRACKS_DURATION_TOO_SHORT(511, "mediaValdiation.container.audio.durationTooShort", "Audio track duration is too short compared to video track duration", ValidationLevel.ERROR, new OptionValue[0]),
    MOV_AUDIO_TRACK_CONTAINS_EMPTY_EDITLIST_ENTRY(512, "mediaValdiation.container.audio.containsEmptyEditList", "Audio track contains empty list entry", ValidationLevel.ERROR, new OptionValue[0]),
    MPEG2_INVALID_PACKET_START_CODE(1001, "mediaValidation.mpeg2.packet.invalidStartCode", "Start code prefix mismatch, expected 0x${expectedValue} and received: 0x${value}", "Your MPEG-2 asset contains an invalid packet start code with prefix value 0x${value} instead of 0x${expectedValue}.", ValidationLevel.ERROR, new OptionValue[0]),
    MPEG2_INVALID_PROGRAM_PACK_BYTES(1002, "mediaValidation.mpeg2.programPack.invalid", "Program Pack should start with ${expectedValue}, but starts with ${value}", "Your MPEG-2 asset contains an invalid Program Pack which starts with ${value} instead of ${expectedValue}.", ValidationLevel.ERROR, new OptionValue[0]),
    MPEG2_PACK_HEADER_INVALID_FOURTH_BYTE(1003, "mediaValidation.mpeg2.packet.invalidPacketType", "Pack Header 4th byte starting bits should be 0010 for MPEG-1 or 01 for MPEG-2, but is ${value}", "Your file contains an MPEG pack header with an invalid value (${value}) instead of the expected 0010 (MPEG-1) or 01 (MPEG-2) for the 4th byte starting bits.", ValidationLevel.ERROR, new OptionValue[0]),
    MPEG2_INSUFFICIENT_BYTES_FOR_PROGRAM_PACK(1004, "mediaValidation.mpeg2.programPack.insufficientBytes", "Insufficient number of bytes (${remainingBytes}) before file end while checking for ProgramPack", "Your MPEG-2 asset contains an invalid Program Pack with only ${remainingBytes} bytes before the file end.", ValidationLevel.ERROR, new OptionValue[0]),
    MPEG2_INSUFFICIENT_STUFFING_BYTES(1005, "mediaValidation.mpeg2.packet.insufficientPadding", "Pack Header indicates ${expectedStuffingBytes} stuffing bytes, but found only ${stuffingBytes} bytes before file end", "Your MPEG-2 asset contains a Program Pack with only ${stuffingBytes} stuffing bytes instead of the ${expectedStuffingBytes} expected.", ValidationLevel.ERROR, new OptionValue[0]),
    MPEG2_INSUFFICIENT_DESCRIPTOR_BYTES(1006, "mediaValidation.mpeg2.descriptor.insufficientBytes", "${message}", "${message}", ValidationLevel.ERROR, new OptionValue[0]),
    MPEG2_INSUFFICIENT_BYTES_FOR_DESCRIPTOR(1007, new OptionValue[0]),
    MPEG2_INCOMPLETE_LAST_PACKET(1008, "mediaValidation.mpeg2.packet.insufficientBytes", "${message}", "Your MPEG-2 asset contains a PES packet which extends beyond the end of the file.", ValidationLevel.ERROR, new OptionValue[0]),
    MPEG2_INVALID_ADTS_STREAM(1009, "mediaValidation.mpeg2.adts.streamInvalid", "${message}", "${message}", ValidationLevel.ERROR, new OptionValue[0]),
    MPEG2_INVALID_NALU_STREAM(1010, "mediaValidation.mpeg2.nalu.streamInvalid", "${message}", "${message}", ValidationLevel.ERROR, new OptionValue[0]),
    MPEG2_INVALID_AUDIO_LAYER_VALUE(1011, new OptionValue[0]),
    MPEG2_FAILED_TO_FIND_PACKET_START_CODE(1012, "mediaValidation.mpeg2.packetStartCode.notFound", "${message}", "Your video asset cannot be processed because the first packet cannot be found. Check your video asset and redeliver.", ValidationLevel.ERROR, new OptionValue[0]),
    MPEG2_DISPLAY_WIDTH_NOT_640_PIXELS(1013, new OptionValue[0]),
    MPEG2_TOO_HIGH_FRAMERATE(1014, new OptionValue[0]),
    MPEG2_PIXEL_FORMAT_SHOULD_BE_YUV_420(1015, new OptionValue[0]),
    MPEG2_VIDEO_DURATION_SHOULD_BE_AT_LEAST_TWO_SECONDS(1016, new OptionValue[0]),
    MPEG2_AUDIO_SAMPLE_RATE_SHOULD_BE_48_KHZ(1017, new OptionValue[0]),
    MPEG2_STREAM_CORRUPT(1018, "mediaValidation.mpeg2.stream.corrupt", "PES packet length = ${packetLength} but streamId = ${streamId} is not video", "Your MPEG-2 asset contains a PES packet with an invalid packet length ${packetLength} for a stream (id = ${streamId}) which is not video.", ValidationLevel.ERROR, new OptionValue[0]),
    SUBTITLE_FAILS_SCHEMA_VALIDATION(2000, "mediaValidation.subtitles.schemaValidation.fail", "Subtitles document fails schema validation at location: ${location} with message: ${SchemaError}", "Your Subtitle document fails schema validation at line,column ${location}. ${SchemaError}", ValidationLevel.ERROR, new OptionValue[0]),
    SUBTITLE_FAILS_TTML_SCHEMA_VALIDATION(2010, "mediaValidation.subtitles.ttml.schemaValidation.fail", "Subtitles document fails TTML schema validation at location: ${location} with message: ${SchemaError}", "Your Subtitle document fails schema validation at line,column ${location}. ${SchemaError}", ValidationLevel.ERROR, new OptionValue[0]),
    SUBTITLE_FAILS_ITT_SCHEMA_VALIDATION(2020, "mediaValidation.subtitles.itt.schemaValidation.fail", "Subtitles document fails ITT schema validation at location: ${location} with message: ${SchemaError}", "Your Subtitle document fails schema validation at line,column ${location}. ${SchemaError}", ValidationLevel.ERROR, new OptionValue[0]),
    ITT_TIMESTAMP_FORMAT_IS_NOT_CONSISTENT_WRT_DROPFRAME(2030, "mediaValidation.subtitles.timestampdropframe.inconsistent", "The dropPAL document is using an invalid timecode separator (;). Please note all timestamps will be treated as being in drop frame mode ${timestamp}", ValidationLevel.WARNING, new OptionValue[0]),
    ITT_INVALID_RUBY(2040, "mediaValidation.subtitles.ruby.invalid", "Invalid ruby: ${message}", ValidationLevel.ERROR, new OptionValue[0]),
    ITT_INVALID_VERTICAL(2050, new OptionValue[0]),
    ITT_LAST_TIMECODE_AFTER_LAST_VIDEO_TIMECODE(2060, "mediaValidation.subtitles.tooLong", "Subtitles file contains time code ${subtitleTimeCode}) [${offsetTimeCode} offset] after the end of the movie ${videoTimeCode}", "Your subtitle file has a timecode ${subtitleTimeCode} that exceeds the length of your video.", ValidationLevel.ERROR, new OptionValue[0]),
    ITT_MULTILINETEXT_NOTSUPPORTED(2070, "mediaValidation.subtitles.text.tooManyLines", "Subtitles file contains a p element with more than two lines at the following locations: ${locations}", "You can't have subtitle cues that have more than 2 lines of text, for example: ${exampleLocation}", ValidationLevel.ERROR, new OptionValue(Option.grandfatherable)),
    ITT_OVERLAPPINGTEXT_NOTSUPPORTED(2080, "mediaValidation.subtitles.text.overlapping", "Subtitles file contains overlapping p elements at the following locations: ${locations}", "You can't have subtitle cues that overlap in time and location, for example: ${exampleLocation}", ValidationLevel.ERROR, new OptionValue[0]),
    ITT_BLANKTEXT_NOTSUPPORTED(2090, "mediaValidation.subtitles.text.missing", "Subtitles file contains empty p elements at the following locations: ${locations}", ValidationLevel.ERROR, new OptionValue[0]),
    ITT_CTRLCHAR_NOTSUPPORTED(2100, "mediaValidation.subtitles.controlchar.notsupported", "Subtitles file contains ${controlCharCount} control character(s).", "You cannot use control characters in your subtitles file.", ValidationLevel.ERROR, new OptionValue[0]),
    ITT_LOCALE_MISSING(2110, "mediaValidation.subtitles.locale.missing", "Your subtitle data file does not have a locale", ValidationLevel.SHADOW, new OptionValue[0]),
    ITT_LOCALE_INVALID(2120, "mediaValidation.subtitles.locale.invalid", "Your subtitle data file has an invalid locale ${localeCode}.", ValidationLevel.SHADOW, new OptionValue[0]),
    ITT_LOCALE_MISMATCH(2130, "mediaValidation.subtitles.locale.mismatch", "Your subtitle data file has a locale ${localeCode} that doesn't match the locale ${expectedLocaleCode} in the metadata.", ValidationLevel.ERROR, new OptionValue[0]),
    ITT_SAMPLERATE_MISSING(2140, "mediaValidation.subtitles.sampleRate.missing", "All subtitles must have a sample rate", ValidationLevel.SHADOW, new OptionValue[0]),
    ITT_SAMPLERATE_INVALID(2150, "mediaValidation.subtitles.sampleRate.invalid", "Subtitle sample rate ${frameRate}, is invalid", ValidationLevel.SHADOW, new OptionValue[0]),
    ITT_LASTTIMECODE_MISSING(2160, "mediaValidation.subtitles.lasttimecode.missing", "Subtitle files must contain at least one subtitle", "Please check there is at least one subtitle cue and timecode values are valid for all cues. If timecodeMode is nonDrop, please do not use semi-colon as a frame delimiter", ValidationLevel.ERROR, new OptionValue(Option.grandfatherable)),
    ITT_LASTTIMECODE_INVALID(2170, "mediaValidation.subtitles.lasttimecode.invalid", "Subtitles time code, ${lastTimeCode}, is not valid", ValidationLevel.SHADOW, new OptionValue[0]),
    ITT_DROPMODE_MISSING(2180, "mediaValidation.subtitles.dropmode.missing", "Subtitles must have a drop mode", ValidationLevel.SHADOW, new OptionValue[0]),
    ITT_DROPMODE_INVALID(2190, "mediaValidation.subtitles.dropmode.invalid", "Subtitles drop mode ${dropMode} is not valid", ValidationLevel.SHADOW, new OptionValue[0]),
    ITT_FILE_HASERRORS(2200, "mediaValidation.subtitles.file.errors", "${message}", "${message}", ValidationLevel.ERROR, new OptionValue(Option.grandfatherable)),
    ITT_INVALID_FORMAT_SMPTE_TIMECODE(2210, "mediaValidation.subtitles.timecode.invalid", "Invalid SMPTE time stamp format: ${timestamp}.", ValidationLevel.ERROR, new OptionValue[0]),
    ITT_UNCATEGORIZED_ERROR(2220, "mediaValidation.subtitles.uncategorized.error", "Uncategorized subtitle error. Details: ${errorMessage}.", ValidationLevel.ERROR, new OptionValue[0]),
    ITT_SAMPLE_MISSING_FTAB(2230, "mediaValidation.subtitle.sample.ftab.missing", "Subtitle sample #${sampleNo} does not have a required font table", ValidationLevel.WARNING, new OptionValue[0]),
    ITT_NON_MONOTONIC_TIMECODE(2240, "mediaValidation.subtitle.sample.timecode", "Subtitle samples do not increase monotonically:${timestamp}", ValidationLevel.ERROR, new OptionValue[0]),
    ITT_INVALID_DURATION(2250, "mediaValidation.subtitle.sample.invalidduration", "Subtitle duration should be greater than zero: ${timestamp}", ValidationLevel.ERROR, new OptionValue[0]),
    ITT_TIMESTAMP_FORMAT_IS_INVALID_WRT_DROPFRAME(2260, "mediaValidation.subtitles.timestampdropframe.invalid", "The subtitles document is nonDrop, but the timecode ${timestamp} is using an invalid timecode separator (;). Please correct timestamps to use non-drop frame delimiters.", "At least one timecode ${timestamp} is not formatted correctly. Use colons instead of semi-colons as timecode delimiters.", ValidationLevel.ERROR, new OptionValue[0]),
    ITT_TIMESTAMP_MISSING(2270, "mediaValidation.subtitles.timestamp.missing", "Missing timestamp in cue:${message}", ValidationLevel.ERROR, new OptionValue[0]),
    ITT_INVALID_NUMBER_OF_DIV_ELEMENTS(2280, "mediaValidation.subtitles.invalidnumberof.div", "Subtitles should have one and only one div element within the body element.", ValidationLevel.ERROR, new OptionValue(Option.grandfatherable)),
    ITT_TIMESTAMP_INVALID_TIMECODE(2290, "mediaValidation.subtitles.adjustedtimecode.invalid", "Adjusted timestamp in cue: ${start} to ${end} is negative after applying offset ${offset}. Please correct.", ValidationLevel.ERROR, new OptionValue[0]),
    ITT_CONTAINS_XML_EXTERNAL_ENTITY(2300, "mediaValidation.subtitles.contains.xmlexternalentity", "Subtitle contains XML External Entity: ${errorMessage}.", ValidationLevel.ERROR, new OptionValue[0]),
    ITT_CONTAINS_ITALICS_ROMAN_WITH_CJK(2310, "mediaValidation.subtitles.contains.italicsromanwithcjk", "${textData} - ${errorMessage}.", ValidationLevel.WARNING, new OptionValue[0]),
    ITT_CONTAINS_BAD_CHARACTER(2320, "mediaValidation.subtitles.contains.badCharacters", "Subtitle cues with start time codes ${startTimeCodeList} (and possibly more) contain the following characters (hex code) that are known to render poorly in certain clients: ${badCharList}", ValidationLevel.WARNING, new OptionValue[0]),
    VTT_GROUPID_NONINTEGER(2320, "mediaValidation.vtt.groupId.nonInteger", "${groupType} ${groupIdValue} is not an integer.", ValidationLevel.ERROR, new OptionValue[0]),
    VTT_ALTERNATE_GROUP_MISSING(2330, "mediaValidation.vtt.alternate.group.missing", "to_alternate_group ${toAltGrp} does not exist as an alternate_group.", ValidationLevel.ERROR, new OptionValue[0]),
    VTT_ALTERNATE_GROUP_TYPE_MISMATCH(2340, "mediaValidation.vtt.alternate.group.type.mismatch", "alternate_group ${altGrp} and to_alternate_group ${toAltGrp} track types do not match.", ValidationLevel.ERROR, new OptionValue[0]),
    VTT_ALTERNATE_GROUP_INVALID(2350, "mediaValidation.vtt.alternate.group.invalid", "to_alternate_group ${toAltGrp} is not a valid value.", ValidationLevel.ERROR, new OptionValue[0]),
    DUBCARD_MISSING_DESCRIPTION(3000, new OptionValue[0]),
    DUBCARD_HAS_NO_VIDEO(3001, "mediaValidation.dubcard.video.missing", "Your dub card asset can't be processed because an acceptable video track can't be found. Check your dub card asset and redeliver.", ValidationLevel.ERROR, new OptionValue[0]),
    DUBCARD_FRAMERATE_DOES_NOT_MATCH_SOURCE_FRAMERATE(3002, "mediaValidation.dubcard.framerate.mismatch", "Frame rate: ${dubCardFrameRate} of dub card does not match frame rate of source video ${videoFrameRate} (within ${epsilon})", ValidationLevel.ERROR, new OptionValue[0]),
    DUBCARD_ENCODEDDIM_MISMATCH(3003, "mediaValidation.dubcard.encoded.dimensions.mismatch", "Encoded dub card dimensions (${dubCardDimensions}) does not match video source (${videoDimensions})", ValidationLevel.ERROR, new OptionValue[0]),
    DUBCARD_DISPLAYDIM_MISMATCH(3004, "mediaValidation.dubcard.display.dimensions.mismatch", "Dub card display dimensions (${dubCardDimensions}) does not match video source (${videoDimensions})", ValidationLevel.ERROR, new OptionValue[0]),
    DUBCARD_DURATION_NOTSUPPORTED(3005, "mediaValidation.dubcard.duration.notsupported", "Dub card has duration of ${duration} milliseconds which is less than the minimum allowable duration of ${minDuration} milliseconds.", ValidationLevel.ERROR, new OptionValue[0]),
    DUBCARD_CROP_NOTSUPPORTED(3005, "mediaValidation.dubcard.crop.notsupported", "Dub cards are not permitted to have crop attributes.", ValidationLevel.ERROR, new OptionValue[0]),
    DUBCARD_LOCALE_MISMATCH(3006, "mediaValidation.dubcard.locale.mismatch", "You must provide an audio track locale that matches your dub card locale ${locale}.", ValidationLevel.ERROR, new OptionValue[0]),
    DUBCARD_PASP_MISMATCH(3007, "mediaValidation.dubcard.pasp.mismatch", "Dub card with aspect ratio (${dubCardDimensions}) does not match video aspect ratio (${videoDimensions})", ValidationLevel.ERROR, new OptionValue[0]),
    DUBCARD_TRACK_TIMESCALE_MISMATCH("mediaValidation.dubcard.track.timescale.mismatch", "Dubcard time scale (${dubcardTimescale}) does not match the Track (${trackName}) timescale (${trackTimescale}).", "Dubcard time scale does not match track time scale.", ValidationLevel.SHADOW, new OptionValue[0]),
    CC_OFFSET_VALUE_INVALID(4000, new OptionValue[0]),
    CC_COMPUTED_FIRST_TIMECODE_AFTER_APPLYING_OFFSET_INVALID(4001, "mediaValidation.captions.negativeFirstTimecode", "Captions document, has a program offset that makes the first timecode negative: ${timeCode}", ValidationLevel.ERROR, new OptionValue[0]),
    CC_LAST_TIMECODE_AFTER_LAST_VIDEO_TIMECODE(4002, "mediaValidation.captions.duration.mismatch", "Captions has a time code beyond the duration of the video", ValidationLevel.ERROR, new OptionValue[0]),
    CC_LAST_TIMECODE_WITH_OFFSET_AFTER_LAST_VIDEO_TIMECODE(4002, "mediaValidation.captions.duration.allowedOffsetInSeconds", "Captions has a time code beyond the duration of the video", ValidationLevel.ERROR, new OptionValue[0]),
    CC_ONEORMORE_DESCRIPTION_EXCEPTIONS_EXIST(4003, new OptionValue[0]),
    CC_LASTTIMECODE_MISSING(4004, "mediaValidation.captions.timecode.last.missing", "SCC file is missing final time code entry", ValidationLevel.ERROR, new OptionValue[0]),
    CC_PROGRAMSTARTTIMECODE_INVALID(4005, "mediaValidation.captions.program.start.timecode.invalid", "Program.start.timecode entry, ${timeCode}, is not valid", ValidationLevel.ERROR, new OptionValue[0]),
    CC_FIRSTTIMECODE_MISSING(4006, "mediaValidation.captions.timecode.first.missing", "SCC file is missing first time code entry", ValidationLevel.ERROR, new OptionValue[0]),
    CC_FIRSTTIMECODE_NEGATIVE(4007, "mediaValidation.captions.timefirst.first.negative", "Captions document, has a program offset that makes the first timecode negative: ${captionMediaTime}", ValidationLevel.ERROR, new OptionValue[0]),
    CC_SCENARIST_SCC_MISSING("mediaValidation.captions.scenarist.scc.missing", "${javaClass}: Expected \"Scenarist_SCC V1.0\" Line: ${lineNumber}", "Your closed captions file is missing the \"Scenarist_SCC V1.0\" on the first line.", ValidationLevel.ERROR, new OptionValue[0]),
    CC_BLANK_LINE_EXPECTED("mediaValidation.captions.blank.line.expected", "${javaClass}: Expected a blank line Line: ${lineNumber}", "Your closed captions file should have a blank line at ${lineNumber}.", ValidationLevel.ERROR, new OptionValue[0]),
    CC_START_TIME_INVALID("mediaValidation.captions.start.time.invalid", "${javaClass}: Time code ${startTime} begins before the ${compareToType} of time code of previous line ${compareToTime} Line: ${line}", "The start time ${startTime} begins before the ${compareToType} time of previous line at line ${line}.", ValidationLevel.ERROR, new OptionValue[0]),
    CC_DROP_MODE_MISMATCH("mediaValidation.captions.drop.mode.mismatch", "${javaClass}: Time code drop mode of current time code: ${currentTimeCode} does not match with the drop mode of previous time code: ${previousTimeCode} Line: ${line}", "The timecode drop mode of ${currentTimeCode} is inconsistent with previous timecode values at line ${line}.", ValidationLevel.ERROR, new OptionValue[0]),
    CC_PARITY_CHECK_FAILURE("mediaValidation.captions.parity.check.failure", "${javaClass}: SCC item ${item} (position ${position}) fails parity check! Line: ${line}", "The SCC parity check fails at line ${line} char ${position}.", ValidationLevel.ERROR, new OptionValue[0]),
    CC_LINE_NULL("mediaValidation.captions.line.null", "${javaClass}: Null line passed in", "Your captions file contains an invalid null line.", ValidationLevel.ERROR, new OptionValue[0]),
    CC_LINE_FORMAT_INVALID("mediaValidation.captions.line.format.invalid", "${javaClass}: Line is not of format <timecode><tab><SCC payload> Line: ${line}", "An incorrect line format was detected at line ${line}. Please ensure that the line is of the format <timecode><tab><SCC payload>.", ValidationLevel.ERROR, new OptionValue[0]),
    CC_TIME_CODE_INVALID("mediaValidation.captions.time.code.invalid", "${javaClass}: Invalid timecode ${timeCode} Line: ${line}", "Your captions file contains an invalid timecode ${timeCode} at line ${line}", ValidationLevel.ERROR, new OptionValue[0]),
    CC_HEX_CHARACTERS_INVALID("mediaValidation.captions.hex.characters.invalid", "${javaClass}: The ${position} on line ${line} should be 4 hex characters, please fix.", "The ${position} on line ${line} should be 4 hex characters, please fix.", ValidationLevel.ERROR, new OptionValue[0]),
    CHAPTER_LAST_TIMECODE_AFTER_LAST_VIDEO_TIMECODE(5000, "mediaValidation.chapters.duration.mismatch", "Chapters document contains time code (${lastTimeCode}) after the end of the movie (${videoLastTimeCode})", "Your chapter metadata has a timecode ${subtitleTimeCode} that exceeds the length of your video.", ValidationLevel.ERROR, new OptionValue[0]),
    AUD_APPEARS_CORRUPT(32768, new OptionValue[0]),
    AUD_CONTAINER_INCOMPATIBLE(32769, new OptionValue[0]),
    AUD_CRC_FAILED(32770, new OptionValue[0]),
    AUD_CONTAINED_VIDEO_TRACK(32771, new OptionValue[0]),
    AUD_CONTAINED_NO_AUDIO_TRACK(32772, new OptionValue[0]),
    AUD_FILESIZE_TOO_LARGE(32773, new OptionValue[0]),
    AUD_DURATION_TOO_LONG(32774, new OptionValue[0]),
    AUD_TRUNCATED(32775, new OptionValue[0]),
    AUD_UKNOWN_ERROR(32776, new OptionValue[0]),
    AUD_FAIRPLAY_PROTECTED(32777, new OptionValue[0]),
    AUD_CONTAINED_MULTIPLE_STREAM_INFO(32778, new OptionValue[0]),
    SOURCE_ROLE_MISSING(6000, "mediaValidation.source.missing", "You must include a video source file with your package.", ValidationLevel.ERROR, new OptionValue[0]),
    SOURCE_ROLE_MISMATCH(6001, "mediaValidation.source.mismatch", "The package contains multiple source files. Remove all but one source file. To replace an existing source file, use a locale that matches the original asset's locale and set the remove attribute. Source files detected: ${sourceFiles}", ValidationLevel.ERROR, new OptionValue[0]),
    FILE_EMPTY(6105, "mediaValidation.file.empty", "File does not contain any content", ValidationLevel.ERROR, new OptionValue[0]),
    FILE_ALERT_PASSTHROUGH(6107, "mediaValidation.file.alert", "${message}", ValidationLevel.ERROR, new OptionValue(Option.grandfatherable)),
    MPEG2_WIDTH_MISSING(7400, "mediaValidation.mpeg2.width.missing", "Missing container width", ValidationLevel.SHADOW, new OptionValue[0]),
    MPEG2_ENCDIM_MISSING(7401, "mediaValidation.mpeg2.encode.dimensions.missing", "Missing container encoded dimensions", ValidationLevel.SHADOW, new OptionValue[0]),
    MPEG2_DISPDIM_MISSING(7402, "mediaValidation.mpeg2.display.dimensions.missing", "Missing container display dimensions", ValidationLevel.SHADOW, new OptionValue[0]),
    MPEG2_DATARATE_MISSING(7410, "mediaValidation.mpeg2.datarate.missing", "Missing container data rate", ValidationLevel.SHADOW, new OptionValue[0]),
    MPEG2_DATARATE_INVALID(7411, "mediaValidation.mpeg2.datarate.invalid", "Missing container data rate, ${dateRate}, is invalid", ValidationLevel.SHADOW, new OptionValue[0]),
    MPEG2_ITEM_CHECK(7420, "mediaValidation.mpeg2.item.check", "(${messaage}) Encountered an issue", ValidationLevel.SHADOW, new OptionValue[0]),
    MPEG2_ITEM_FATAL(7421, "mediaValidation.mpeg2.item.fatal", "(${messaage}) Encountered an issue", ValidationLevel.SHADOW, new OptionValue[0]),
    MPEG2_STREAM_CODECNAME_MISSING(7430, "mediaValidation.mpeg2.stream.codec.name.missing", "Missing required codec", ValidationLevel.SHADOW, new OptionValue[0]),
    QT_ATOM_EXTENDS_BEYOND_FILE(7500, "mediaValidation.qt.atom.extendsBeyondFile", "${message}", ValidationLevel.SHADOW, new OptionValue(Option.grandfatherable)),
    AUDIO_MISSING(7101, "mediaValidation.audio.missing", "Your asset is missing an audio track or has an invalid audio track. Use a supported option listed in the iTunes Video and Audio Asset Guide.", ValidationLevel.ERROR, new OptionValue[0]),
    AUDIO_NOT_ENABLED(7102, "mediaValidation.audio.notenabled", "All audio tracks are required to be enabled", ValidationLevel.ERROR, new OptionValue[0]),
    AUDIO_CHMAP_INVALID(7110, "mediaValidation.audio.channelMap.invalid", "Invalid channel map: channels=${channelMap}", "Your audio channel map is invalid. Check the iTunes Video and Audio Asset Guide for audio track requirements.", ValidationLevel.ERROR, new OptionValue(Option.conformanceNames, Arrays.asList("valid channel labels")), new OptionValue(Option.grandfatherable)),
    AUDIO_CHLABEL_INVALID(7111, "mediaValidation.audio.channelLabel.invalid", "Your file contains a sound track with channel(s) labeled as '${channelName}', which is invalid. Check the iTunes Video and Audio Asset Guide for audio channel options.", ValidationLevel.ERROR, new OptionValue(Option.conformanceNames, Arrays.asList("testMono"))),
    AUDIO_CHMAP_ROLE_MISMATCH(7112, "mediaValidation.audio.features.invalidForThisRole", "Invalid audio features (${features}) for role ${roleName}", ValidationLevel.ERROR, new OptionValue(Option.grandfatherable)),
    AUDIO_DURATION_MISSING(7120, "mediaValidation.audio.duration.missing", "All audio should have a duration", ValidationLevel.SHADOW, new OptionValue[0]),
    AUDIO_DURATION_INVALID(7121, "mediaValidation.audio.duration.invalid", "Audio duration, ${duration}, is invalid", ValidationLevel.SHADOW, new OptionValue[0]),
    AUDIO_DURATION_MISMATCH(7124, "mediaValidation.audio.duration.mismatch", "All audio should have the same duration (${duration} is inconsistent with ${expectedDuration})", ValidationLevel.SHADOW, new OptionValue[0]),
    AUDIO_LOCALE_MISSING(7130, "mediaValidation.audio.language.missing", "All audio should have a language", ValidationLevel.SHADOW, new OptionValue[0]),
    AUDIO_LOCALE_INVALID(7131, "mediaValidation.audio.language.invalid", "All audio should have a valid language (${localeCode} is not valid)", ValidationLevel.SHADOW, new OptionValue[0]),
    AUDIO_LOCALE_MISMATCH(7134, "mediaValidation.audio.language.mismatch", "All audio should have the same language codes (${localeCode} is inconsistent with ${expectedLocaleCode})", "Your audio tracks contain inconsistent language codes ${localeCode}, ${expectedLocaleCode}", ValidationLevel.SHADOW, new OptionValue[0]),
    AUDIO_SAMPLERATE_MISSING(7140, "mediaValidation.audio.sampleRate.missing", "All audio must have a sample rate", ValidationLevel.SHADOW, new OptionValue[0]),
    AUDIO_SAMPLERATE_INVALID(7141, "mediaValidation.audio.sampleRate.invalid", "Audio sample rate, ${sampleRate}, is in invalid", ValidationLevel.SHADOW, new OptionValue[0]),
    AUDIO_SAMPLERATE_MISMATCH(7142, "mediaValidation.audio.sampleRate.mismatch", "Audio sample rates must be the same across all channels", ValidationLevel.SHADOW, new OptionValue[0]),
    AUDIO_SAMPLERATE_TOOSMALL(7143, "mediaValidation.audio.sampleRate.toosmall", "Audio sample rate of ${sampeRate} Hz is invalid, it must be at least ${minSampleRate} Hz", ValidationLevel.ERROR, new OptionValue[0]),
    AUDIO_DATARATE_MISSING(7150, "mediaValidation.audio.dataRate.missing", "All audio must hve a data rate", ValidationLevel.SHADOW, new OptionValue[0]),
    AUDIO_DATARATE_INVALID(7151, "mediaValidation.audio.dataRate.invalid", "Audio data rates must be specified in kbps, ${dateRate} is not supported", ValidationLevel.SHADOW, new OptionValue[0]),
    AUDIO_DATARATE_MISMATCH(7152, "mediaValidation.audio.dataRate.mismatch", "Audio data rates must be the same across all channels", ValidationLevel.SHADOW, new OptionValue[0]),
    AUDIO_CODEC_MISSING(7134, "mediaValidation.audio.codec.missing", "Audio codec not known", ValidationLevel.ERROR, new OptionValue[0]),
    AUDIO_CODEC_INVALID(7154, "mediaValidation.audio.codec.invalid", "Audio codec, ${audioCodec}, is invalid.  It should be one of ${expectedAudioCodecs}", ValidationLevel.ERROR, new OptionValue[0]),
    AUDIO_CODEC_MISMATCH(7155, "mediaValidation.audio.codec.mismatch", "Audio codec must be thge same across all related channels", ValidationLevel.ERROR, new OptionValue[0]),
    AUDIO_BITDEPTH_MISSING(7156, "mediaValidation.audio.bitDepth.missing", "All audio must have a bit depth", ValidationLevel.ERROR, new OptionValue[0]),
    AUDIO_BITDEPTH_INVALID(7157, "mediaValidation.audio.bitDepth.invalid", "Audio bit depth ${bitDepth} is not supported", ValidationLevel.ERROR, new OptionValue[0]),
    AUDIO_BITDEPTH_MISMATCH(7158, "mediaValidation.audio.bitDepth.mismatch", "Audio bit depth must be the same across all channels", ValidationLevel.ERROR, new OptionValue[0]),
    AUDIO_BITDEPTH_TOOSMALL(7159, "mediaValidation.audio.bitDepth.toosmall", "Audio bit depth ${bitDepth} is not supported, it must be at least ${minBitDepth} bits per sample", ValidationLevel.ERROR, new OptionValue[0]),
    AUDIO_DESCRIPTION_LOCALE_MISMATCH("mediaValidation.descriptiveAudio.language.mismatch", "Audio description language code should match the audio language codes. (${localeCode} is inconsistent with ${expectedLocaleCode})", "Your audio description tracks contain language code ${localeCode} inconsistent with ${expectedLocaleCode}.", ValidationLevel.WARNING, new OptionValue[0]),
    VIDEO_MISSING(7201, "mediaValidation.video.missing", "Your video asset can't be processed because an acceptable video track can't be found. Check your video asset and redeliver.", ValidationLevel.ERROR, new OptionValue[0]),
    VIDEO_DURATION_MISSING(7210, "mediaValidation.video.duration.missing", "All video should have a duration", ValidationLevel.SHADOW, new OptionValue[0]),
    VIDEO_DURATION_INVALID(7211, "mediaValidation.video.duration.invalid", "Video duration, ${duration}, is invalid.", ValidationLevel.SHADOW, new OptionValue[0]),
    VIDEO_TIMESCALE_MISSING(7222, "mediaValidation.video.durationStatistics.timeScale.missing", "Track ${trackName} of kind ${trackKind} has no time scale", "All video should have a time scale", ValidationLevel.SHADOW, new OptionValue[0]),
    VIDEO_TIMESCALE_INVALID(7223, "mediaValidation.video.durationStatictics.timeScale.invalid", "Video time scale, ${timeScale}, is invalid", ValidationLevel.SHADOW, new OptionValue[0]),
    VIDEO_CODEC_MISSING(7213, "mediaValidation.video.codec.missing", "Video codec not known", ValidationLevel.SHADOW, new OptionValue[0]),
    VIDEO_CODEC_INVALID(7214, "mediaValidation.video.codec.invalid", "Video codec, ${videoCodec}, is invalid", ValidationLevel.SHADOW, new OptionValue[0]),
    VIDEO_DISPDIM_MISSING(7216, "mediaValidation.video.display.dimensions.missing", "Display dimensions are required", ValidationLevel.SHADOW, new OptionValue[0]),
    VIDEO_ENCDIM_MISSING(7217, "mediaValidation.video.encode.dimensions.missing", "Encode dimensions are required", ValidationLevel.SHADOW, new OptionValue[0]),
    VIDEO_FRAMERATE_MISSING(7219, "mediaValidation.video.framerate.missing", "Video frame rate required", ValidationLevel.SHADOW, new OptionValue[0]),
    VIDEO_FRAMERATE_INVALID(7220, "mediaValidation.video.framerate.invalid", "Video frame rate, ${frameRate}, is invalid", ValidationLevel.SHADOW, new OptionValue[0]),
    VIDEO_FRAMERATE_BELOW_23500(7221, "mediaValidation.video.framerate.below23500", "Video frame rate, ${frameRate}, should be at least 23.5 frames per second", ValidationLevel.ERROR, new OptionValue[0]),
    VIDEO_FRAMERATE_UNIFORM_INVALID(7222, "mediaValidation.video.framerate.uniform.invalid", "Video frame rate uniform flag is invalid", ValidationLevel.SHADOW, new OptionValue[0]),
    VIDEO_GAMMA_MISSING(7225, "mediaValidation.video.durationStatistics.gamma.missing", "Duration statistics missing gama attribute", ValidationLevel.SHADOW, new OptionValue[0]),
    VIDEO_GAMMA_INVALID(7226, "mediaValidation.video.durationStatictics.gamma.invalid", "Duration statistics gamma attribute, ${value}, is invalid", ValidationLevel.SHADOW, new OptionValue[0]),
    VIDEO_GAMMA_NOTSUPPORTED(7227, "mediaValidation.video.durationStatistics.gamma.notsupported", "Gamma has an unsupported value ${value}. Please contact your Tech Label Rep for assistance.", ValidationLevel.ERROR, new OptionValue[0]),
    VIDEO_COLORSPACE_MISSING(7228, "mediaValidation.video.colorSpace.missing", "Video is missing color space specification", ValidationLevel.SHADOW, new OptionValue[0]),
    VIDEO_COLORSPACE_INVALID(7229, "mediaValidation.video.colorSpace.invalid", "Video color space specification, ${colorSpace}, is invalid", "Your video color space configuration is invalid. Check the iTunes Video and Audio Asset Guide for video color space requirements.", ValidationLevel.SHADOW, new OptionValue[0]),
    VIDEO_FIELDORDERING_MISSING(7231, "mediaValidation.video.fieldOrdering.missing", "Field order is missing", ValidationLevel.SHADOW, new OptionValue[0]),
    VIDEO_FIELDORDERING_INVALID(7232, "mediaValidation.video.fieldOrdering.invalid", "Field order, ${fieldOrdering}, is invalid", ValidationLevel.SHADOW, new OptionValue[0]),
    VIDEO_SOURCEDIM_TOOSMALL(7235, "mediaValidation.video.source.dimensions.toosmall", "Cropped video dimensions, ${dimensions}, cannot be less than ${minimumDimensions}", ValidationLevel.ERROR, new OptionValue[0]),
    VIDEO_CROPPEDDIM_INVALID(7237, "mediaValidation.video.cropped.dimensions.invalid", "Cropped video dimensions, ${cropDimensions}, are invalid", ValidationLevel.ERROR, new OptionValue[0]),
    VIDEO_CROPPEDDIM_TOOSMALL(7238, "mediaValidation.video.cropped.dimensions.toosmall", "Dimensions of ${sourceDimensions} cropped by ${cropDimensions} results in a cropped source of ${croppedDimensions} which cannot be smaller than ${minimumDimensions}", ValidationLevel.ERROR, new OptionValue[0]),
    VIDEO_CROPPEDAR_INVALID(7239, "mediaValidation.video.cropped.aspectratio.invalid", "Cropped aspect ratio, ${dimensions}, is invalid", ValidationLevel.ERROR, new OptionValue[0]),
    VIDEO_VERTCROP_MISSING(7240, "mediaValidation.video.cropped.dimensions.vertical.missing", "Use a vertical crop of at least ${minimumCrop} pixels. This is required for video source files with dimensions of ${dimensions} pixels. If you need help, contact your Technical Label Representative for assistance.", ValidationLevel.ERROR, new OptionValue[0]),
    VIDEO_FIELDCOUNT_NOTSUPPORTED(7241, "mediaValidation.video.fieldcount.notsupported", "Field count of ${fieldCount} is not supported. Please contact your Tech Label Rep for assistance.", ValidationLevel.ERROR, new OptionValue[0]),
    VIDEO_GRAPHICSMODE_NOTSUPPORTED(7243, "mediaValidation.video.graphicsmode.notsupported", "Video uses an unsupported GraphicsMode '${graphicsMode}'. Please contact your Tech Label Rep for assistance.", ValidationLevel.ERROR, new OptionValue(Option.grandfatherable)),
    VIDEO_LOCALE_MISSING(7244, "mediaValidation.video.locale.missing", "No locale is provided though Video has an Audio track.", "You must choose a locale for videos with an audio track.", ValidationLevel.WARNING, new OptionValue[0]),
    VIDEO_DISPDIM_NOT_PREFERRED(7245, "mediaValidation.video.display.dimensions.notpreferred", "${message}", ValidationLevel.WARNING, new OptionValue[0]),
    VIDEO_VFR_NO_SUPPORTED(7246, "mediaValidation.video.framerate.notconstant", "Video should have a constant frame rate", ValidationLevel.SHADOW, new OptionValue(Option.grandfatherable)),
    CAPTIONS_MISSING(7301, "mediaValidation.captions.missing", "Missing required captions", ValidationLevel.SHADOW, new OptionValue[0]),
    CAPTIONS_FILE_HASERRORS(7332, "mediaValidation.captions.file.errors", "${errorMessage}", "Your closed captions file is not valid. Details: ${errorMessage}", ValidationLevel.ERROR, new OptionValue[0]),
    CAPTIONS_DURATION_MISSING(7310, "mediaValidation.captions.duration.missing", "All captions should have a duration", ValidationLevel.SHADOW, new OptionValue[0]),
    CAPTIONS_DURATION_INVALID(7311, "mediaValidation.captions.duration.invalid", "Captions duration, ${duration}, is invalid", ValidationLevel.SHADOW, new OptionValue[0]),
    CAPTIONS_DURATION_MISMATCH(7312, "mediaValidation.captions.duration.mismatch", "All captions should have the same duration (${duration} is inconsistent with ${expectedDuration})", "Your closed captions file has a timecode that exceeds the length of your video.", ValidationLevel.SHADOW, new OptionValue[0]),
    CAPTIONS_DURATION_TOOLONG(7313, "mediaValidation.catpions.duration.toolong", "Chapters document contains time code (${duration}) after the end of the movie (${videoDuration})", ValidationLevel.SHADOW, new OptionValue[0]),
    CAPTIONS_LOCALE_MISSING(7320, "mediaValidation.captions.language.missing", "All captions should have a language", ValidationLevel.SHADOW, new OptionValue[0]),
    CAPTIONS_LOCALE_INVALID(7321, "mediaValidation.captions.language.invalid", "All captions should have a valid language (${localeCode} is not valid)", ValidationLevel.SHADOW, new OptionValue[0]),
    CAPTIONS_LOCALE_MISMATCH(7323, "mediaValidation.captions.language.mismatch", "All captions should have the same language codes ${localeCode} is inconsistent with ${expectedLocaleCode})", ValidationLevel.SHADOW, new OptionValue[0]),
    CAPTIONS_TRACKDIM_MISSING(7330, "mediaValidation.captions.track.dimensions.missing", "Captions track dimensions are required", ValidationLevel.SHADOW, new OptionValue[0]),
    CAPTIONS_TRACKDIM_INVALID(7331, "mediaValidation.captions.track.dimensions.invalid", "Captions track dimensions, ${dimensions}, are invalid", ValidationLevel.SHADOW, new OptionValue[0]),
    HDR_SOURCE_ROLE_MISMATCH(7600, "mediaValidation.hdrsource.mismatch", "The package contains multiple source.hdr files. Remove all but one source file. To replace an existing source file, use a locale that matches the original asset's locale and set the remove attribute. Source files detected: ${sourceFiles}", ValidationLevel.ERROR, new OptionValue[0]),
    HDR_SOURCE_MISSING(7601, "mediaValidation.hdrsource.missing", "HDR source is missing from the source.hdr file", ValidationLevel.ERROR, new OptionValue[0]),
    HDR_SOURCE_NOT_ACCEPTABLE_FOR_VIDEOTYPE("mediaValidation.hdrsource.codec.notsupported", "Video source (codec ${codec}) does not match any of the accepted video codecs ${validCodecs} for type ${videoFileType}, UTI ${uti}", "The video codec ${codec} is invalid. Use only supported video codecs listed in the iTunes Video and Audio Asset Guide.", ValidationLevel.FATAL, new OptionValue(Option.grandfatherable), new OptionValue(Option.conformanceNames, Arrays.asList("testNonHQProRes"))),
    HDR_SOURCE_COLORSPACE_INVALID("mediaValidation.hdrsource.colorSpace.invalid", "HDR Video color space specification, ${colorSpace}, is invalid", "Your HDR video color space configuration is invalid. Check the iTunes Video and Audio Asset Guide for video color space requirements.", ValidationLevel.ERROR, new OptionValue[0]),
    HDR_SOURCE_DURATION_MISMATCH("mediaValidation.hdrsource.duration.mismatch", "The duration of the HDR source, ${hdrsourceduration}, is different from the duration of the source, ${sourceduration} with a tolerance of ${hdrdurationtolerance} milliseconds", "The duration of the HDR source is different from the duration of the source. Check the iTunes Video and Audio Asset Guide for video color space requirements.", ValidationLevel.ERROR, new OptionValue[0]),
    HDR_SOURCE_DURATION_TOO_LONG("mediaValidation.hdrsource.duration.toolong", "The duration of the HDR source, ${hdrsourceduration}, is longer than the duration of the source, ${sourceduration}, with a tolerance of ${hdrdurationtolerance} milliseconds", "The duration of the HDR source is longer than the duration of the source. Check the iTunes Video and Audio Asset Guide for video color space requirements.", ValidationLevel.WARNING, new OptionValue[0]),
    HDR_SOURCE_DURATION_WAY_TOO_LONG("mediaValidation.hdrsource.duration.excessive", "The duration of the HDR source, ${hdrsourceduration}, is longer than the duration of the source, ${sourceduration}", "The duration of the HDR source is longer than the duration of the source. Check the iTunes Video and Audio Asset Guide for video color space requirements.", ValidationLevel.ERROR, new OptionValue[0]),
    HDR_SOURCE_NOMINALFRAMERATE_MISMATCH("mediaValidation.hdrsource.framerate.mismatch", "The frame rate of the HDR source, ${hdrframerate}, does not match the frame rate of the source ${framerate}", "The frame rate of your source and HDR source do not match. Check the iTunes Video and Audio Asset Guide for video color space requirements.", ValidationLevel.ERROR, new OptionValue[0]),
    HDR_SOURCE_DISPLAYDIMENSIONS_MISMATCH("mediaValidation.hdrsource.displaydimensions.mismatch", "The display dimensions of the HDR source, ${hdrdimensions}, does not match the display dimensions of the source ${dimensions}", "The display dimensions of your source and HDR source do not match. Check the iTunes Video and Audio Asset Guide for video color space requirements.", ValidationLevel.SHADOW, new OptionValue[0]),
    HDR_SOURCE_ENCODEDDIMENSIONS_MISMATCH("mediaValidation.hdrsource.encodeddimensions.mismatch", "The encoded dimensions of the HDR source, ${hdrdimensions}, does not match the encoded dimensions of the source ${dimensions}", "The encoded dimensions of your source and HDR source do not match. Check the iTunes Video and Audio Asset Guide for video color space requirements.", ValidationLevel.SHADOW, new OptionValue[0]),
    HDR_SOURCE_PASP_MISMATCH("mediaValidation.hdrsource.pasp.mismatch", "The aspect ration of the HDR source, ${hdrpasp}, does not match the aspect ratio of the source ${pasp}", "The aspect ration (PASP) of your source and HDR source do not match. Check the iTunes Video and Audio Asset Guide for video color space requirements.", ValidationLevel.ERROR, new OptionValue[0]),
    HDR_SOURCE_UNIFORM_FRAMERATE_INVALID("mediaValidation.hdrsource.uniformframerate.invalid", "The frame rate of the HDR source is not uniform. All video frames must have the same duration ", "The frame rate of the HDR source is not uniform. All video frames must have the same duration", ValidationLevel.ERROR, new OptionValue[0]),
    HDR_SOURCE_HDR_FORMAT_MISSING("mediaValidation.hdrsource.hdrformat.missing", "HDR source should always have a HDR format specified. Please correct and resubmit.", ValidationLevel.ERROR, new OptionValue[0]),
    HDR_SOURCE_HDR_FORMAT_INVALID("mediaValidation.hdrsource.hdrformat.invalid", "The HDR format specified (${hdr.format}) is not valid. Please correct and resubmit.", ValidationLevel.ERROR, new OptionValue[0]),
    HDR_SOURCE_NOT_PROGRESSIVE("mediaValidation.hdrSource.progressive.mismatch", "HDR source should be progressive. Please correct and resubmit.", ValidationLevel.ERROR, new OptionValue[0]),
    HDR_SOURCE_ASPECTRATIO_NONSTANDARD("mediaValidation.hdrSource.aspectratio.nonstandard", "The ${ar} aspect ratio of the HDR source does not conform to the standard HDR source aspect ratio of 16:9", "The ${ar} aspect ratio of the HDR source does not conform to the standard HDR source aspect ratio of 16:9", ValidationLevel.WARNING, new OptionValue[0]),
    HDR_SOURCE_AUDIO_PRESENT("mediaValidation.hdrSource.audio.present", "The HDR source contains embedded audio tracks. The audio tracks will be ignored.", "The HDR source contains embedded audio tracks. The audio tracks will be ignored.", ValidationLevel.WARNING, new OptionValue[0]),
    HDR_MAPPING_ROLE_MISMATCH("mediaValidation.hdrmapping.mismatch", "The package contains multiple mapping.hdr files. Remove all but one source file. To replace an existing source file, use a locale that matches the original asset's locale and set the remove attribute. Source files detected: ${sourceFiles}", ValidationLevel.ERROR, new OptionValue[0]),
    HDR_MAPPING_MISSING("mediaValidation.hdrmapping.missing", "HDR mapping is missing from the mapping.hdr file", ValidationLevel.ERROR, new OptionValue[0]),
    HDR_MAPPING_NOTSUPPORTED("mediaValidation.hdrmapping.notsupported", "HDR mapping is not supported", ValidationLevel.ERROR, new OptionValue[0]),
    HDR_MAPPING_VERSION_MISSING("mediaValidation.hdrmapping.version.missing", "HDR mapping is invalid", ValidationLevel.ERROR, new OptionValue[0]),
    HDR_MAPPING_VERSION_INVALID("mediaValidation.hdrmapping.version.invalid", "HDR mapping is invalid", ValidationLevel.ERROR, new OptionValue[0]),
    HDR_MAPPING_VERSION_NOTSUPPORTED("mediaValidation.hdrmapping.version.notsupported", "HDR mapping is invalid", ValidationLevel.SHADOW, new OptionValue[0]),
    HDR_MAPPING_TRACK_ID_MISSING("mediaValidation.hdrmapping.track.id.missing", "HDR mapping is invalid", ValidationLevel.ERROR, new OptionValue[0]),
    HDR_MAPPING_TRACK_ID_INVALID("mediaValidation.hdrmapping.track.id.invalid", "HDR mapping is invalid", ValidationLevel.ERROR, new OptionValue[0]),
    HDR_MAPPING_TRACK_RATE_MISSING("mediaValidation.hdrmapping.track.rate.missing", "HDR mapping file is invalid", ValidationLevel.ERROR, new OptionValue[0]),
    HDR_MAPPING_TRACK_RATE_INVALID("mediaValidation.hdrmapping.track.rate.invalid", "HDR mapping file is invalid", ValidationLevel.ERROR, new OptionValue[0]),
    HDR_MAPPING_SHOTS_MISSING("mediaValidation.hdrmapping.shots.missing", "HDR mapping file is invalid", ValidationLevel.ERROR, new OptionValue[0]),
    HDR_MAPPING_SHOTS_INVALID("mediaValidation.hdrmapping.shots.invalid", "HDR mapping file is invalid", ValidationLevel.ERROR, new OptionValue[0]),
    HDR_MAPPING_TRACK_NAME_MISSING("mediaValidation.hdrmapping.track.name.missing", "HDR mapping is invalid", ValidationLevel.INFO, new OptionValue[0]),
    HDR_MAPPING_TRACK_NAME_INVALID("mediaValidation.hdrmapping.track.name.invalid", "HDR mapping is invalid", ValidationLevel.SHADOW, new OptionValue[0]),
    HDR_MAPPING_TRACK_NAME_NOTSUPPORTED("mediaValidation.hdrmapping.track.name.notsupported", "HDR mapping is invalid", ValidationLevel.SHADOW, new OptionValue[0]),
    HDR_MAPPING_SOURCES_MISSING("mediaValidation.hdrmapping.sources.missing", "HDR mapping is invalid", ValidationLevel.SHADOW, new OptionValue[0]),
    HDR_MAPPING_SOURCES_INVALID("mediaValidation.hdrmapping.sources.invalid", "HDR mapping is invalid", ValidationLevel.SHADOW, new OptionValue[0]),
    HDR_MAPPING_SOURCES_NOTSUPPORTED("mediaValidation.hdrmapping.sources.notsupported", "HDR mapping is invalid", ValidationLevel.SHADOW, new OptionValue[0]),
    HDR_MAPPING_SOURCE_ID_MISSING("mediaValidation.hdrmapping.source.id.missing", "HDR mapping is invalid", ValidationLevel.ERROR, new OptionValue[0]),
    HDR_MAPPING_SOURCE_ID_INVALID("mediaValidation.hdrmapping.source.id.invalid", "HDR mapping is invalid", ValidationLevel.ERROR, new OptionValue[0]),
    HDR_MAPPING_SOURCE_ID_NOTSUPPORTED("mediaValidation.hdrmapping.source.id.notsupported", "HDR mapping is invalid", ValidationLevel.SHADOW, new OptionValue[0]),
    HDR_MAPPING_SOURCE_ASSETID_MISSING("mediaValidation.hdrmapping.source.assetId.missing", "HDR mapping file is invalid (missing AssetID value)", "HDR mapping has a missing source asset identifier", ValidationLevel.NONE, new OptionValue[0]),
    HDR_MAPPING_SOURCE_ASSETID_INVALID("mediaValidation.hdrmapping.source.assetId.invalid", "HDR mapping file is invalid", "HDR mapping has an invalid source asset identifier", ValidationLevel.ERROR, new OptionValue[0]),
    HDR_MAPPING_SOURCE_ASSETID_NOTSUPPORTED("mediaValidation.hdrmapping.source.assetId.notsupported", "HDR mapping file is invalid", "HDR mapping has an unsupported source asset identifier", ValidationLevel.SHADOW, new OptionValue[0]),
    HDR_MAPPING_SOURCE_UNIQUEID_MISSING("mediaValidation.hdrmapping.source.uniqueId.missing", "HDR mapping file is invalid (missing UniqueID value)", "HDR mapping has a missing source unique identifier", ValidationLevel.NONE, new OptionValue[0]),
    HDR_MAPPING_SOURCE_CLIPNAME_MISSING("mediaValidation.hdrmapping.source.clipName.missing", "HDR mapping file is invalid (missing ClipName value)", "HDR mapping has a missing source asset clip name", ValidationLevel.NONE, new OptionValue[0]),
    HDR_MAPPING_SOURCE_RATE_MISSING("mediaValidation.hdrmapping.source.rate.missing", "HDR mapping file is invalid (missing rate)", "HDR mapping has a missing source rate", ValidationLevel.NONE, new OptionValue[0]),
    HDR_MAPPING_SOURCE_RATE_INVALID("mediaValidation.hdrmapping.source.rate.invalid", "HDR mapping file is invalid (source rate)", "HDR mapping has an invalid source rate", ValidationLevel.ERROR, new OptionValue[0]),
    HDR_MAPPING_SOURCE_RATE_NOTSUPPORTED("mediaValidation.hdrmapping.source.rate.notsupported", "HDR mapping file is invalid", "HDR mapping has an unsupported source rate", ValidationLevel.SHADOW, new OptionValue[0]),
    HDR_MAPPING_VIDEOTRACK_COLORENCODING_MISSING("mediaValidation.hdrmapping.videoTrack.colorEncoding.missing", "HDR mapping file does not include color encoding of video track", "HDR mapping is missing a color encoding entry", ValidationLevel.INFO, new OptionValue[0]),
    HDR_MAPPING_VIDEOTRACK_COLORENCODING_INVALID("mediaValidation.hdrmapping.videoTrack.colorEncoding.invalid", "HDR mapping file is invalid", "HDR mapping has an invalid color encoding entry", ValidationLevel.SHADOW, new OptionValue[0]),
    HDR_MAPPING_VIDEOTRACK_COLORENCODING_NOTSUPPORTED("mediaValidation.hdrmapping.videoTrack.colorEncoding.notsupported", "HDR mapping file is invalid", "HDR mapping has an unsupported color encoding entry", ValidationLevel.SHADOW, new OptionValue[0]),
    HDR_MAPPING_VIDEOTRACK_MASTERINGDISPLAY_MISSING("mediaValidation.hdrmapping.videoTrack.masteringDisplay.missing", "HDR mapping file is invalid", "HDR mapping is missing a master display entry", ValidationLevel.WARNING, new OptionValue[0]),
    HDR_MAPPING_VIDEOTRACK_MASTERINGDISPLAY_INVALID("mediaValidation.hdrmapping.videoTrack.masteringDisplay.invalid", "HDR mapping file is invalid", "HDR mapping has an invalid master display entry", ValidationLevel.SHADOW, new OptionValue[0]),
    HDR_MAPPING_VIDEOTRACK_MASTERINGDISPLAY_NOTSUPPORTED("mediaValidation.hdrmapping.videoTrack.masteringDisplay.notsupported", "HDR mapping file is invalid", "HDR mapping has an unsupported master display entry", ValidationLevel.SHADOW, new OptionValue[0]),
    HDR_MAPPING_SHOT_ID_MISSING("mediaValidation.hdrmapping.shot.id.missing", "HDR mapping file is invalid", "HDR mapping is missing a shot id", ValidationLevel.ERROR, new OptionValue[0]),
    HDR_MAPPING_SHOT_ID_INVALID("mediaValidation.hdrmapping.shot.id.invalid", "HDR mapping file is invalid", "HDR mapping has an invalid shot id", ValidationLevel.ERROR, new OptionValue[0]),
    HDR_MAPPING_SHOT_ID_NOTSUPPORTED("mediaValidation.hdrmapping.shot.id.notsupported", "HDR mapping file is invalid", "HDR mapping has an unsupported shot id", ValidationLevel.ERROR, new OptionValue[0]),
    HDR_MAPPING_SHOT_STARTIME_MISSING("mediaValidation.hdrmapping.shot.startTime.missing", "HDR mapping file is invalid", "HDR mapping is missing a shot start time", ValidationLevel.ERROR, new OptionValue[0]),
    HDR_MAPPING_SHOT_STARTIME_INVALID("mediaValidation.hdrmapping.shot.startTime.invalid", "HDR mapping file is invalid", "HDR mapping has an invalid shot start time", ValidationLevel.ERROR, new OptionValue[0]),
    HDR_MAPPING_SHOT_STARTIME_NOTSUPPORTED("mediaValidation.hdrmapping.shot.startTime.notsupported", "HDR mapping file is invalid", "HDR mapping has an unsupported shot start time", ValidationLevel.ERROR, new OptionValue[0]),
    HDR_MAPPING_SHOT_DURATION_MISSING("mediaValidation.hdrmapping.shot.duration.missing", "HDR mapping file is invalid", "HDR mapping is missing a shot duration", ValidationLevel.ERROR, new OptionValue[0]),
    HDR_MAPPING_SHOT_DURATION_INVALID("mediaValidation.hdrmapping.shot.duration.invalid", "HDR mapping file is invalid", "HDR mapping has an invalid shot (In: ${start} Duration: ${duration}). Its shot duration overlaps the next shot (In: ${nextStart} Duration: ${nextDuration}).", ValidationLevel.ERROR, new OptionValue[0]),
    HDR_MAPPING_SHOT_DURATION_NOTSUPPORTED("mediaValidation.hdrmapping.shot.duration.notsupported", "HDR mapping file is invalid", "HDR mapping has an unsupported shot duration", ValidationLevel.ERROR, new OptionValue[0]),
    HDR_MAPPING_SHOT_SOURCEIN_MISSING("mediaValidation.hdrmapping.shot.sourceIn.missing", "HDR mapping file is invalid", ValidationLevel.INFO, new OptionValue[0]),
    HDR_MAPPING_SHOT_SOURCEIN_INVALID("mediaValidation.hdrmapping.shot.sourceIn.invalid", "HDR mapping file is invalid", ValidationLevel.SHADOW, new OptionValue[0]),
    HDR_MAPPING_SHOT_SOURCEIN_NOTSUPPORTED("mediaValidation.hdrmapping.shot.sourceIn.notsupported", "HDR mapping file is invalid", ValidationLevel.SHADOW, new OptionValue[0]),
    HDR_MAPPING_SHOT_PARENTID_MISSING("mediaValidation.hdrmapping.shot.parentId.missing", "HDR mapping file is invalid", ValidationLevel.INFO, new OptionValue[0]),
    HDR_MAPPING_SHOT_PARENTID_INVALID("mediaValidation.hdrmapping.shot.parentId.invalid", "HDR mapping file is invalid", ValidationLevel.SHADOW, new OptionValue[0]),
    HDR_MAPPING_SHOT_PARENTID_NOTSUPPORTED("mediaValidation.hdrmapping.shot.parentId.notsupported", "HDR mapping file is invalid", ValidationLevel.SHADOW, new OptionValue[0]),
    HDR_MAPPING_OUTPUTS_MISSING("mediaValidation.hdrmapping.outputs.missing", "HDR mapping file is invalid", ValidationLevel.INFO, new OptionValue[0]),
    HDR_MAPPING_OUTPUTS_INVALID("mediaValidation.hdrmapping.outputs.invalid", "HDR mapping file is invalid", ValidationLevel.SHADOW, new OptionValue[0]),
    HDR_MAPPING_OUTPUTS_NOTSUPPORTED("mediaValidation.hdrmapping.outputs.notsupported", "HDR mapping file is invalid", ValidationLevel.SHADOW, new OptionValue[0]),
    HDR_MAPPING_OUTPUT_ID_MISSING("mediaValidation.hdrmapping.output.id.missing", "HDR mapping file is invalid", ValidationLevel.INFO, new OptionValue[0]),
    HDR_MAPPING_OUTPUT_ID_INVALID("mediaValidation.hdrmapping.output.id.invalid", "HDR mapping file is invalid", ValidationLevel.SHADOW, new OptionValue[0]),
    HDR_MAPPING_OUTPUT_ID_NOTSUPPORTED("mediaValidation.hdrmapping.output.id.notsupported", "HDR mapping file is invalid", ValidationLevel.SHADOW, new OptionValue[0]),
    HDR_MAPPING_OUTPUT_NAME_MISSING("mediaValidation.hdrmapping.output.name.missing", "HDR mapping file is invalid", ValidationLevel.INFO, new OptionValue[0]),
    HDR_MAPPING_OUTPUT_NAME_INVALID("mediaValidation.hdrmapping.output.name.invalid", "HDR mapping file is invalid", ValidationLevel.SHADOW, new OptionValue[0]),
    HDR_MAPPING_OUTPUT_NAME_NOTSUPPORTED("mediaValidation.hdrmapping.output.name.notsupported", "HDR mapping file is invalid", ValidationLevel.SHADOW, new OptionValue[0]),
    HDR_MAPPING_DISPLAY_ID_MISSING("mediaValidation.hdrmapping.display.id.missing", "HDR mapping file is invalid", ValidationLevel.INFO, new OptionValue[0]),
    HDR_MAPPING_DISPLAY_ID_INVALID("mediaValidation.hdrmapping.display.id.invalid", "HDR mapping file is invalid", ValidationLevel.SHADOW, new OptionValue[0]),
    HDR_MAPPING_DISPLAY_ID_NOTSUPPORTED("mediaValidation.hdrmapping.display.id.notsupported", "HDR mapping file is invalid", ValidationLevel.SHADOW, new OptionValue[0]),
    HDR_MAPPING_DISPLAY_NAME_MISSING("mediaValidation.hdrmapping.display.name.missing", "HDR mapping file is invalid", ValidationLevel.INFO, new OptionValue[0]),
    HDR_MAPPING_DISPLAY_NAME_INVALID("mediaValidation.hdrmapping.display.name.invalid", "HDR mapping file is invalid", ValidationLevel.SHADOW, new OptionValue[0]),
    HDR_MAPPING_DISPLAY_NAME_NOTSUPPORTED("mediaValidation.hdrmapping.display.name.notsupported", "HDR mapping file is invalid", ValidationLevel.SHADOW, new OptionValue[0]),
    HDR_MAPPING_DISPLAY_DIAGONALSIZE_MISSING("mediaValidation.hdrmapping.display.diagonalSize.missing", "HDR mapping file is invalid", ValidationLevel.INFO, new OptionValue[0]),
    HDR_MAPPING_DISPLAY_DIAGONALSIZE_INVALID("mediaValidation.hdrmapping.display.diagonalSize.invalid", "HDR mapping file is invalid", ValidationLevel.SHADOW, new OptionValue[0]),
    HDR_MAPPING_DISPLAY_DIAGONALSIZE_NOTSUPPORTED("mediaValidation.hdrmapping.display.diagonalSize.notsupported", "HDR mapping file is invalid", ValidationLevel.SHADOW, new OptionValue[0]),
    HDR_MAPPING_DISPLAY_BITDEPTH_MISSING("mediaValidation.hdrmapping.display.bitDepth.missing", "HDR mapping file is invalid", ValidationLevel.INFO, new OptionValue[0]),
    HDR_MAPPING_DISPLAY_BITDEPTH_INVALID("mediaValidation.hdrmapping.display.bitDepth.invalid", "HDR mapping file is invalid", ValidationLevel.SHADOW, new OptionValue[0]),
    HDR_MAPPING_DISPLAY_BITDEPTH_NOTSUPPORTED("mediaValidation.hdrmapping.display.bitDepth.notsupported", "HDR mapping file is invalid", ValidationLevel.SHADOW, new OptionValue[0]),
    HDR_MAPPING_DISPLAY_COLORSPACE_MISSING("mediaValidation.hdrmapping.display.colorSpace.missing", "HDR mapping file is invalid", ValidationLevel.INFO, new OptionValue[0]),
    HDR_MAPPING_DISPLAY_COLORSPACE_INVALID("mediaValidation.hdrmapping.display.colorSpace.invalid", "HDR mapping file is invalid", ValidationLevel.SHADOW, new OptionValue[0]),
    HDR_MAPPING_DISPLAY_COLORSPACE_NOTSUPPORTED("mediaValidation.hdrmapping.display.colorSpace.notsupported", "HDR mapping file is invalid", ValidationLevel.ERROR, new OptionValue[0]),
    HDR_MAPPING_DISPLAY_COLORSPACE_MISMATCH("mediaValidation.hdrmapping.display.colorSpace.mismatch", "HDR mapping file is invalid", ValidationLevel.ERROR, new OptionValue[0]),
    HDR_MAPPING_DISPLAY_CHROMAFORMAT_MISSING("mediaValidation.hdrmapping.display.chromaFormat.missing", "HDR mapping file is invalid", ValidationLevel.INFO, new OptionValue[0]),
    HDR_MAPPING_DISPLAY_CHROMAFORMAT_INVALID("mediaValidation.hdrmapping.display.chromaFormat.invalid", "HDR mapping file is invalid", ValidationLevel.SHADOW, new OptionValue[0]),
    HDR_MAPPING_DISPLAY_CHROMAFORMAT_NOTSUPPORTED("mediaValidation.hdrmapping.display.chromaFormat.notsupported", "HDR mapping file is invalid", ValidationLevel.ERROR, new OptionValue[0]),
    HDR_MAPPING_DISPLAY_CHROMAFORMAT_MISMATCH("mediaValidation.hdrmapping.display.chromaFormat.mismatch", "HDR mapping file is invalid", ValidationLevel.ERROR, new OptionValue[0]),
    HDR_MAPPING_DISPLAY_SIGNALRANGE_MISSING("mediaValidation.hdrmapping.display.signalRange.missing", "HDR mapping file is invalid", ValidationLevel.INFO, new OptionValue[0]),
    HDR_MAPPING_DISPLAY_SIGNALRANGE_INVALID("mediaValidation.hdrmapping.display.signalRange.invalid", "HDR mapping file is invalid", ValidationLevel.SHADOW, new OptionValue[0]),
    HDR_MAPPING_DISPLAY_SIGNALRANGE_NOTSUPPORTED("mediaValidation.hdrmapping.display.signalRange.notsupported", "HDR mapping file is invalid", ValidationLevel.ERROR, new OptionValue[0]),
    HDR_MAPPING_DISPLAY_SIGNALRANGE_MISMATCH("mediaValidation.hdrmapping.display.signalRange.mismatch", "HDR mapping file is invalid", ValidationLevel.ERROR, new OptionValue[0]),
    HDR_MAPPING_DISPLAY_ENCODING_MISSING("mediaValidation.hdrmapping.display.encoding.missing", "HDR mapping file is invalid", ValidationLevel.INFO, new OptionValue[0]),
    HDR_MAPPING_DISPLAY_ENCODING_INVALID("mediaValidation.hdrmapping.display.encoding.invalid", "HDR mapping file contains a target display with an invalid encoding value of \"${value}\"", ValidationLevel.SHADOW, new OptionValue[0]),
    HDR_MAPPING_DISPLAY_ENCODING_NOTSUPPORTED("mediaValidation.hdrmapping.display.encoding.notsupported", "HDR mapping file is invalid", ValidationLevel.ERROR, new OptionValue[0]),
    HDR_MAPPING_DISPLAY_ENCODING_MISMATCH("mediaValidation.hdrmapping.display.encoding.mismatch", "HDR mapping file is invalid", ValidationLevel.ERROR, new OptionValue[0]),
    HDR_MAPPING_DISPLAY_WHITEPOINT_MISSING("mediaValidation.hdrmapping.display.whitePoint.missing", "HDR mapping file is invalid", ValidationLevel.INFO, new OptionValue[0]),
    HDR_MAPPING_DISPLAY_WHITEPOINT_INVALID("mediaValidation.hdrmapping.display.whitePoint.invalid", "HDR mapping file contains a target display with an invalid white point value of \"${value}\"", ValidationLevel.SHADOW, new OptionValue[0]),
    HDR_MAPPING_DISPLAY_WHITEPOINT_NOTSUPPORTED("mediaValidation.hdrmapping.display.whitePoint.notsupported", "HDR mapping file is invalid", ValidationLevel.ERROR, new OptionValue[0]),
    HDR_MAPPING_DISPLAY_WHITEPOINT_MISMATCH("mediaValidation.hdrmapping.display.whitePoint.mismatch", "HDR mapping file is invalid", ValidationLevel.ERROR, new OptionValue[0]),
    HDR_MAPPING_DISPLAY_MINBRIGHTNESS_MISSING("mediaValidation.hdrmapping.display.brightness.min.missing", "HDR mapping file is invalid", ValidationLevel.INFO, new OptionValue[0]),
    HDR_MAPPING_DISPLAY_MINBRIGHTNESS_INVALID("mediaValidation.hdrmapping.display.brightness.min.invalid", "HDR mapping file contains a target display with an invalid minimum brightness value of \"${value}\"", ValidationLevel.SHADOW, new OptionValue[0]),
    HDR_MAPPING_DISPLAY_MINBRIGHTNESS_NOTSUPPORTED("mediaValidation.hdrmapping.display.brightness.min.notsupported", "HDR mapping file is invalid", ValidationLevel.ERROR, new OptionValue[0]),
    HDR_MAPPING_DISPLAY_MINBRIGHTNESS_MISMATCH("mediaValidation.hdrmapping.display.brightness.min.mismatch", "HDR mapping file is invalid", ValidationLevel.ERROR, new OptionValue[0]),
    HDR_MAPPING_DISPLAY_PEAKBRIGHTNESS_MISSING("mediaValidation.hdrmapping.display.brightness.peak.missing", "HDR mapping file is invalid", ValidationLevel.INFO, new OptionValue[0]),
    HDR_MAPPING_DISPLAY_PEAKBRIGHTNESS_INVALID("mediaValidation.hdrmapping.display.brightness.peak.invalid", "HDR mapping file contains a target display with an invalid peak brightness value of \"${value}\"", ValidationLevel.SHADOW, new OptionValue[0]),
    HDR_MAPPING_DISPLAY_PEAKBRIGHTNESS_NOTSUPPORTED("mediaValidation.hdrmapping.display.brightness.peak.notsupported", "HDR mapping file is invalid", ValidationLevel.ERROR, new OptionValue[0]),
    HDR_MAPPING_DISPLAY_PEAKBRIGHTNESS_MISMATCH("mediaValidation.hdrmapping.display.brightness.peak.mismatch", "HDR mapping file is invalid", ValidationLevel.ERROR, new OptionValue[0]),
    HDR_MAPPING_DISPLAY_GAMMA_INVALID("mediaValidation.hdrmapping.display.gamma.invalid", "HDR mapping file contains a target display with an invalid gamma value of \"${value}\"", ValidationLevel.ERROR, new OptionValue[0]),
    HDR_MAPPING_DISPLAY_GAMMA_NOTSUPPORTED("mediaValidation.hdrmapping.display.gamma.notsupported", "HDR mapping file is invalid", ValidationLevel.ERROR, new OptionValue[0]),
    HDR_MAPPING_DISPLAY_GAMMA_MISMATCH("mediaValidation.hdrmapping.display.brightness.gamma.mismatch", "HDR mapping file is invalid", ValidationLevel.ERROR, new OptionValue[0]),
    HDR_MAPPING_DISPLAY_RED_PRIMARY_MISSING("mediaValidation.hdrmapping.display.primary.red.missing", "HDR mapping file is invalid", ValidationLevel.SHADOW, new OptionValue[0]),
    HDR_MAPPING_DISPLAY_RED_PRIMARY_INVALID("mediaValidation.hdrmapping.display.primary.red.invalid", "HDR mapping file contains a target display with an invalid red primary \"${value}\"", ValidationLevel.SHADOW, new OptionValue[0]),
    HDR_MAPPING_DISPLAY_RED_PRIMARY_NOTSUPPORTED("mediaValidation.hdrmapping.display.primary.red.notsupported", "HDR mapping file is invalid", ValidationLevel.ERROR, new OptionValue[0]),
    HDR_MAPPING_DISPLAY_RED_PRIMARY_MISMATCH("mediaValidation.hdrmapping.display.primary.red.mismatch", "HDR mapping file is invalid", ValidationLevel.ERROR, new OptionValue[0]),
    HDR_MAPPING_DISPLAY_GREEN_PRIMARY_MISSING("mediaValidation.hdrmapping.display.primary.green.missing", "HDR mapping file is invalid", ValidationLevel.SHADOW, new OptionValue[0]),
    HDR_MAPPING_DISPLAY_GREEN_PRIMARY_INVALID("mediaValidation.hdrmapping.display.primary.green.invalid", "HDR mapping file contains a target display with an invalid green primary \"${value}\"", ValidationLevel.SHADOW, new OptionValue[0]),
    HDR_MAPPING_DISPLAY_GREEN_PRIMARY_NOTSUPPORTED("mediaValidation.hdrmapping.display.primary.green.notsupported", "HDR mapping file is invalid", ValidationLevel.ERROR, new OptionValue[0]),
    HDR_MAPPING_DISPLAY_GREEN_PRIMARY_MISMATCH("mediaValidation.hdrmapping.display.primary.green.mismatch", "HDR mapping file is invalid", ValidationLevel.ERROR, new OptionValue[0]),
    HDR_MAPPING_DISPLAY_BLUE_PRIMARY_MISSING("mediaValidation.hdrmapping.display.primary.blue.missing", "HDR mapping file is invalid", ValidationLevel.SHADOW, new OptionValue[0]),
    HDR_MAPPING_DISPLAY_BLUE_PRIMARY_INVALID("mediaValidation.hdrmapping.display.primary.blue.invalid", "HDR mapping file contains a target display with an invalid blue primary \"${value}\"", ValidationLevel.SHADOW, new OptionValue[0]),
    HDR_MAPPING_DISPLAY_BLUE_PRIMARY_NOTSUPPORTED("mediaValidation.hdrmapping.display.primary.blue.notsupported", "HDR mapping file is invalid", ValidationLevel.ERROR, new OptionValue[0]),
    HDR_MAPPING_DISPLAY_BLUE_PRIMARY_MISMATCH("mediaValidation.hdrmapping.display.primary.blue.mismatch", "HDR mapping file is invalid", ValidationLevel.ERROR, new OptionValue[0]),
    HDR_MAPPING_VIDEOTRACK_MISSING(7755, "mediaValidation.hdrmapping.track.video.missing", "HDR mapping file is invalid", ValidationLevel.ERROR, new OptionValue[0]),
    HDR_MAPPING_VIDEOTRACK_INVALID(7756, "mediaValidation.hdrmapping.track.video.invalid", "HDR mapping file is invalid", ValidationLevel.ERROR, new OptionValue[0]),
    HDR_MAPPING_VIDEOTRACK_NOTSUPPORTED(7757, "mediaValidation.hdrmapping.track.video.notsupported", "HDR mapping file is invalid", ValidationLevel.ERROR, new OptionValue[0]),
    HDR_MAPPING_VIDEO_DURATION_MISMATCH(7768, "mediaValidation.hdrmapping.track.video.duration.mismatch", "HDR mapping video track duration of ${actualValue} sec(s) does not conform to expected value of ${expectedValue} sec(s)", ValidationLevel.ERROR, new OptionValue[0]),
    HDR_MAPPING_NO_100NIT_TARGET("mediaValidation.hdrmapping.target.100.missing", "HDR mapping file is missing a display target with a 100 nit peak brightness value", ValidationLevel.SHADOW, new OptionValue[0]),
    HDR_MAPPING_NO_500NIT_TARGET("mediaValidation.hdrmapping.target.500.missing", "HDR mapping file is missing a display target with a 400-600 nit peak brightness value", ValidationLevel.SHADOW, new OptionValue[0]),
    HDR_MAPPING_NO_1000NIT_TARGET("mediaValidation.hdrmapping.target.1000.missing", "HDR mapping file is missing a display target with a 1000 nit peak brightness value", ValidationLevel.SHADOW, new OptionValue[0]),
    HDR_MAPPING_COLOR_ENCODING_BITDEPTH_MISSING("mediaValidation.hdrmapping.colorEncoding.bitDepth.missing", "HDR mapping file is invalid", ValidationLevel.INFO, new OptionValue[0]),
    HDR_MAPPING_COLOR_ENCODING_BITDEPTH_INVALID("mediaValidation.hdrmapping.colorEncoding.bitDepth.invalid", "HDR mapping file is invalid", ValidationLevel.SHADOW, new OptionValue[0]),
    HDR_MAPPING_COLOR_ENCODING_BITDEPTH_NOTSUPPORTED("mediaValidation.hdrmapping.colorEncoding.bitDepth.notsupported", "HDR mapping file is invalid", ValidationLevel.SHADOW, new OptionValue[0]),
    HDR_MAPPING_COLOR_ENCODING_COLORSPACE_MISSING("mediaValidation.hdrmapping.colorEncoding.colorSpace.missing", "HDR mapping file is invalid", ValidationLevel.INFO, new OptionValue[0]),
    HDR_MAPPING_COLOR_ENCODING_COLORSPACE_INVALID("mediaValidation.hdrmapping.colorEncoding.colorSpace.invalid", "HDR mapping file is invalid", ValidationLevel.SHADOW, new OptionValue[0]),
    HDR_MAPPING_COLOR_ENCODING_COLORSPACE_NOTSUPPORTED("mediaValidation.hdrmapping.colorEncoding.colorSpace.notsupported", "HDR mapping file is invalid", ValidationLevel.ERROR, new OptionValue[0]),
    HDR_MAPPING_COLOR_ENCODING_COLORSPACE_MISMATCH("mediaValidation.hdrmapping.colorEncoding.colorSpace.mismatch", "HDR mapping file is invalid", ValidationLevel.ERROR, new OptionValue[0]),
    HDR_MAPPING_COLOR_ENCODING_CHROMAFORMAT_MISSING("mediaValidation.hdrmapping.colorEncoding.chromaFormat.missing", "HDR mapping file is invalid", ValidationLevel.INFO, new OptionValue[0]),
    HDR_MAPPING_COLOR_ENCODING_CHROMAFORMAT_INVALID("mediaValidation.hdrmapping.colorEncoding.chromaFormat.invalid", "HDR mapping file is invalid", ValidationLevel.SHADOW, new OptionValue[0]),
    HDR_MAPPING_COLOR_ENCODING_CHROMAFORMAT_NOTSUPPORTED("mediaValidation.hdrmapping.colorEncoding.chromaFormat.notsupported", "HDR mapping file is invalid", ValidationLevel.ERROR, new OptionValue[0]),
    HDR_MAPPING_COLOR_ENCODING_CHROMAFORMAT_MISMATCH("mediaValidation.hdrmapping.colorEncoding.chromaFormat.mismatch", "HDR mapping file is invalid", ValidationLevel.ERROR, new OptionValue[0]),
    HDR_MAPPING_COLOR_ENCODING_SIGNALRANGE_MISSING("mediaValidation.hdrmapping.colorEncoding.signalRange.missing", "HDR mapping file is invalid", ValidationLevel.INFO, new OptionValue[0]),
    HDR_MAPPING_COLOR_ENCODING_SIGNALRANGE_INVALID("mediaValidation.hdrmapping.colorEncoding.signalRange.invalid", "HDR mapping file is invalid", ValidationLevel.SHADOW, new OptionValue[0]),
    HDR_MAPPING_COLOR_ENCODING_SIGNALRANGE_NOTSUPPORTED("mediaValidation.hdrmapping.colorEncoding.signalRange.notsupported", "HDR mapping file is invalid", ValidationLevel.ERROR, new OptionValue[0]),
    HDR_MAPPING_COLOR_ENCODING_SIGNALRANGE_MISMATCH("mediaValidation.hdrmapping.colorEncoding.signalRange.mismatch", "HDR mapping file is invalid", ValidationLevel.ERROR, new OptionValue[0]),
    HDR_MAPPING_COLOR_ENCODING_ENCODING_MISSING("mediaValidation.hdrmapping.colorEncoding.encoding.missing", "HDR mapping file is invalid", ValidationLevel.INFO, new OptionValue[0]),
    HDR_MAPPING_COLOR_ENCODING_ENCODING_INVALID("mediaValidation.hdrmapping.colorEncoding.encoding.invalid", "HDR mapping file contains a target display with an invalid encoding value of \"${value}\"", ValidationLevel.SHADOW, new OptionValue[0]),
    HDR_MAPPING_COLOR_ENCODING_ENCODING_NOTSUPPORTED("mediaValidation.hdrmapping.colorEncoding.encoding.notsupported", "HDR mapping file is invalid", ValidationLevel.ERROR, new OptionValue[0]),
    HDR_MAPPING_COLOR_ENCODING_ENCODING_MISMATCH("mediaValidation.hdrmapping.colorEncoding.encoding.mismatch", "HDR mapping file is invalid", ValidationLevel.ERROR, new OptionValue[0]),
    HDR_MAPPING_COLOR_ENCODING_WHITEPOINT_MISSING("mediaValidation.hdrmapping.colorEncoding.whitePoint.missing", "HDR mapping file is invalid", ValidationLevel.INFO, new OptionValue[0]),
    HDR_MAPPING_COLOR_ENCODING_WHITEPOINT_INVALID("mediaValidation.hdrmapping.colorEncoding.whitePoint.invalid", "HDR mapping file contains a target display with an invalid white point value of \"${value}\"", ValidationLevel.SHADOW, new OptionValue[0]),
    HDR_MAPPING_COLOR_ENCODING_WHITEPOINT_NOTSUPPORTED("mediaValidation.hdrmapping.colorEncoding.whitePoint.notsupported", "HDR mapping file is invalid", ValidationLevel.ERROR, new OptionValue[0]),
    HDR_MAPPING_COLOR_ENCODING_WHITEPOINT_MISMATCH("mediaValidation.hdrmapping.colorEncoding.whitePoint.mismatch", "HDR mapping file is invalid", ValidationLevel.ERROR, new OptionValue[0]),
    HDR_MAPPING_COLOR_ENCODING_MINBRIGHTNESS_MISSING("mediaValidation.hdrmapping.colorEncoding.brightness.min.missing", "HDR mapping file is invalid", ValidationLevel.INFO, new OptionValue[0]),
    HDR_MAPPING_COLOR_ENCODING_MINBRIGHTNESS_INVALID("mediaValidation.hdrmapping.colorEncoding.brightness.min.invalid", "HDR mapping file contains a target display with an invalid minimum brightness value of \"${value}\"", ValidationLevel.SHADOW, new OptionValue[0]),
    HDR_MAPPING_COLOR_ENCODING_MINBRIGHTNESS_NOTSUPPORTED("mediaValidation.hdrmapping.colorEncoding.brightness.min.notsupported", "HDR mapping file is invalid", ValidationLevel.ERROR, new OptionValue[0]),
    HDR_MAPPING_COLOR_ENCODING_MINBRIGHTNESS_MISMATCH("mediaValidation.hdrmapping.colorEncoding.brightness.min.mismatch", "HDR mapping file is invalid", ValidationLevel.ERROR, new OptionValue[0]),
    HDR_MAPPING_COLOR_ENCODING_PEAKBRIGHTNESS_MISSING("mediaValidation.hdrmapping.colorEncoding.brightness.peak.missing", "HDR mapping file is invalid", ValidationLevel.INFO, new OptionValue[0]),
    HDR_MAPPING_COLOR_ENCODING_PEAKBRIGHTNESS_INVALID("mediaValidation.hdrmapping.colorEncoding.brightness.peak.invalid", "HDR mapping file contains a target display with an invalid peak brightness value of \"${value}\"", ValidationLevel.SHADOW, new OptionValue[0]),
    HDR_MAPPING_COLOR_ENCODING_PEAKBRIGHTNESS_NOTSUPPORTED("mediaValidation.hdrmapping.colorEncoding.brightness.peak.notsupported", "HDR mapping file is invalid", ValidationLevel.ERROR, new OptionValue[0]),
    HDR_MAPPING_COLOR_ENCODING_PEAKBRIGHTNESS_MISMATCH("mediaValidation.hdrmapping.colorEncoding.brightness.peak.mismatch", "HDR mapping file is invalid", ValidationLevel.ERROR, new OptionValue[0]),
    HDR_MAPPING_COLOR_ENCODING_GAMMA_INVALID("mediaValidation.hdrmapping.colorEncoding.gamma.invalid", "HDR mapping file contains a target display with an invalid gamma value of \"${value}\"", ValidationLevel.ERROR, new OptionValue[0]),
    HDR_MAPPING_COLOR_ENCODING_GAMMA_NOTSUPPORTED("mediaValidation.hdrmapping.colorEncoding.gamma.notsupported", "HDR mapping file is invalid", ValidationLevel.ERROR, new OptionValue[0]),
    HDR_MAPPING_COLOR_ENCODING_GAMMA_MISMATCH("mediaValidation.hdrmapping.colorEncoding.brightness.gamma.mismatch", "HDR mapping file is invalid", ValidationLevel.ERROR, new OptionValue[0]),
    HDR_MAPPING_COLOR_ENCODING_RED_PRIMARY_MISSING("mediaValidation.hdrmapping.colorEncoding.primary.red.missing", "HDR mapping file is invalid", ValidationLevel.SHADOW, new OptionValue[0]),
    HDR_MAPPING_COLOR_ENCODING_RED_PRIMARY_INVALID("mediaValidation.hdrmapping.colorEncoding.primary.red.invalid", "HDR mapping file contains a target display with an invalid red primary \"${value}\"", ValidationLevel.SHADOW, new OptionValue[0]),
    HDR_MAPPING_COLOR_ENCODING_RED_PRIMARY_NOTSUPPORTED("mediaValidation.hdrmapping.colorEncoding.primary.red.notsupported", "HDR mapping file is invalid", ValidationLevel.ERROR, new OptionValue[0]),
    HDR_MAPPING_COLOR_ENCODING_RED_PRIMARY_MISMATCH("mediaValidation.hdrmapping.colorEncoding.primary.red.mismatch", "HDR mapping file is invalid", ValidationLevel.ERROR, new OptionValue[0]),
    HDR_MAPPING_COLOR_ENCODING_GREEN_PRIMARY_MISSING("mediaValidation.hdrmapping.colorEncoding.primary.green.missing", "HDR mapping file is invalid", ValidationLevel.SHADOW, new OptionValue[0]),
    HDR_MAPPING_COLOR_ENCODING_GREEN_PRIMARY_INVALID("mediaValidation.hdrmapping.colorEncoding.primary.green.invalid", "HDR mapping file contains a target display with an invalid green primary \"${value}\"", ValidationLevel.SHADOW, new OptionValue[0]),
    HDR_MAPPING_COLOR_ENCODING_GREEN_PRIMARY_NOTSUPPORTED("mediaValidation.hdrmapping.colorEncoding.primary.green.notsupported", "HDR mapping file is invalid", ValidationLevel.ERROR, new OptionValue[0]),
    HDR_MAPPING_COLOR_ENCODING_GREEN_PRIMARY_MISMATCH("mediaValidation.hdrmapping.colorEncoding.primary.green.mismatch", "HDR mapping file is invalid", ValidationLevel.ERROR, new OptionValue[0]),
    HDR_MAPPING_COLOR_ENCODING_BLUE_PRIMARY_MISSING("mediaValidation.hdrmapping.colorEncoding.primary.blue.missing", "HDR mapping file is invalid", ValidationLevel.SHADOW, new OptionValue[0]),
    HDR_MAPPING_COLOR_ENCODING_BLUE_PRIMARY_INVALID("mediaValidation.hdrmapping.colorEncoding.primary.blue.invalid", "HDR mapping file contains a target display with an invalid blue primary \"${value}\"", ValidationLevel.SHADOW, new OptionValue[0]),
    HDR_MAPPING_COLOR_ENCODING_BLUE_PRIMARY_NOTSUPPORTED("mediaValidation.hdrmapping.colorEncoding.primary.blue.notsupported", "HDR mapping file is invalid", ValidationLevel.ERROR, new OptionValue[0]),
    HDR_MAPPING_COLOR_ENCODING_BLUE_PRIMARY_MISMATCH("mediaValidation.hdrmapping.colorEncoding.primary.blue.mismatch", "HDR mapping file is invalid", ValidationLevel.ERROR, new OptionValue[0]),
    HDR_HDR10_METADATA_MISSING("mediaValidation.hdr10.metadata.missing", "For HDR10 sources, HDR10 metadata should be supplied. Please correct and resubmit.", ValidationLevel.ERROR, new OptionValue[0]),
    HDR_HDR10_METADATA_DISPLAY_RED_PRIMARY_MISSING("mediaValidation.hdr10.metadata.display.primary.red.missing", "HDR10 metadata should include specification of the red primary for the mastering display. Please correct and resubmit.", ValidationLevel.ERROR, new OptionValue[0]),
    HDR_HDR10_METADATA_DISPLAY_RED_PRIMARY_INVALID("mediaValidation.hdr10.metadata.display.primary.red.invalid", "HDR10 metadata red primary value (\"${value}\") is invalid: it should be either (0.6800, 0.3200) for P3 D65 source or (0.7080, 0.2920) for BT.2020 D65 source.", ValidationLevel.ERROR, new OptionValue[0]),
    HDR_HDR10_METADATA_DISPLAY_GREEN_PRIMARY_MISSING("mediaValidation.hdr10.metadata.display.primary.green.missing", "HDR10 metadata should include specification of the green primary for the mastering display. Please correct and resubmit.", ValidationLevel.SHADOW, new OptionValue[0]),
    HDR_HDR10_METADATA_DISPLAY_GREEN_PRIMARY_INVALID("mediaValidation.hdr10.metadata.display.primary.green.invalid", "HDR10 metadata green primary value (\"${value}\") is invalid: it should be either (0.2650, 0.6900) for P3 D65 source or (0.1700, 0.7970) for BT.2020 D65 source.", ValidationLevel.ERROR, new OptionValue[0]),
    HDR_HDR10_METADATA_DISPLAY_BLUE_PRIMARY_MISSING("mediaValidation.hdr10.metadata.display.primary.blue.missing", "HDR10 metadata should include specification of the blue primary for the mastering display. Please correct and resubmit.", ValidationLevel.ERROR, new OptionValue[0]),
    HDR_HDR10_METADATA_DISPLAY_BLUE_PRIMARY_INVALID("mediaValidation.hdr10.metadata.display.primary.blue.invalid", "HDR10 metadata blue primary value (\"${value}\") is invalid: it should be either (0.1500, 0.0600) for P3 D65 source or (0.1310, 0.0460) for BT.2020 D65 source.", ValidationLevel.ERROR, new OptionValue[0]),
    HDR_HDR10_METADATA_DISPLAY_WHITEPOINT_MISSING("mediaValidation.hdr10.metadata.whitepoint.missing", "HDR10 metadata should include specification of the whitePoint for the mastering display. Please correct and resubmit.", ValidationLevel.ERROR, new OptionValue[0]),
    HDR_HDR10_METADATA_DISPLAY_WHITEPOINT_INVALID("mediaValidation.hdr10.metadata.whitepoint.invalid", "HDR10 metadata blue primary value (\"${value}\") is invalid: it should be (0.3127, 0.3290) for P3 D65 or BT.2020 D65 source.", ValidationLevel.ERROR, new OptionValue[0]),
    HDR_HDR10_METADATA_DISPLAY_MAX_LUMINANCE_MISSING("mediaValidation.hdr10.metadata.max.luminance.missing", "HDR10 metadata should include specification of the max luminance for the mastering display. Please correct and resubmit.", ValidationLevel.ERROR, new OptionValue[0]),
    HDR_HDR10_METADATA_DISPLAY_MAX_LUMINANCE_INVALID("mediaValidation.hdr10.metadata.max.luminance.invalid", "HDR10 metadata mastering display max luminance \"${value}\" is invalid: it should be greater than or equal to 0.0.", ValidationLevel.ERROR, new OptionValue[0]),
    HDR_HDR10_METADATA_DISPLAY_MIN_LUMINANCE_MISSING("mediaValidation.hdr10.metadata.min.display.luminance.missing", "HDR10 metadata should include specification of the min luminance for the mastering display. Please correct and resubmit.", ValidationLevel.ERROR, new OptionValue[0]),
    HDR_HDR10_METADATA_DISPLAY_MIN_LUMINANCE_INVALID("mediaValidation.hdr10.metadata.min.display.luminance.invalid", "HDR10 metadata mastering display min luminance \"${value}\" is invalid: it should be greater than or equal to 0.0.", ValidationLevel.ERROR, new OptionValue[0]),
    HDR_HDR10_METADATA_CONTENT_MAX_LIGHT_LEVEL_MISSING("mediaValidation.hdr10.metadata.max.content.lightlevel.missing", "HDR10 metadata should include specification of the max content lightLevel for the mastering display. Please correct and resubmit.", ValidationLevel.ERROR, new OptionValue[0]),
    HDR_HDR10_METADATA_CONTENT_MAX_LIGHT_LEVEL_INVALID("mediaValidation.hdr10.metadata.max.content.lightlevel.invalid", "HDR10 metadata mastering display max content lightLevel \"${value}\" is invalid: valid range is 0 .. 65535.", ValidationLevel.ERROR, new OptionValue[0]),
    HDR_HDR10_METADATA_CONTENT_FRAME_AVG_LIGHT_LEVEL_MISSING("mediaValidation.hdr10.metadata.max.frameavg.lightlevel.missing", "HDR10 metadata should include specification of the max frame average lightLevel for the mastering display. Please correct and resubmit.", ValidationLevel.ERROR, new OptionValue[0]),
    HDR_HDR10_METADATA_CONTENT_FRAME_AVG_LIGHT_LEVEL_INVALID("mediaValidation.hdr10.metadata.max.frameavg.lightlevel.invalid", "HDR10 metadata mastering display max frame average lightLevel \"${value}\" is invalid: valid range is 0 .. 65535.", ValidationLevel.ERROR, new OptionValue[0]),
    CAFF_MAGIC_MISSING("mediaValidation.caff.magic.missing", "File does not begin with 'caff' magic bytes", ValidationLevel.ERROR, new OptionValue[0]),
    CAFF_CHUNKS_MISSING("mediaValidation.caff.chunks.missing", "There are no chunks in the file", ValidationLevel.ERROR, new OptionValue[0]),
    CAFF_DESCRIPTION_MISSING("mediaValidation.caff.description.missing", "Description chunk must be the first chunk or is missing", ValidationLevel.ERROR, new OptionValue[0]),
    CAFF_DATA_MISSING("mediaValidation.caff.data.missing", "Data chunk is missing", ValidationLevel.ERROR, new OptionValue[0]),
    CAFF_PACKET_TABLE_MISSING("mediaValidation.caff.packetTable.missing", "Packet table missing. It is needed for compressed formats", ValidationLevel.ERROR, new OptionValue[0]),
    CAFF_CHUNK_SIZE_INVALID("mediaValidation.caff.chunkSize.invalid", "Invalid chunk ${name} size ${size} ", ValidationLevel.ERROR, new OptionValue[0]),
    CAFF_CHUNK_TOOLARGE_INVALID("mediaValidation.caff.chunkTooLarge.invalid", "Chunk ${name} extends beyond the end of the file. Needs ${needed} but there are only ${available} bytes ", ValidationLevel.ERROR, new OptionValue[0]),
    CAFF_CHUNK_TOOSMALL_INVALID("mediaValidation.caff.chunkTooSmall.invalid", "Not enough bytes to read chunk. Needs 12 bytes but there are only ${available} bytes at offset ${offset}", ValidationLevel.WARNING, new OptionValue[0]),
    BWF_MAGIC_MISSING("mediaValidation.bwf.magic.missing", "File does not begin with 'RF64' or 'RIFF' magic bytes", ValidationLevel.ERROR, new OptionValue[0]),
    BWF_CHUNKS_MISSING("mediaValidation.bwf.chunks.missing", "There are no chunks in the file", ValidationLevel.ERROR, new OptionValue[0]),
    BWF_DS64CHUNK_LOCATION_INVALID("mediaValidation.bwf.DS64chunklocation.invalid", "Need to see DataSize64Chunk before 'data' if its size is -1", ValidationLevel.ERROR, new OptionValue[0]),
    BWF_DS64CHUNK_MISSING("mediaValidation.bwf.DS64chunk.missing", "Riff size is -1 but there is no DataSize64Chunk", ValidationLevel.ERROR, new OptionValue[0]),
    BWF_FORMAT_MISSING("mediaValidation.bwf.format.missing", "Format chunk is missing", ValidationLevel.ERROR, new OptionValue[0]),
    BWF_DATA_MISSING("mediaValidation.bwf.data.missing", "Data chunk missing", ValidationLevel.ERROR, new OptionValue[0]),
    UHD_SOURCE_NOT_PROGRESSIVE("mediaValidation.uhdSource.progressive.mismatch", "UDH/4K source should be progressive. Please correct and resubmit.", ValidationLevel.ERROR, new OptionValue[0]),
    ADM_ID_INVALID("mediaValidation.adm.id.invalid", "Invalid id for ${kind}:${id}", ValidationLevel.WARNING, new OptionValue[0]),
    ADM_ID_MISSING("mediaValidation.adm.id.missing", "Invalid id for ${name}", ValidationLevel.ERROR, new OptionValue[0]),
    ADM_NAME_MISSING("mediaValidation.adm.name.missing", "Invalid id for ${id}", ValidationLevel.ERROR, new OptionValue[0]),
    ADM_TYPEDEFINITION_INVALID("mediaValidation.adm.typedefinition.invalid", "Invalid typedefinition for ${id}:${typedef}", ValidationLevel.WARNING, new OptionValue[0]),
    ADM_TYPELABEL_INVALID("mediaValidation.adm.typelabel.invalid", "Invalid typelabel for ${id}:${typelabel}", ValidationLevel.WARNING, new OptionValue[0]),
    ADM_TYPEDEFINITION_MISSING("mediaValidation.adm.typedefinition.missing", "Invalid typedefinition for ${id}", ValidationLevel.ERROR, new OptionValue[0]),
    ADM_TYPELABEL_MISSING("mediaValidation.adm.typelabel.missing", "Invalid typelabel for ${id}", ValidationLevel.ERROR, new OptionValue[0]),
    ADM_TYPEDEFINITION_MISSMATCH("mediaValidation.adm.typedefandlabel.mismatch", "Mismatch between typedefinition and typelabel for ${id}:${typedef},${typelabel}", ValidationLevel.WARNING, new OptionValue[0]),
    ADM_TYPELABEL_MISMATCH("mediaValidation.adm.typelabel.mismatch", "Mismatch between typelabel and object id for ${id}:${typelabel}", ValidationLevel.WARNING, new OptionValue[0]),
    LYRICS_SCHEMA_INVALID("mediaValidation.lyrics.schema.invalid", "The lyrics document fails schema validation at line: ${linelocation} with error: ${schemaerror}", ValidationLevel.ERROR, new OptionValue[0]),
    LYRICS_TIMECODE_INVALID("mediaValidation.lyrics.timecode.invalid", "In lyrics file, the timecode ${timecode} is invalid", ValidationLevel.ERROR, new OptionValue[0]),
    LYRICS_TIMECODE_INVALID_AFTER("mediaValidation.lyrics.schema.invalid.shouldBeAfter", "In lyrics file, the timcode ${timecode} should be after the timecode ${timecodebegin}", ValidationLevel.ERROR, new OptionValue[0]),
    LYRICS_TIMECODE_INVALID_BEFORE("mediaValidation.lyrics.schema.invalid.shouldBeBefore", "In lyrics file, the timcode ${timecode} should be before the timecode ${timecodeend}", ValidationLevel.ERROR, new OptionValue[0]),
    LYRICS_DURATION_BEYOND_DURATION_SONG("mediaValidation.lyrics.duration.beyondDurationOfSong", "The lyrics duration ${timecode} is beyond the duration of song", ValidationLevel.ERROR, new OptionValue[0]),
    LYRICS_TIMECODE_BEYOND_DURATION_SONG("mediaValidation.lyrics.timecode.beyondDurationOfSong", "The lyrics timecode ${timecode} is beyond the duration of song", ValidationLevel.ERROR, new OptionValue[0]),
    LYRICS_AGENT_MORE_THAN_ONE_LEVEL("mediaValidation.lyrics.agent.definedInMoreThanOneLevel", "The agent attribute can be specified in only one level", ValidationLevel.ERROR, new OptionValue[0]),
    LYRICS_AGENT_OVERLAP_TIME("mediaValidation.lyrics.agent.overlapTime", "The agent ${agentid} is specified in lyrics elements that overlap in time", ValidationLevel.ERROR, new OptionValue[0]);

    @Nonnull
    public static final String MISSING = ".missing";
    @Nonnull
    public static final String INVALID = ".invalid";
    @Nonnull
    public static final String MISMATCH = ".mismatch";
    @Nonnull
    public static final String NOTSUPPORTED = ".notsupported";
    @Nonnull
    private final ValidationLevel defaultLevel;
    private final int errorNumber;
    @Nonnull
    private final DottedString validationCode;
    @Nonnull
    private final String defaultMessage;
    @Nullable
    private final String providerMessage;
    @Nonnull
    private final String propertyName;
    @Nonnull
    private final EnumMap<Option, Object> options;
    @Nonnull
    private static final Map<String, MediaValidationCode> codeLookup;
    @Nonnull
    private static final Map<Integer, MediaValidationCode> numberLookup;
    @Nonnull
    private static final Map<String, MediaValidationCode> conformaceNameLookup;

    private MediaValidationCode(int errorNumber, OptionValue ... options) {
        this.errorNumber = errorNumber;
        this.validationCode = DottedString.valueOf("mediaValidation." + this.name().toLowerCase());
        this.defaultLevel = ValidationLevel.ERROR;
        this.defaultMessage = this.name();
        this.providerMessage = null;
        this.propertyName = "com.apple.jingle.contentbusinesslogic.media.SourceFilesIntentValidator." + this.name();
        this.options = MediaValidationCode.toOptionMap(options);
        if (!this.options.containsKey((Object)Option.messageTemplateKeys)) {
            this.options.put(Option.messageTemplateKeys, this.getKeys());
        }
    }

    private MediaValidationCode(@Nonnull String validationCode, String defaultMessage, ValidationLevel defaultLevel, OptionValue ... options) {
        this(0, validationCode, defaultMessage, (String)null, defaultLevel, options);
    }

    private MediaValidationCode(@Nonnull int errorNumber, @Nonnull String validationCode, String defaultMessage, ValidationLevel defaultLevel, OptionValue ... options) {
        this(errorNumber, validationCode, defaultMessage, (String)null, defaultLevel, options);
    }

    private MediaValidationCode(@Nullable String validationCode, @Nonnull String defaultMessage, String providerMessage, ValidationLevel defaultLevel, OptionValue ... options) {
        this(0, validationCode, defaultMessage, providerMessage, defaultLevel, options);
    }

    private MediaValidationCode(@Nonnull int errorNumber, @Nullable String validationCode, @Nonnull String defaultMessage, String providerMessage, ValidationLevel defaultLevel, OptionValue ... options) {
        if (0 == errorNumber) {
            errorNumber = 10000 + this.ordinal();
        }
        this.errorNumber = errorNumber;
        this.validationCode = DottedString.valueOf(validationCode);
        this.defaultLevel = defaultLevel;
        this.defaultMessage = defaultMessage;
        this.providerMessage = providerMessage;
        this.propertyName = this.validationCode.getLongName();
        this.options = MediaValidationCode.toOptionMap(options);
        if (!this.options.containsKey((Object)Option.messageTemplateKeys)) {
            this.options.put(Option.messageTemplateKeys, this.getKeys());
        }
    }

    private MediaValidationCode(@Nonnull int errorNumber, @Nonnull String validationCode, @Nullable String propertyName, @Nonnull String defaultMessage, String providerMessage, ValidationLevel defaultLevel, OptionValue ... options) {
        this.errorNumber = errorNumber;
        this.validationCode = DottedString.valueOf(validationCode);
        this.defaultLevel = defaultLevel;
        this.defaultMessage = defaultMessage;
        this.providerMessage = providerMessage;
        this.propertyName = propertyName;
        this.options = MediaValidationCode.toOptionMap(options);
        if (!this.options.containsKey((Object)Option.messageTemplateKeys)) {
            this.options.put(Option.messageTemplateKeys, this.getKeys());
        }
    }

    private static final EnumMap<Option, Object> toOptionMap(@Nonnull OptionValue[] values) {
        EnumMap<Option, Object> options = new EnumMap<Option, Object>(Option.class);
        for (OptionValue v : values) {
            options.put(v.option, v.value);
        }
        return options;
    }

    @Nullable
    public <T> T getOption(@Nonnull Option option, @Nonnull Class<T> type) {
        return type.cast(this.options.get((Object)option));
    }

    public boolean hasOption(@Nonnull Option option) {
        return this.options.containsKey((Object)option);
    }

    @Nonnull
    public String getBaseCode() {
        DottedString value = this.validationCode.getParent();
        if (null == value) {
            throw new IllegalStateException();
        }
        return value.getLongName();
    }

    @Override
    public ValidationLevel getDefaultMediaNotificationLevel() {
        return this.defaultLevel;
    }

    @Nonnull
    public ValidationLevel getDefaultLevel() {
        return this.defaultLevel;
    }

    @Override
    public int toIntegerCode() {
        return this.errorNumber;
    }

    public int getCodeNumber() {
        return this.errorNumber;
    }

    @Override
    public String toStringCode() {
        return this.validationCode.getLongName();
    }

    public String getValidationCode() {
        return this.validationCode.getLongName();
    }

    public String getDefaultMessage() {
        return this.defaultMessage;
    }

    @Override
    public String getDefaultMessageTemplate() {
        return this.defaultMessage;
    }

    public String getProviderMessageTemplate() {
        return this.providerMessage;
    }

    @Override
    @Nonnull
    public String getPropertyKey() {
        return this.propertyName;
    }

    public boolean isArbitraryFileError() {
        return this.errorNumber < 100;
    }

    public boolean isImageError() {
        return this.errorNumber >= 100 && this.errorNumber < 200;
    }

    public boolean isVideoError() {
        return this.errorNumber >= 200 && this.errorNumber < 2000;
    }

    public boolean isSubtitleError() {
        return this.errorNumber >= 2000 && this.errorNumber < 3000;
    }

    public boolean isDubCardError() {
        return this.errorNumber >= 3000 && this.errorNumber < 4000;
    }

    public boolean isClosedCaptionError() {
        return this.errorNumber >= 4000 && this.errorNumber < 5000;
    }

    public boolean isAudioError() {
        return this.errorNumber >= 32768;
    }

    @Nullable
    public static MediaValidationCode forCodeNumber(int codeNumber) {
        return numberLookup.get(codeNumber);
    }

    @Nullable
    public static String convertErrorCodesToString(@Nonnull Collection<MediaValidationCode> errorCodes) {
        return CollectionUtils.isNotEmpty(errorCodes) ? Joiner.on((char)',').join(errorCodes) : null;
    }

    @Nonnull
    public static List<MediaValidationCode> convertStringToErrorCodes(@Nullable String codesString) {
        List<MediaValidationCode> codes;
        if (codesString != null && codesString.length() > 0) {
            String[] parts = codesString.split(",");
            codes = new ArrayList<MediaValidationCode>(parts.length);
            for (String part : parts) {
                MediaValidationCode code = MediaValidationCode.valueOf(part.trim().toUpperCase(Locale.US));
                codes.add(code);
            }
        } else {
            codes = Collections.emptyList();
        }
        return codes;
    }

    @Nullable
    public static MediaValidationCode valueOfStringCode(@Nullable String codeString) {
        if (null != codeString) {
            return codeLookup.get(codeString);
        }
        return null;
    }

    @Nonnull
    public static MediaValidationCode valueOfStringCode(@Nullable String codeString, @Nonnull MediaValidationCode defaultValue) {
        MediaValidationCode code = MediaValidationCode.valueOfStringCode(codeString);
        if (null != code) {
            return code;
        }
        return defaultValue;
    }

    @Nullable
    public static MediaValidationCode valueOfStringCodeWithPrefix(@Nullable String baseCode, @Nullable String specificCode) {
        if (null != baseCode && null != specificCode) {
            return codeLookup.get(baseCode + specificCode);
        }
        return null;
    }

    @Nullable
    public static MediaValidationCode valueOfConformanceProfile(@Nullable String conformanceProfileName) {
        if (null != conformanceProfileName) {
            return conformaceNameLookup.get(conformanceProfileName);
        }
        return null;
    }

    @Nullable
    public static MediaValidationCode valueOfIntegerCode(int errorNumber) {
        return numberLookup.get(errorNumber);
    }

    @Nullable
    public static MediaValidationCode valueOfIntegerCode(int errorNumber, @Nonnull MediaValidationCode defaultValue) {
        MediaValidationCode value = MediaValidationCode.valueOfIntegerCode(errorNumber);
        if (null != value) {
            return value;
        }
        return defaultValue;
    }

    @Nonnull
    private Set<String> getKeys() {
        int startNextToken;
        TreeSet<String> keys = new TreeSet<String>();
        int cursor = 0;
        while ((startNextToken = this.defaultMessage.indexOf("${", cursor)) != -1) {
            int endNextToken = this.defaultMessage.indexOf(125, startNextToken + 2);
            if (endNextToken != -1) {
                cursor = endNextToken + 1;
                keys.add(this.defaultMessage.substring(startNextToken + 2, endNextToken));
                continue;
            }
            throw new IllegalArgumentException("Invalid tokenziation starting at: " + this.name() + ": " + this.defaultMessage.substring(startNextToken));
        }
        return keys;
    }

    public static void main(String[] parms) {
        for (MediaValidationCode code : MediaValidationCode.values()) {
            System.out.println(code.name() + ": " + code.getOption(Option.messageTemplateKeys, Set.class));
        }
    }

    static {
        codeLookup = new HashMap<String, MediaValidationCode>();
        numberLookup = new HashMap<Integer, MediaValidationCode>();
        conformaceNameLookup = new HashMap<String, MediaValidationCode>();
        for (MediaValidationCode code : MediaValidationCode.values()) {
            codeLookup.put(code.getValidationCode(), code);
            codeLookup.put(Integer.toString(code.getCodeNumber()), code);
            numberLookup.put(code.getCodeNumber(), code);
            Collection conformanceNames = code.getOption(Option.conformanceNames, Collection.class);
            if (null == conformanceNames) continue;
            for (String cname : conformanceNames) {
                conformaceNameLookup.put(cname, code);
            }
        }
    }

    public static enum Option {
        grandfatherable,
        conformanceNames,
        messageTemplateKeys;

    }

    private static class OptionValue {
        @Nonnull
        public final Option option;
        @Nonnull
        public final Object value;

        OptionValue(@Nonnull Option option) {
            this(option, Boolean.TRUE);
        }

        OptionValue(@Nonnull Option option, @Nonnull Object value) {
            this.option = option;
            this.value = value;
        }
    }
}

