/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.media;

import com.apple.jingle.leghorn.media.MediaValidationCode;
import com.apple.jingle.leghorn.media.file.MediaFileContext;
import com.apple.jingle.leghorn.media.index.ValueSetFilter;
import com.apple.jingle.leghorn.media.validator.SimpleDictionary;
import com.apple.jingle.locale.BCP47Tag;
import com.apple.jingle.locale.BCP47TagParseException;
import com.apple.jingle.locale.BCP47TagSupport;
import com.apple.jingle.locale.ISO639_2Code;
import com.apple.jingle.locale.LocaleCode;
import com.google.common.base.Function;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class MediaUtil {
    @Nonnull
    public static final SimpleDictionary dictionary = SimpleDictionary.EmptyMap.singleton;
    private static final Comparator<Comparable<Object>> NULL_SAFE_COMPARATOR = new Comparator<Comparable<Object>>(){

        @Override
        public int compare(@Nullable Comparable<Object> c1, Comparable<Object> c2) {
            if (c1 == c2) {
                return 0;
            }
            if (c1 == null) {
                return -1;
            }
            if (c2 == null) {
                return 1;
            }
            return c1.compareTo(c2);
        }
    };
    private static final Comparator<Collection<Comparable<Object>>> COLLECTION_VALUE_COMPARATOR = new Comparator<Collection<Comparable<Object>>>(){

        @Override
        public int compare(@Nullable Collection<Comparable<Object>> o1, @Nullable Collection<Comparable<Object>> o2) {
            if (o1 == o2) {
                return 0;
            }
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            Iterator<Comparable<Object>> c1 = o1.iterator();
            Iterator<Comparable<Object>> c2 = o2.iterator();
            while (c1.hasNext()) {
                if (c2.hasNext()) {
                    int diff = c1.next().compareTo(c2.next());
                    if (diff == 0) continue;
                    return diff;
                }
                return -1;
            }
            if (c2.hasNext()) {
                return 1;
            }
            return 0;
        }
    };

    private MediaUtil() {
    }

    @Nullable
    public static final LocaleCode parseLocaleCode(@Nonnull MediaFileContext ctx, @Nullable LocaleCode defaultLocale) {
        BCP47Tag code;
        String localeCode = ctx.getMediaLocale();
        if (null == localeCode) {
            return defaultLocale;
        }
        try {
            code = BCP47TagSupport.createBCP47Tag((String)localeCode);
            if (null != code) {
                return code;
            }
        }
        catch (BCP47TagParseException e) {
            // empty catch block
        }
        try {
            code = ISO639_2Code.getBCP47TagForISO639Tag((String)localeCode);
            if (null != code) {
                return code;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        ctx.addIssue(MediaValidationCode.FILE_INVALID_LOCALE, ctx.getMediaName(), dictionary.add("localeCode", localeCode));
        return defaultLocale;
    }

    @SafeVarargs
    public static final <I> boolean meetsCriteria(@Nonnull I f, ValueSetFilter<? super I> ... criteria) {
        for (ValueSetFilter<I> valueSetFilter : criteria) {
            if (valueSetFilter == null || valueSetFilter.meetsCriteria(f)) continue;
            return false;
        }
        return true;
    }

    public static final <T> Set<T> immutableSetOf(@Nonnull Comparator<T> comparator, T ... values) {
        TreeSet<T> set = new TreeSet<T>(comparator);
        Collections.addAll(set, values);
        return Collections.unmodifiableSet(set);
    }

    public static final boolean sameContents(@Nonnull Collection<?> c1, @Nonnull Collection<?> c2) {
        return c1.size() == c2.size() && c1.containsAll(c2);
    }

    @SafeVarargs
    @Nonnull
    public static final <T> T coalesce(@Nonnull T defaultValue, T ... values) {
        for (T value : values) {
            if (null == value) continue;
            return value;
        }
        return defaultValue;
    }

    public static final boolean doNormalizedLocalesMatch(@Nullable String localeCode1, @Nullable String localeCode2) {
        if (localeCode1 == null || localeCode2 == null) {
            return localeCode1 == localeCode2;
        }
        String[] parts1 = localeCode1.split("[-]");
        String[] parts2 = localeCode2.split("[-]");
        int common = Math.min(parts1.length, parts2.length);
        for (int idx = 0; idx < common; ++idx) {
            if (parts1[idx].equalsIgnoreCase(parts2[idx])) continue;
            return false;
        }
        return true;
    }

    public static final <C> Comparator<C> nullSafeGenericComparator() {
        return NullSafeGenericComparator.INSTANCE;
    }

    public static final <C extends Comparable<C>> Comparator<C> nullSafeComparator() {
        return NULL_SAFE_COMPARATOR;
    }

    public static final <C extends Comparable<C>> Comparator<Collection<C>> collectionComparator() {
        return COLLECTION_VALUE_COMPARATOR;
    }

    public static final <C, MK> Map<MK, Collection<C>> group(@Nonnull Collection<? extends C> source, @Nonnull Function<? super C, ? extends MK> keyFunction) {
        HashMap<Object, LinkedList<C>> map = new HashMap<Object, LinkedList<C>>();
        for (C value : source) {
            Object key = keyFunction.apply(value);
            if (key == null) continue;
            LinkedList<C> values = (LinkedList<C>)map.get(key);
            if (values == null) {
                values = new LinkedList<C>();
                map.put(key, values);
            }
            values.add(value);
        }
        return map;
    }

    public static final <C, MK, MV> Map<MK, Collection<MV>> group(@Nonnull Collection<? extends C> source, @Nonnull Function<? super C, ? extends MK> keyFunction, @Nonnull Function<? super C, ? extends MV> valueFunction) {
        HashMap<Object, LinkedList<Object>> map = new HashMap<Object, LinkedList<Object>>();
        for (C value : source) {
            Object mappedValue;
            Object key = keyFunction.apply(value);
            if (key == null || (mappedValue = valueFunction.apply(value)) == null) continue;
            LinkedList<Object> values = (LinkedList<Object>)map.get(key);
            if (values == null) {
                values = new LinkedList<Object>();
                map.put(key, values);
            }
            values.add(mappedValue);
        }
        return map;
    }

    public static String getOrdinal(int number) {
        int r = number % 100;
        if (r == 11 || r == 12 || r == 13) {
            return number + "th";
        }
        r = number % 10;
        if (r == 1) {
            return number + "st";
        }
        if (r == 2) {
            return number + "nd";
        }
        if (r == 3) {
            return number + "rd";
        }
        return number + "th";
    }

    public static enum NullSafeGenericComparator implements Comparator<Object>
    {
        INSTANCE{

            @Override
            public int compare(@Nullable Object c1, Object c2) {
                if (c1 == c2) {
                    return 0;
                }
                if (c1 == null) {
                    return -1;
                }
                if (c2 == null) {
                    return 1;
                }
                if (c1 instanceof Comparable && c1.getClass().isInstance(c2)) {
                    Comparable comp1 = (Comparable)c1;
                    return comp1.compareTo(c2);
                }
                int diff = c1.getClass().getName().compareTo(c2.getClass().getName());
                if (diff != 0) {
                    return diff;
                }
                return c1.toString().compareTo(c2.toString());
            }
        };

    }
}

