/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.media;

import com.apple.jingle.leghorn.media.MediaOption;
import com.apple.jingle.leghorn.media.MediaProperties;
import com.apple.jingle.leghorn.media.validator.ValidationLevel;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class MediaPropertiesBase
implements MediaProperties {
    public static final MediaProperties properties = new MediaPropertiesBase(){

        public String toString() {
            return this.getClass().getSimpleName() + "[]";
        }

        @Override
        public String getRawProperty(String key) {
            assert (null != key) : "Property key is required";
            return System.getProperty(key);
        }

        @Override
        @Nonnull
        public List<String> getRawPropertyList(@Nonnull String key) {
            return Collections.emptyList();
        }
    };

    @Override
    @Nullable
    public abstract String getRawProperty(@Nonnull String var1);

    @Override
    @Nullable
    public abstract List<String> getRawPropertyList(@Nonnull String var1);

    @Override
    @Nullable
    public String getRawProperty(@Nonnull String[] keys) {
        for (String key : keys) {
            String value = this.getRawProperty(key);
            if (value == null) continue;
            return value;
        }
        return null;
    }

    @Override
    @Nullable
    public List<String> getRawPropertyList(@Nonnull String[] keys) {
        for (String key : keys) {
            List<String> value = this.getRawPropertyList(key);
            if (value == null) continue;
            return value;
        }
        return null;
    }

    public final <E extends Enum<E>> E getProperty(@Nonnull String key, Class<E> enumType, @Nonnull E defaultValue) {
        String value = this.getRawProperty(key);
        if (null != value) {
            return Enum.valueOf(enumType, value.trim());
        }
        return defaultValue;
    }

    @Override
    @Nonnull
    public final String getProperty(@Nonnull String key, @Nonnull String defaultValue) {
        String value = this.getRawProperty(key);
        if (null != value) {
            return value.trim();
        }
        return defaultValue;
    }

    @Override
    public final boolean getProperty(@Nonnull String key, boolean defaultValue) {
        String value = this.getRawProperty(key);
        if (null != value) {
            String trimmedValue = value.trim();
            if (trimmedValue.equalsIgnoreCase("no") || trimmedValue.equalsIgnoreCase("false") || trimmedValue.equalsIgnoreCase("n") || trimmedValue.equals("0")) {
                return false;
            }
            if (trimmedValue.equalsIgnoreCase("yes") || trimmedValue.equalsIgnoreCase("true") || trimmedValue.equalsIgnoreCase("y") || trimmedValue.equals("1")) {
                return true;
            }
            throw new IllegalArgumentException("Failed to parse a boolean from the trimmed Value '" + trimmedValue + "' for key:" + key + ".");
        }
        return defaultValue;
    }

    @Override
    public final long getProperty(@Nonnull String key, long defaultValue) {
        String value = this.getRawProperty(key);
        if (null != value) {
            try {
                return Long.parseLong(value.trim());
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Failed to parse a long from the value '" + value + "' for key:" + key + ".");
            }
        }
        return defaultValue;
    }

    @Override
    public final double getProperty(@Nonnull String key, double defaultValue) {
        String value = this.getRawProperty(key);
        if (null != value) {
            try {
                return Double.parseDouble(value.trim());
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Failed to parse a double from the value '" + value + "' for key:" + key + ".");
            }
        }
        return defaultValue;
    }

    @Override
    public final boolean fixEnabledForRadar(int radarNumber, boolean defaultValue) {
        return this.getProperty("MZCheckFix." + radarNumber, defaultValue);
    }

    @Override
    @Nonnull
    public final ValidationLevel getProperty(String key, @Nonnull ValidationLevel defaultValue) {
        String value = this.getRawProperty(key);
        if (null != value) {
            value = value.trim();
        }
        return ValidationLevel.valueOfString(value, defaultValue);
    }

    @Override
    @Nonnull
    public final List<String> getProperty(@Nonnull String key, @Nonnull List<String> defaultValue) {
        List<String> values = this.getRawPropertyList(key);
        if (null != values) {
            return values;
        }
        return defaultValue;
    }

    public final <E extends Enum<E>> E getProperty(@Nonnull String[] key, Class<E> enumType, @Nonnull E defaultValue) {
        String value = this.getRawProperty(key);
        if (null != value) {
            return Enum.valueOf(enumType, value.trim());
        }
        return defaultValue;
    }

    @Override
    @Nonnull
    public final String getProperty(@Nonnull String[] key, @Nonnull String defaultValue) {
        String value = this.getRawProperty(key);
        if (null != value) {
            return value.trim();
        }
        return defaultValue;
    }

    @Override
    public final boolean getProperty(@Nonnull String[] key, boolean defaultValue) {
        String trimmedValue;
        String value = this.getRawProperty(key);
        if (null != value && (trimmedValue = value.trim()).length() > 0) {
            if (trimmedValue.equalsIgnoreCase("no") || trimmedValue.equalsIgnoreCase("false") || trimmedValue.equalsIgnoreCase("n") || trimmedValue.equals("0")) {
                return false;
            }
            if (trimmedValue.equalsIgnoreCase("yes") || trimmedValue.equalsIgnoreCase("true") || trimmedValue.equalsIgnoreCase("y") || trimmedValue.equals("1")) {
                return true;
            }
            throw new IllegalArgumentException("Failed to parse a boolean from the trimmed Value '" + trimmedValue + "' for key:" + key + ".");
        }
        return defaultValue;
    }

    @Override
    public final long getProperty(@Nonnull String[] key, long defaultValue) {
        String value = this.getRawProperty(key);
        if (null != value) {
            try {
                return Long.parseLong(value.trim());
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Failed to parse a long from the value '" + value + "' for key:" + key + ".");
            }
        }
        return defaultValue;
    }

    @Override
    public final double getProperty(@Nonnull String[] key, double defaultValue) {
        String value = this.getRawProperty(key);
        if (null != value) {
            try {
                return Double.parseDouble(value.trim());
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Failed to parse a double from the value '" + value + "' for key:" + key + ".");
            }
        }
        return defaultValue;
    }

    @Override
    @Nonnull
    public final ValidationLevel getProperty(String[] key, @Nonnull ValidationLevel defaultValue) {
        String value = this.getRawProperty(key);
        if (null != value) {
            value = value.trim();
        }
        return ValidationLevel.valueOfString(value, defaultValue);
    }

    @Override
    @Nonnull
    public final List<String> getProperty(@Nonnull String[] key, @Nonnull List<String> defaultValue) {
        List<String> values = this.getRawPropertyList(key);
        if (null != values) {
            return values;
        }
        return defaultValue;
    }

    @Override
    public boolean isEnabled(MediaOption mediaOption) {
        return mediaOption.isEnabled(this);
    }
}

