/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.media;

import com.apple.jingle.leghorn.media.MediaFingerPrint;
import com.apple.jingle.leghorn.media.MediaFingerPrintCalculator;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import java.util.TreeMap;
import javax.annotation.Nonnull;
import org.springframework.util.Base64Utils;

public enum MediaFingerPrintCalculatorScheme {
    b64md5{

        @Override
        public MediaFingerPrintCalculator newCalculator() {
            return new MediaFingerPrintCalculator(){
                public static final String digestAlgorithm = "MD5";
                private final Map<String, byte[]> toDigest = new TreeMap<String, byte[]>(String.CASE_INSENSITIVE_ORDER);

                @Override
                public MediaFingerPrintCalculator add(@Nonnull String key, @Nonnull String componentData) {
                    this.toDigest.put(key, componentData.getBytes(StandardCharsets.UTF_8));
                    return this;
                }

                protected byte[] toInternalForm() {
                    try {
                        MessageDigest digest = MessageDigest.getInstance(digestAlgorithm);
                        for (byte[] entry : this.toDigest.values()) {
                            digest.update(entry);
                        }
                        return digest.digest();
                    }
                    catch (NoSuchAlgorithmException e) {
                        throw new IllegalStateException("Unable to create " + this.name() + " digester", e);
                    }
                }

                @Override
                public String calculate() {
                    return this.name() + '[' + Base64Utils.encodeToString((byte[])this.toInternalForm()).replaceAll("\\=", "") + ']';
                }

                @Override
                public MediaFingerPrint calculateFingerPrint() {
                    return new MediaFingerPrint(b64md5, this.toInternalForm());
                }
            };
        }
    }
    ,
    strcat{

        @Override
        public MediaFingerPrintCalculator newCalculator() {
            return new MediaFingerPrintCalculator(){
                private final Map<String, String> toDigest = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);

                @Override
                public MediaFingerPrintCalculator add(@Nonnull String key, @Nonnull String componentData) {
                    this.toDigest.put(key, componentData);
                    return this;
                }

                protected void build(@Nonnull StringBuilder sb) {
                    boolean first = true;
                    for (String entry : this.toDigest.values()) {
                        if (!first) {
                            sb.append(',');
                        }
                        sb.append(entry);
                        first = false;
                    }
                }

                protected String toInternalForm() {
                    StringBuilder digest = new StringBuilder();
                    this.build(digest);
                    return digest.toString();
                }

                @Override
                public String calculate() {
                    StringBuilder digest = new StringBuilder(this.name()).append('[');
                    this.build(digest);
                    digest.append(']');
                    return digest.toString();
                }

                @Override
                public MediaFingerPrint calculateFingerPrint() {
                    return new MediaFingerPrint(strcat, this.toInternalForm());
                }
            };
        }
    }
    ,
    sharedComponentKeyV1{

        @Override
        public MediaFingerPrintCalculator newCalculator() {
            return new MediaFingerPrintCalculator(){
                public static final String digestAlgorithm = "SHA-256";
                private final Map<String, String> toDigest = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);

                @Override
                public MediaFingerPrintCalculator add(@Nonnull String key, @Nonnull String componentData) {
                    this.toDigest.put(key, componentData);
                    return this;
                }

                protected byte[] toInternalForm() {
                    if (this.toDigest.isEmpty()) {
                        return new byte[0];
                    }
                    try {
                        MessageDigest digest = MessageDigest.getInstance(digestAlgorithm);
                        for (Map.Entry<String, String> entry : this.toDigest.entrySet()) {
                            digest.update(entry.getKey().getBytes(StandardCharsets.UTF_8));
                            digest.update(entry.getValue().getBytes(StandardCharsets.UTF_8));
                        }
                        return digest.digest();
                    }
                    catch (NoSuchAlgorithmException e) {
                        throw new IllegalStateException("Unable to create " + this.name() + " digester", e);
                    }
                }

                @Override
                public String calculate() {
                    return this.calculateFingerPrint().toExternalForm();
                }

                @Override
                public MediaFingerPrint calculateFingerPrint() {
                    return new MediaFingerPrint(sharedComponentKeyV1, this.toInternalForm());
                }
            };
        }
    };


    public abstract MediaFingerPrintCalculator newCalculator();
}

