/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.media;

import com.apple.jingle.leghorn.media.MediaFingerPrintCalculatorScheme;
import javax.annotation.Nonnull;
import org.springframework.util.Base64Utils;

public class MediaFingerPrint {
    private final MediaFingerPrintCalculatorScheme scheme;
    private final String internalData;
    private String externalForm;

    public MediaFingerPrint(@Nonnull MediaFingerPrintCalculatorScheme scheme, @Nonnull String internalData) {
        assert (scheme != null);
        assert (internalData != null);
        this.scheme = scheme;
        this.internalData = internalData;
    }

    public MediaFingerPrint(@Nonnull MediaFingerPrintCalculatorScheme scheme, @Nonnull byte[] internalData) {
        assert (scheme != null);
        assert (internalData != null);
        this.scheme = scheme;
        this.internalData = Base64Utils.encodeToString((byte[])internalData).replaceAll("\\=", "");
    }

    @Nonnull
    protected static MediaFingerPrint fromExternalForm(@Nonnull String externalForm) {
        int start = externalForm.indexOf(91);
        if (start != -1 && externalForm.endsWith("]")) {
            String schemeName = externalForm.substring(0, start);
            String internalData = externalForm.substring(start + 1, externalForm.length() - 1);
            return new MediaFingerPrint(MediaFingerPrintCalculatorScheme.valueOf(schemeName), internalData);
        }
        throw new IllegalArgumentException("Invalid finger print: " + externalForm);
    }

    @Nonnull
    public String toExternalForm() {
        if (this.externalForm == null) {
            this.externalForm = this.scheme.name() + "[" + this.internalData + "]";
        }
        return this.externalForm;
    }

    public int hashCode() {
        return this.toExternalForm().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof MediaFingerPrint) {
            MediaFingerPrint comp = (MediaFingerPrint)obj;
            return this.toExternalForm().equals(comp.toExternalForm());
        }
        return false;
    }

    public String toString() {
        return this.toExternalForm();
    }

    public static void main(String[] parms) {
        try {
            MediaFingerPrint fp1 = new MediaFingerPrint(MediaFingerPrintCalculatorScheme.b64md5, "1".getBytes());
            System.out.println("--> " + fp1);
            MediaFingerPrint fp2 = MediaFingerPrint.fromExternalForm(fp1.toExternalForm());
            System.out.println("--> " + fp2);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

