/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.media;

import com.apple.jingle.leghorn.media.feature.FeatureKind;
import com.apple.jingle.leghorn.media.feature.MediaFeature;
import com.apple.jingle.leghorn.media.feature.MediaFeatureKey;
import com.apple.jingle.leghorn.media.feature.MediaScope;
import com.apple.jingle.leghorn.media.index.IndexedMap;
import com.apple.jingle.leghorn.media.index.IndexedMapFilter;
import com.apple.jingle.leghorn.media.index.ValueSet;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.TreeMap;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class MediaFeatureSet<M extends MediaFeature>
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected final TreeMap<MediaFeatureKey, M> featureMap = new TreeMap();
    protected final IndexedMap<M> indexMap = new IndexedMap();

    public String toString() {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (MediaFeature value : this.featureMap.values()) {
            if (!first) {
                sb.append(", ");
            }
            first = false;
            sb.append(value.toString());
        }
        return sb.toString();
    }

    public boolean isEmpty() {
        return this.featureMap.isEmpty();
    }

    @Nonnegative
    public int size() {
        return this.featureMap.size();
    }

    public void putFeature(@Nonnull M feature) {
        MediaFeatureKey featureKey = feature.mediaFeatureKey();
        MediaFeature oldValue = (MediaFeature)this.featureMap.remove(featureKey);
        if (oldValue != null) {
            this.handleRemove(oldValue);
        }
        this.featureMap.put(featureKey, feature);
        this.handleAdd(feature);
    }

    protected void handleRemove(@Nonnull M media) {
        this.indexMap.remove(media);
    }

    protected void handleAdd(@Nonnull M media) {
        this.indexMap.put(media.indexKeys(), media);
    }

    public void putAllFeatures(@Nonnull Collection<? extends M> features) {
        for (MediaFeature feature : features) {
            this.putFeature(feature);
        }
    }

    @SafeVarargs
    @Nonnull
    public final boolean removeFeatures(IndexedMapFilter<? super M> ... criteria) {
        return this.removeFeatures(Arrays.asList(criteria));
    }

    @Nonnull
    public boolean removeFeatures(@Nonnull Collection<? extends IndexedMapFilter<? super M>> criteria) {
        boolean removed = false;
        for (MediaFeature media : this.getFeatures(criteria)) {
            MediaFeature feature = (MediaFeature)this.featureMap.remove(media.mediaFeatureKey());
            if (feature == null) continue;
            removed = true;
            this.handleRemove(media);
        }
        return removed;
    }

    @SafeVarargs
    @Nonnull
    public final <FK extends M> ValueSet<FK> getFeatures(Class<FK> type, Collection<? extends IndexedMapFilter<? super M>> ... complexFilters) {
        if (complexFilters.length == 0) {
            throw new IllegalStateException("At least one complex filter must be specified");
        }
        ValueSet<FK> lastValueSet = null;
        for (Collection<IndexedMapFilter<M>> collection : complexFilters) {
            if (collection == null || (lastValueSet = this.getFeatures(type, (Collection<? extends IndexedMapFilter<? super M>>)collection)).isEmpty()) continue;
            return lastValueSet;
        }
        return lastValueSet;
    }

    @SafeVarargs
    @Nonnull
    public final <FK extends M> ValueSet<FK> getFeatures(Class<FK> type, IndexedMapFilter<? super M> ... keyFilters) {
        return this.getFeatures(type, (Collection<? extends IndexedMapFilter<? super M>>)Arrays.asList(keyFilters));
    }

    @Nonnull
    public final <FK extends M> ValueSet<FK> getFeatures(Class<FK> type, @Nullable Collection<? extends IndexedMapFilter<? super M>> keyFilters) {
        return this.indexMap.find(keyFilters).cast(type);
    }

    @SafeVarargs
    @Nonnull
    public final ValueSet<M> getFeatures(IndexedMapFilter<? super M> ... keyFilters) {
        return this.getFeatures(Arrays.asList(keyFilters));
    }

    @Nonnull
    public final ValueSet<M> getFeatures(@Nonnull Collection<? extends IndexedMapFilter<? super M>> keyFilters) {
        return this.indexMap.find(keyFilters);
    }

    @SafeVarargs
    public final boolean hasFeature(IndexedMapFilter<? super M> ... keyFilters) {
        return this.hasFeature(Arrays.asList(keyFilters));
    }

    public final boolean hasFeature(@Nonnull Collection<? extends IndexedMapFilter<? super M>> keyFilters) {
        return !this.getFeatures(keyFilters).isEmpty();
    }

    public void dump() {
        System.out.println(this.getMediaFeatureDump());
    }

    public String getMediaFeatureDump() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.toString()).append("\n");
        for (FeatureKind featureKind : FeatureKind.values()) {
            for (MediaScope scope : MediaScope.values()) {
                ValueSet<M> media = this.getFeatures(scope, featureKind);
                if (media.isEmpty()) continue;
                sb.append(featureKind).append('.').append(scope).append(":\n");
                for (MediaFeature m : media) {
                    sb.append("  ").append(m).append("\n");
                }
                sb.append("\n");
            }
        }
        return sb.toString();
    }
}

