/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.media;

import com.apple.jingle.g5.MediaGrade;
import com.apple.jingle.leghorn.media.feature.FeatureKind;
import com.apple.jingle.leghorn.media.feature.MediaFeature;
import com.apple.jingle.leghorn.media.index.ValueSetFilter;
import com.apple.jingle.locale.LocaleCode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class MediaFeatureCriteria {
    private MediaFeatureCriteria() {
    }

    public static final class FeatureKindIn
    extends ValueSetFilter.ValueSetFilterBase<MediaFeature> {
        @Nullable
        final Set<? extends FeatureKind> featureKinds;

        public FeatureKindIn(Set<? extends FeatureKind> featureKinds) {
            this.featureKinds = featureKinds;
        }

        public String toString() {
            return "FeatureKindIn" + this.featureKinds;
        }

        @Override
        public boolean meetsCriteria(@Nonnull MediaFeature feature) {
            return feature.getFeatureKind() != null && this.featureKinds.contains(feature.getFeatureKind());
        }
    }

    public static class GradeIn
    extends ValueSetFilter.ValueSetFilterBase<MediaFeature> {
        @Nullable
        final Set<? extends MediaGrade> grades;

        public GradeIn(Set<? extends MediaGrade> grades) {
            this.grades = grades;
        }

        public String toString() {
            return "GradeIn" + this.grades;
        }

        @Override
        public boolean meetsCriteria(@Nonnull MediaFeature feature) {
            return feature.getMediaGrade() != null && this.grades.contains(feature.getMediaGrade());
        }
    }

    public static class LocaleIn
    extends ValueSetFilter.ValueSetFilterBase<MediaFeature> {
        @Nullable
        final Set<LocaleCode> localeCodes;

        public LocaleIn(Set<LocaleCode> localeCodes) {
            this.localeCodes = localeCodes;
        }

        public String toString() {
            return "LocaleIn" + this.localeCodes;
        }

        @Override
        public boolean meetsCriteria(@Nonnull MediaFeature feature) {
            return feature.getLocale() != null && this.localeCodes.contains(feature.getLocale());
        }
    }

    public static class MediaNameCriteria
    extends ValueSetFilter.ValueSetFilterBase<MediaFeature> {
        @Nullable
        final String mediaName;

        public MediaNameCriteria(String mediaName) {
            this.mediaName = mediaName;
        }

        public String toString() {
            return "MediaNameCriteria[" + this.mediaName + "]";
        }

        @Override
        public boolean meetsCriteria(@Nonnull MediaFeature feature) {
            return Objects.equals(this.mediaName, feature.getMediaName());
        }
    }

    public static class LocaleMatcher
    extends ValueSetFilter.ValueSetFilterBase<MediaFeature> {
        @Nonnull
        final Collection<Pattern> localePatterns;
        @Nonnull
        final Collection<String> localePatternStrings;

        public LocaleMatcher(String ... localePatternStrings) {
            this.localePatternStrings = Arrays.asList(localePatternStrings);
            this.localePatterns = new ArrayList<Pattern>(localePatternStrings.length);
            for (String localeMatcher : localePatternStrings) {
                this.localePatterns.add(Pattern.compile(localeMatcher.replaceAll("\\*", ".*"), 2));
            }
        }

        @Override
        public boolean meetsCriteria(@Nonnull MediaFeature feature) {
            LocaleCode featureLocaleCode = feature.getLocale();
            if (null != featureLocaleCode) {
                String name = featureLocaleCode.getName();
                for (Pattern p : this.localePatterns) {
                    if (!p.matcher(name).matches()) continue;
                    return true;
                }
            }
            return false;
        }

        public String toString() {
            return this.localePatternStrings.toString();
        }
    }

    public static class LocaleCriteria
    extends ValueSetFilter.ValueSetFilterBase<MediaFeature> {
        @Nullable
        final LocaleCode localeCode;

        public LocaleCriteria(LocaleCode localeCode) {
            this.localeCode = localeCode;
        }

        public String toString() {
            return "LocaleCriteria[" + this.localeCode + "]";
        }

        @Override
        public boolean meetsCriteria(@Nonnull MediaFeature feature) {
            LocaleCode featureLocaleCode = feature.getLocale();
            return this.localeCode == featureLocaleCode || null != this.localeCode && this.localeCode.equals(featureLocaleCode);
        }
    }

    public static class MediaNameMatcher
    extends ValueSetFilter.ValueSetFilterBase<MediaFeature> {
        @Nonnull
        private final String strPattern;
        @Nullable
        private final Pattern pattern;

        public MediaNameMatcher(@Nonnull String pattern) {
            this.strPattern = pattern;
            this.pattern = Pattern.compile(pattern);
        }

        public String toString() {
            return "MediaNameMatcher[" + this.strPattern + "]";
        }

        @Override
        public boolean meetsCriteria(@Nonnull MediaFeature feature) {
            String featureName = feature.getMediaName();
            return null != featureName && this.pattern.matcher(featureName).matches();
        }
    }
}

