/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.media;

import com.apple.jingle.g5.MediaGrade;
import com.apple.jingle.leghorn.Configuration;
import com.apple.jingle.leghorn.LeghornValidationContext;
import com.apple.jingle.leghorn.LeghornValidationContextImpl;
import com.apple.jingle.leghorn.audio.WavDescriberVerifier;
import com.apple.jingle.leghorn.audio.caf.beans.CafDescriptionDocument;
import com.apple.jingle.leghorn.audio.wav.beans.StreamDescriptionDocument;
import com.apple.jingle.leghorn.beans.dolby.contentmapping.DolbyContentMappingDocument;
import com.apple.jingle.leghorn.dolby.contentmapping.DolbyContentMap;
import com.apple.jingle.leghorn.fileformat.ContainerDescription;
import com.apple.jingle.leghorn.fileformat.ContainerType;
import com.apple.jingle.leghorn.fileformat.UniformTypeIdentiferContainerTypeAdaptor;
import com.apple.jingle.leghorn.fileformat.Verifier;
import com.apple.jingle.leghorn.fileformat.exceptions.DescriptionException;
import com.apple.jingle.leghorn.fileformat.impl.types.CoreAudioDescriberVerifier;
import com.apple.jingle.leghorn.fileformat.impl.types.DolbyContentMapperDescriberVerifier;
import com.apple.jingle.leghorn.fileformat.impl.types.ImageDescriberVerifier;
import com.apple.jingle.leghorn.fileformat.impl.types.SubtitleDocumentDescriberVerifier;
import com.apple.jingle.leghorn.fileformat.impl.types.TimedTextDocumentDescriberVerifier;
import com.apple.jingle.leghorn.fileformat.impl.types.VTTDocumentDescriber;
import com.apple.jingle.leghorn.media.dolbymapping.file.DolbyContentMappingMediaFile;
import com.apple.jingle.leghorn.media.dolbymapping.file.DolbyContentMappingVideoTrack;
import com.apple.jingle.leghorn.media.feature.FeatureKind;
import com.apple.jingle.leghorn.media.feature.MediaAudioChannel;
import com.apple.jingle.leghorn.media.feature.MediaAudioFeature;
import com.apple.jingle.leghorn.media.feature.MediaCaptionsFeature;
import com.apple.jingle.leghorn.media.feature.MediaDubCardFeature;
import com.apple.jingle.leghorn.media.feature.MediaDvsFeature;
import com.apple.jingle.leghorn.media.feature.MediaHDRVideoFeature;
import com.apple.jingle.leghorn.media.feature.MediaScope;
import com.apple.jingle.leghorn.media.feature.MediaSdhFeature;
import com.apple.jingle.leghorn.media.feature.MediaSubtitleFeature;
import com.apple.jingle.leghorn.media.feature.MediaVideoFeature;
import com.apple.jingle.leghorn.media.feature.misc.SccFeature;
import com.apple.jingle.leghorn.media.feature.misc.SdhFeature;
import com.apple.jingle.leghorn.media.feature.misc.SubtitleFeature;
import com.apple.jingle.leghorn.media.feature.mpeg2ps.Mpeg2psAudioFeature;
import com.apple.jingle.leghorn.media.feature.mpeg2ps.Mpeg2psVideoFeature;
import com.apple.jingle.leghorn.media.feature.quicktime.QTHDRVideoFeature;
import com.apple.jingle.leghorn.media.feature.quicktime.QtAudioFeature;
import com.apple.jingle.leghorn.media.feature.quicktime.QtCaptionsFeature;
import com.apple.jingle.leghorn.media.feature.quicktime.QtDubCardFeature;
import com.apple.jingle.leghorn.media.feature.quicktime.QtDvsFeature;
import com.apple.jingle.leghorn.media.feature.quicktime.QtSdhFeature;
import com.apple.jingle.leghorn.media.feature.quicktime.QtSubtitleFeature;
import com.apple.jingle.leghorn.media.feature.quicktime.QtVideoFeature;
import com.apple.jingle.leghorn.media.file.MediaCaptionsTrack;
import com.apple.jingle.leghorn.media.file.MediaFile;
import com.apple.jingle.leghorn.media.file.MediaFileBackedByXmlDescriptionImpl;
import com.apple.jingle.leghorn.media.file.MediaFileContext;
import com.apple.jingle.leghorn.media.file.MediaFileType;
import com.apple.jingle.leghorn.media.file.MediaSoundTrack;
import com.apple.jingle.leghorn.media.file.MediaSubtitleTrack;
import com.apple.jingle.leghorn.media.file.MediaVideoTrack;
import com.apple.jingle.leghorn.media.file.NullMediaFile;
import com.apple.jingle.leghorn.media.file.misc.Ac3MediaFileImpl;
import com.apple.jingle.leghorn.media.file.misc.BWFAudioMediaFileImpl;
import com.apple.jingle.leghorn.media.file.misc.CoreAudioMediaFileImpl;
import com.apple.jingle.leghorn.media.file.misc.IttMediaFileImpl;
import com.apple.jingle.leghorn.media.file.misc.IttMediaTrackImpl;
import com.apple.jingle.leghorn.media.file.misc.SccMediaFileImpl;
import com.apple.jingle.leghorn.media.file.misc.SccMediaTrackImpl;
import com.apple.jingle.leghorn.media.file.misc.TexmlMediaFileImpl;
import com.apple.jingle.leghorn.media.file.misc.WebVTTMediaFileImpl;
import com.apple.jingle.leghorn.media.file.mpeg2ps.Mpeg2psMediaFile;
import com.apple.jingle.leghorn.media.file.mpeg2ps.Mpeg2psSoundTrack;
import com.apple.jingle.leghorn.media.file.mpeg2ps.Mpeg2psVideoTrack;
import com.apple.jingle.leghorn.media.file.quicktime.QtCaptionsTrack;
import com.apple.jingle.leghorn.media.file.quicktime.QtSoundTrack;
import com.apple.jingle.leghorn.media.file.quicktime.QtSubtitleTrack;
import com.apple.jingle.leghorn.media.file.quicktime.QtVideoTrack;
import com.apple.jingle.leghorn.media.file.quicktime.QuickTimeMediaFile;
import com.apple.jingle.leghorn.media.xml.XmlObjectMediaParser;
import com.apple.jingle.leghorn.mpeg2.MPEG2DescriptionGenerator;
import com.apple.jingle.leghorn.mpeg2.ProgramStream;
import com.apple.jingle.leghorn.mpeg2.ProgramStreamValidationContext;
import com.apple.jingle.leghorn.quicktime.MediaDescriptionGenerator;
import com.apple.jingle.leghorn.quicktime.QuickTimeParser;
import com.apple.jingle.leghorn.quicktime.QuickTimeValidationContext;
import com.apple.jingle.leghorn.scc.xml.SccDescriptionDocument;
import com.apple.jingle.leghorn.subtitle.xml.SubtitleDescriptionDocument;
import com.apple.jingle.leghorn.texml.xml.TexmlDescriptionDocument;
import com.apple.jingle.leghorn.util.XmlBeansHelper;
import com.apple.jingle.media.foundation.io.FileSeekableDataInput;
import com.apple.jingle.media.foundation.io.SeekableDataInput;
import com.apple.jingle.media.foundation.io.SeekableInputStream;
import com.apple.jingle.media.foundation.types.UniformTypeIdentifier;
import com.apple.jingle.media.foundation.util.XMLUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.annotation.Nonnull;
import javax.xml.transform.TransformerException;
import noNamespace.ContainerDocument;
import noNamespace.MovieDocument;
import org.apache.log4j.Logger;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class MediaFactory {
    private static final Logger logger = Logger.getLogger(MediaFactory.class);

    private MediaFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public static MediaFile newMediaFile(@Nonnull MediaFileContext metaData, @Nonnull File file) throws IOException, DescriptionException, XmlException {
        UniformTypeIdentifier uti = metaData.getUniformTypeIdentifier();
        UniformTypeIdentiferContainerTypeAdaptor containerType = new UniformTypeIdentiferContainerTypeAdaptor(uti);
        XmlOptions xmlOptions = new XmlOptions().setLoadLineNumbers();
        MediaFileType mediaFileType = MediaFileType.lookupByUti(uti, MediaFileType.unknown);
        switch (uti) {
            case COM_APPLE_QUICKTIME_MOVIE: 
            case PUBLIC_MPEG_4_VIDEO: {
                try (FileSeekableDataInput qtSdi = new FileSeekableDataInput(file);){
                    QuickTimeValidationContext ctx = new QuickTimeValidationContext(file.getName());
                    MovieDocument doc = MediaDescriptionGenerator.generateDescription(ctx, new QuickTimeParser().parseFile((LeghornValidationContext)ctx, (SeekableDataInput)qtSdi));
                    QuickTimeMediaFile quickTimeMediaFile = new QuickTimeMediaFile(metaData, doc.getMovie());
                    return quickTimeMediaFile;
                }
            }
            case COM_DOLBY_CONTENTMAPPING: {
                try (FileSeekableDataInput hdrSdi = new FileSeekableDataInput(file);){
                    LeghornValidationContextImpl ctx = new LeghornValidationContextImpl(hdrSdi.getFileName(), UniformTypeIdentifier.COM_DOLBY_CONTENTMAPPING, "FoghornLeghorn Dolby Content Mapping Parser", Configuration.getVersion());
                    new DolbyContentMapperDescriberVerifier().describe(ctx, (SeekableDataInput)hdrSdi, containerType);
                    XmlObject xmlObject = XmlObject.Factory.parse((InputStream)new SeekableInputStream((SeekableDataInput)hdrSdi), XmlBeansHelper.getXmlOptionsWithDisabledXXE());
                    XmlObjectMediaParser parser = new XmlObjectMediaParser(ctx, ctx.getMediaName(), xmlObject);
                    XmlObjectMediaParser child = parser.child("DolbyLabsMDF");
                    if (child != null) {
                        DolbyContentMap cm = new DolbyContentMap(ctx, child);
                        DolbyContentMappingDocument xmlDoc = DolbyContentMappingDocument.Factory.newInstance((XmlOptions)xmlOptions);
                        DolbyContentMappingDocument.DolbyContentMapping xmlCm = xmlDoc.addNewDolbyContentMapping();
                        cm.generateDescription(ctx, xmlCm);
                        DolbyContentMappingMediaFile dolbyContentMappingMediaFile = new DolbyContentMappingMediaFile(ctx, xmlCm);
                        return dolbyContentMappingMediaFile;
                    }
                    NullMediaFile cm = new NullMediaFile(metaData, mediaFileType);
                    return cm;
                }
            }
            case PUBLIC_MPEG_2_VIDEO: {
                try (FileSeekableDataInput mp2Sdi = new FileSeekableDataInput(file);){
                    ProgramStreamValidationContext ctx = new ProgramStreamValidationContext(file.getName());
                    ProgramStream programStream = new ProgramStream();
                    programStream.parse(ctx, (SeekableDataInput)mp2Sdi);
                    ContainerDescription<Node> cd = MPEG2DescriptionGenerator.generateDescription(ctx, programStream);
                    ContainerDocument doc = ContainerDocument.Factory.parse((Node)cd.getDescriptionDocument(), (XmlOptions)xmlOptions);
                    Mpeg2psMediaFile xmlDoc = new Mpeg2psMediaFile(metaData, doc.getContainer());
                    return xmlDoc;
                }
            }
            case COM_APPLE_QUICKTIME_TX3G: {
                ContainerDescription<Node> cd = new TimedTextDocumentDescriberVerifier().describe(file.toURI(), (ContainerType)containerType);
                TexmlDescriptionDocument doc = TexmlDescriptionDocument.Factory.parse((Node)cd.getDescriptionDocument(), (XmlOptions)xmlOptions);
                return new TexmlMediaFileImpl(metaData, doc.getTexmlDescription());
            }
            case COM_APPLE_ITUNES_TIMED_TEXT: {
                ContainerDescription<Node> cd = new SubtitleDocumentDescriberVerifier().describe(file.toURI(), (ContainerType)containerType);
                SubtitleDescriptionDocument doc = SubtitleDescriptionDocument.Factory.parse((Node)cd.getDescriptionDocument(), (XmlOptions)xmlOptions);
                return new IttMediaFileImpl(metaData, doc.getSubtitleDescription());
            }
            case COM_APPLE_COREAUDIO_FORMAT: {
                ContainerDescription<Node> cacd = new CoreAudioDescriberVerifier().describe(file.toURI(), (ContainerType)containerType);
                CafDescriptionDocument cafdoc = CafDescriptionDocument.Factory.parse((Node)cacd.getDescriptionDocument(), (XmlOptions)xmlOptions);
                return new CoreAudioMediaFileImpl(metaData, cafdoc.getCafDescription());
            }
            case COM_MICROSOFT_WAVEFORM_AUDIO: {
                xmlOptions.setDocumentType(StreamDescriptionDocument.type);
                ContainerDescription<Node> bwfcd = new WavDescriberVerifier().describe(file.toURI(), (ContainerType)containerType);
                StreamDescriptionDocument bwfdoc = StreamDescriptionDocument.Factory.parse((Node)bwfcd.getDescriptionDocument(), (XmlOptions)xmlOptions);
                return new BWFAudioMediaFileImpl(metaData, bwfdoc.getStreamDescription());
            }
            case COM_APPLE_QUICKTIME_WVTT: {
                ContainerDescription<Node> wvttcd = new VTTDocumentDescriber().describe(file.toURI(), (ContainerType)containerType);
                return new WebVTTMediaFileImpl(metaData, XmlObject.Factory.parse(wvttcd.getDescriptionDocument(), xmlOptions));
            }
            case PUBLIC_JPEG: {
                try {
                    ContainerDescription<Node> description = new ImageDescriberVerifier().describe(file.toURI(), (ContainerType)containerType);
                    return new MediaFileBackedByXmlDescriptionImpl(metaData, mediaFileType, description.getDescriptionDocument());
                }
                catch (Exception ignored) {
                    logger.info((Object)ignored);
                    return new NullMediaFile(metaData, mediaFileType);
                }
            }
        }
        try {
            Object description = Verifier.getDefaultVerifier().describe(file, (ContainerType)containerType).getDescriptionDocument();
            if (description instanceof Node) {
                return new MediaFileBackedByXmlDescriptionImpl(metaData, mediaFileType, (Node)description);
            }
            System.out.println("Description is: " + description);
        }
        catch (Exception ignored) {
            ignored.printStackTrace();
            logger.info((Object)ignored);
        }
        return new NullMediaFile(metaData, mediaFileType);
    }

    @Nonnull
    public static MediaFile newMediaFile(@Nonnull MediaFileContext metaData, @Nonnull String sourceDescriptionXml) throws XmlException, NoSuchElementException {
        UniformTypeIdentifier uti = metaData.getUniformTypeIdentifier();
        XmlOptions xmlOptions = new XmlOptions().setLoadLineNumbers();
        MediaFileType mediaFileType = MediaFileType.lookupByUti(uti, MediaFileType.unknown);
        switch (uti) {
            case COM_APPLE_QUICKTIME_MOVIE: 
            case PUBLIC_MPEG_4_VIDEO: {
                return new QuickTimeMediaFile(metaData, MovieDocument.Factory.parse((String)sourceDescriptionXml, (XmlOptions)xmlOptions).getMovie());
            }
            case PUBLIC_MPEG_2_VIDEO: {
                return new Mpeg2psMediaFile(metaData, ContainerDocument.Factory.parse((String)sourceDescriptionXml, (XmlOptions)xmlOptions).getContainer());
            }
            case COM_SONIC_SCENARIST_SCC: {
                XmlOptions SccXmlOptions = new XmlOptions().setLoadLineNumbers();
                HashMap<String, String> nsMap = new HashMap<String, String>();
                nsMap.put("", "http://jingle.apple.com/leghorn/scc/xml");
                SccXmlOptions.setLoadSubstituteNamespaces(nsMap);
                return new SccMediaFileImpl(metaData, SccDescriptionDocument.Factory.parse((String)sourceDescriptionXml, (XmlOptions)SccXmlOptions).getSccDescription());
            }
            case COM_APPLE_ITUNES_TIMED_TEXT: {
                return new IttMediaFileImpl(metaData, SubtitleDescriptionDocument.Factory.parse((String)sourceDescriptionXml, (XmlOptions)xmlOptions).getSubtitleDescription());
            }
            case COM_APPLE_QUICKTIME_TX3G: {
                return new TexmlMediaFileImpl(metaData, TexmlDescriptionDocument.Factory.parse((String)sourceDescriptionXml, (XmlOptions)xmlOptions).getTexmlDescription());
            }
            case PUBLIC_AC3_AUDIO: {
                return new Ac3MediaFileImpl(metaData, XmlObject.Factory.parse(sourceDescriptionXml, xmlOptions));
            }
            case COM_DOLBY_CONTENTMAPPING: {
                return new DolbyContentMappingMediaFile(metaData, DolbyContentMappingDocument.Factory.parse((String)sourceDescriptionXml, (XmlOptions)xmlOptions).getDolbyContentMapping());
            }
            case COM_APPLE_COREAUDIO_FORMAT: {
                return new CoreAudioMediaFileImpl(metaData, CafDescriptionDocument.Factory.parse((String)sourceDescriptionXml, (XmlOptions)xmlOptions).getCafDescription());
            }
            case COM_MICROSOFT_WAVEFORM_AUDIO: {
                xmlOptions.setDocumentType(StreamDescriptionDocument.type);
                return new BWFAudioMediaFileImpl(metaData, StreamDescriptionDocument.Factory.parse((String)sourceDescriptionXml, (XmlOptions)xmlOptions).getStreamDescription());
            }
            case COM_APPLE_QUICKTIME_WVTT: {
                return new WebVTTMediaFileImpl(metaData, XmlObject.Factory.parse(sourceDescriptionXml, xmlOptions));
            }
            case PUBLIC_JPEG: {
                try {
                    return new MediaFileBackedByXmlDescriptionImpl(metaData, mediaFileType, XMLUtil.parseXML((String)sourceDescriptionXml));
                }
                catch (Exception ignored) {
                    logger.info((Object)ignored);
                    return new NullMediaFile(metaData, mediaFileType);
                }
            }
        }
        try {
            Document xmlDocument = XMLUtil.parseXML((String)sourceDescriptionXml);
            return new MediaFileBackedByXmlDescriptionImpl(metaData, mediaFileType, xmlDocument);
        }
        catch (Exception ignored) {
            logger.info((Object)ignored);
            return new NullMediaFile(metaData, mediaFileType);
        }
    }

    @Nonnull
    public static MediaFile newMediaFile(@Nonnull MediaFileContext metaData, @Nonnull Node sourceDescriptionXml) throws XmlException, NoSuchElementException {
        String descriptionXml;
        try {
            descriptionXml = XMLUtil.nodeToString((Node)sourceDescriptionXml);
        }
        catch (TransformerException e) {
            throw new XmlException(e);
        }
        try {
            return MediaFactory.newMediaFile(metaData, descriptionXml);
        }
        catch (XmlException e) {
            logger.error((Object)descriptionXml, (Throwable)e);
            throw e;
        }
    }

    @Nonnull
    public static MediaVideoFeature newVideoFeature(@Nonnull MediaFileContext ctx, @Nonnull MediaScope scope, @Nonnull MediaGrade videoGrade, @Nonnull MediaVideoTrack track) {
        if (track instanceof QtVideoTrack) {
            return new QtVideoFeature(ctx, (QtVideoTrack)track, scope, videoGrade);
        }
        if (track instanceof Mpeg2psVideoTrack) {
            return new Mpeg2psVideoFeature(ctx, (Mpeg2psVideoTrack)track, scope, videoGrade);
        }
        throw new NoSuchElementException("MediaVideoFeature[" + track + "]");
    }

    @Nonnull
    public static MediaDubCardFeature newDubCardFeature(@Nonnull MediaFileContext ctx, @Nonnull MediaScope scope, @Nonnull MediaGrade videoGrade, @Nonnull MediaVideoTrack track) {
        if (track instanceof QtVideoTrack) {
            return new QtDubCardFeature(ctx, (QtVideoTrack)track, scope, videoGrade);
        }
        throw new NoSuchElementException("MediaDubCardFeature[" + track + "]");
    }

    @Nonnull
    public static MediaHDRVideoFeature newHDRVideoFeature(@Nonnull MediaFileContext ctx, @Nonnull MediaScope scope, @Nonnull MediaGrade videoGrade, @Nonnull MediaVideoTrack track, @Nonnull DolbyContentMappingVideoTrack hdrMappingTrack) {
        if (track instanceof QtVideoTrack) {
            return new QTHDRVideoFeature(ctx, (QtVideoTrack)track, scope, videoGrade, hdrMappingTrack);
        }
        throw new NoSuchElementException("MediaHDRVideoFeature[" + track + "]");
    }

    @Nonnull
    public static MediaAudioFeature newAudioFeature(@Nonnull MediaFileContext ctx, @Nonnull MediaScope scope, @Nonnull FeatureKind featureKind, @Nonnull MediaGrade audioGrade, @Nonnull EnumMap<MediaAudioChannel, ? extends MediaSoundTrack> tracks) {
        if (tracks.isEmpty()) {
            throw new IllegalArgumentException("tracks cannot be empty");
        }
        MediaSoundTrack aTrack = tracks.values().iterator().next();
        if (aTrack instanceof QtSoundTrack) {
            EnumMap<MediaAudioChannel, QtSoundTrack> chTrackMap = new EnumMap<MediaAudioChannel, QtSoundTrack>(MediaAudioChannel.class);
            for (Map.Entry<MediaAudioChannel, ? extends MediaSoundTrack> entry : tracks.entrySet()) {
                if (entry.getValue() instanceof QtSoundTrack) {
                    chTrackMap.put((MediaAudioChannel)((Enum)entry.getKey()), (QtSoundTrack)entry.getValue());
                    continue;
                }
                throw new IllegalStateException("Expecting a map of QtSoundTracks, not " + entry);
            }
            return new QtAudioFeature(ctx, ((QtSoundTrack)aTrack).getMediaFile(), featureKind, chTrackMap, scope, audioGrade);
        }
        if (aTrack instanceof Mpeg2psSoundTrack) {
            EnumMap<MediaAudioChannel, Mpeg2psSoundTrack> chTrackMap = new EnumMap<MediaAudioChannel, Mpeg2psSoundTrack>(MediaAudioChannel.class);
            for (Map.Entry<MediaAudioChannel, ? extends MediaSoundTrack> entry : tracks.entrySet()) {
                if (entry.getValue() instanceof Mpeg2psSoundTrack) {
                    chTrackMap.put((MediaAudioChannel)((Enum)entry.getKey()), (Mpeg2psSoundTrack)entry.getValue());
                    continue;
                }
                throw new IllegalStateException("Expecting a map of Mpeg2psSoundTrack, not " + entry);
            }
            return new Mpeg2psAudioFeature(ctx, ((Mpeg2psSoundTrack)aTrack).getMediaFile(), featureKind, chTrackMap, scope, audioGrade);
        }
        throw new IllegalStateException("Expecting a map of QtSoundTracks or Mpeg2psSoundTracks, not " + aTrack);
    }

    @Nonnull
    public static MediaDvsFeature newDvsFeature(@Nonnull MediaFileContext ctx, @Nonnull MediaScope scope, @Nonnull FeatureKind featureKind, @Nonnull MediaGrade audioGrade, @Nonnull EnumMap<MediaAudioChannel, ? extends MediaSoundTrack> tracks) {
        if (tracks.isEmpty()) {
            throw new IllegalArgumentException("tracks cannot be empty");
        }
        MediaSoundTrack aTrack = tracks.values().iterator().next();
        if (aTrack instanceof QtSoundTrack) {
            EnumMap<MediaAudioChannel, QtSoundTrack> chTrackMap = new EnumMap<MediaAudioChannel, QtSoundTrack>(MediaAudioChannel.class);
            for (Map.Entry<MediaAudioChannel, ? extends MediaSoundTrack> entry : tracks.entrySet()) {
                if (entry.getValue() instanceof QtSoundTrack) {
                    chTrackMap.put((MediaAudioChannel)((Enum)entry.getKey()), (QtSoundTrack)entry.getValue());
                    continue;
                }
                throw new IllegalStateException("Expecting a map of QtSoundTracks, not " + entry);
            }
            return new QtDvsFeature(ctx, ((QtSoundTrack)aTrack).getMediaFile(), featureKind, chTrackMap, scope, audioGrade);
        }
        throw new IllegalStateException("Expecting a map of QtSoundTracks, not " + aTrack);
    }

    @Nonnull
    public static MediaSubtitleFeature newSubtitleFeature(@Nonnull MediaFileContext ctx, @Nonnull MediaScope scope, @Nonnull MediaGrade grade, @Nonnull MediaSubtitleTrack track) {
        if (track instanceof IttMediaTrackImpl) {
            return new SubtitleFeature(ctx, (IttMediaTrackImpl)track, scope, grade);
        }
        if (track instanceof QtSubtitleTrack) {
            return new QtSubtitleFeature(ctx, (QtSubtitleTrack)track, scope, grade);
        }
        throw new NoSuchElementException("MediaSubtitleFeature[" + track + "]");
    }

    @Nonnull
    public static MediaSdhFeature newSdhFeature(@Nonnull MediaFileContext ctx, @Nonnull MediaScope scope, @Nonnull MediaGrade grade, @Nonnull MediaSubtitleTrack track) {
        if (track instanceof IttMediaTrackImpl) {
            return new SdhFeature(ctx, (IttMediaTrackImpl)track, scope, grade);
        }
        if (track instanceof QtSubtitleTrack) {
            return new QtSdhFeature(ctx, (QtSubtitleTrack)track, scope, grade);
        }
        throw new NoSuchElementException("MediaSdhFeature[" + track + "]");
    }

    @Nonnull
    public static MediaCaptionsFeature newCaptionsFeature(@Nonnull MediaFileContext ctx, @Nonnull MediaScope scope, @Nonnull MediaGrade grade, @Nonnull MediaCaptionsTrack track) {
        if (track instanceof SccMediaTrackImpl) {
            return new SccFeature(ctx, (SccMediaTrackImpl)track, scope, grade);
        }
        if (track instanceof QtCaptionsTrack) {
            return new QtCaptionsFeature(ctx, (QtCaptionsTrack)track, scope, grade);
        }
        throw new NoSuchElementException("MediaCaptionsFeature[" + track + "]");
    }
}

