/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.media;

import com.apple.jingle.leghorn.fileformat.DescriptionWrapper;
import com.apple.jingle.leghorn.fileformat.exceptions.DescriberNotFoundException;
import com.apple.jingle.leghorn.util.XML1_0ToXML1_1ConversionFilterReader;
import com.sun.xml.bind.marshaller.CharacterEscapeHandler;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.UnmarshalException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

@XmlRootElement(name="media_description_result")
@XmlAccessorType(value=XmlAccessType.NONE)
public class MediaDescriptionResult {
    @XmlElement(name="tool")
    @XmlJavaTypeAdapter(value=CDATAAdapter.class)
    private String tool;
    @XmlElement(name="tool_version")
    @XmlJavaTypeAdapter(value=CDATAAdapter.class)
    private String toolVersion;
    @XmlElement(name="asset")
    private Asset asset;
    @XmlAttribute(name="media_description_not_sent")
    private boolean mediaDescriptionNotSent = false;
    @XmlElement(name="media_description")
    @XmlJavaTypeAdapter(value=CDATAAdapter.class)
    private String mediaDescription;
    @XmlElement(name="media_description_file")
    @XmlJavaTypeAdapter(value=FileAdapter.class)
    private File mediaDescriptionFile;
    @XmlElementWrapper(name="exceptions")
    @XmlElement(name="exception")
    private List<Exception> exceptions;

    public MediaDescriptionResult() {
    }

    public MediaDescriptionResult(String tool, String toolVersion, Asset asset) {
        this.tool = tool;
        this.toolVersion = toolVersion;
        this.asset = asset;
    }

    public MediaDescriptionResult(String tool, String toolVersion, Asset asset, String mediaDescription) {
        this.tool = tool;
        this.toolVersion = toolVersion;
        this.asset = asset;
        this.mediaDescription = mediaDescription;
    }

    public MediaDescriptionResult(String tool, String toolVersion, Asset asset, File mediaDescriptionFile) {
        this.tool = tool;
        this.toolVersion = toolVersion;
        this.asset = asset;
        this.mediaDescriptionFile = mediaDescriptionFile;
    }

    public MediaDescriptionResult(String tool, String toolVersion, Asset asset, DescriptionWrapper descriptionDocument) {
        this.tool = tool;
        this.toolVersion = toolVersion;
        this.asset = asset;
        if (descriptionDocument.payload() instanceof File) {
            this.mediaDescriptionFile = (File)descriptionDocument.payload();
        } else {
            this.mediaDescription = descriptionDocument.serializeToString();
        }
    }

    public static MediaDescriptionResult fromXml(InputStream in, boolean shouldRetryWithModifiedInputOnDeserializationFailure) {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{MediaDescriptionResult.class});
            return MediaDescriptionResult.deserialize(jaxbContext, new StreamSource(in), shouldRetryWithModifiedInputOnDeserializationFailure);
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    private static MediaDescriptionResult deserialize(JAXBContext jaxbContext, StreamSource streamSource, boolean shouldRetryWithModifiedInputOnDeserializationFailure) throws JAXBException, IOException {
        try {
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            JAXBElement item = unmarshaller.unmarshal((Source)streamSource, MediaDescriptionResult.class);
            return (MediaDescriptionResult)item.getValue();
        }
        catch (UnmarshalException e) {
            InputStream inputStream = streamSource.getInputStream();
            if (shouldRetryWithModifiedInputOnDeserializationFailure && inputStream.markSupported()) {
                inputStream.reset();
                return MediaDescriptionResult.deserialize(jaxbContext, new StreamSource(new XML1_0ToXML1_1ConversionFilterReader(new InputStreamReader(inputStream))), false);
            }
            throw e;
        }
    }

    public String getTool() {
        return this.tool;
    }

    public void setTool(String tool) {
        this.tool = tool;
    }

    public String getToolVersion() {
        return this.toolVersion;
    }

    public void setToolVersion(String toolVersion) {
        this.toolVersion = toolVersion;
    }

    public Asset getAsset() {
        return this.asset;
    }

    public void setAsset(Asset asset) {
        this.asset = asset;
    }

    public boolean getMediaDescriptionNotSent() {
        return this.mediaDescriptionNotSent;
    }

    public void setMediaDescriptionNotSent(boolean mediaDescriptionNotSent) {
        this.mediaDescriptionNotSent = mediaDescriptionNotSent;
    }

    public String getMediaDescription() {
        return this.mediaDescription;
    }

    public void setMediaDescription(String mediaDescription) {
        if (this.exceptions != null && !this.exceptions.isEmpty()) {
            throw new IllegalStateException("cannot set media description with non-empty exception list");
        }
        this.mediaDescription = mediaDescription;
    }

    public void setMediaDescriptionFile(File mediaDescriptionFile) {
        if (this.exceptions != null && !this.exceptions.isEmpty()) {
            throw new IllegalStateException("cannot set media description file with non-empty exception list");
        }
        this.mediaDescriptionFile = mediaDescriptionFile;
    }

    public void addException(java.lang.Exception ex) {
        if (this.mediaDescription != null) {
            throw new IllegalStateException("cannot add exception with non-null media description");
        }
        if (this.exceptions == null) {
            this.exceptions = new ArrayList<Exception>();
        }
        this.exceptions.add(new Exception(ex));
    }

    public void addException(String message, String stackTrace, int errorCode) {
        if (this.mediaDescription != null) {
            throw new IllegalStateException("cannot add exception with non-null media description");
        }
        if (this.exceptions == null) {
            this.exceptions = new ArrayList<Exception>();
        }
        this.exceptions.add(new Exception(message, stackTrace, errorCode));
    }

    public Collection<Exception> getExceptions() {
        if (this.exceptions == null) {
            return null;
        }
        return Collections.unmodifiableCollection(this.exceptions);
    }

    public void setExceptions(List<Exception> exceptions) {
        if (this.mediaDescription != null && exceptions != null) {
            throw new IllegalStateException("cannot set non-null exceptions with non-null media description");
        }
        this.exceptions = exceptions;
    }

    public boolean isDescriberNotFound() {
        return this.hasAnyOfTheseExceptionsInStackTraces(DescriberNotFoundException.class);
    }

    public boolean hasAnyExceptions() {
        boolean hasAtLeastOneException = this.exceptions != null && !this.exceptions.isEmpty();
        return hasAtLeastOneException;
    }

    public boolean hasAnyOfTheseExceptionsInStackTraces(Class<?> ... exceptionClasses) {
        if (this.exceptions == null) {
            return false;
        }
        for (Exception exception : this.exceptions) {
            if (!MediaDescriptionResult.hasAnyOfTheseExceptionsInStackTrace(exception, exceptionClasses)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasAnyOfTheseExceptionsInStackTrace(Exception exception, Class<?> ... exceptionClasses) {
        String stackTrace = exception.getStackTrace();
        if (stackTrace == null || stackTrace.isEmpty()) {
            return false;
        }
        for (Class<?> clazz : exceptionClasses) {
            if (!stackTrace.contains(clazz.getName())) continue;
            return true;
        }
        return false;
    }

    public void toXml(OutputStream out) {
        ClassLoader jaxbClassLoader;
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        ClassLoader classLoader = jaxbClassLoader = JAXBContext.class.getClassLoader() == null ? MediaDescriptionResult.class.getClassLoader() : JAXBContext.class.getClassLoader();
        if (jaxbClassLoader != null) {
            Thread.currentThread().setContextClassLoader(jaxbClassLoader);
        }
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{MediaDescriptionResult.class});
            Marshaller m = context.createMarshaller();
            m.setProperty("com.sun.xml.bind.characterEscapeHandler", (Object)new CharacterEscapeHandler(){

                public void escape(char[] ac, int start, int length, boolean isAttrValue, Writer writer) throws IOException {
                    writer.write(ac, start, length);
                }
            });
            m.marshal((Object)this, (Result)new StreamResult(new OutputStreamWriter(out, "UTF-8")));
        }
        catch (UnsupportedEncodingException encerr) {
            throw new RuntimeException(encerr);
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
    }

    public File getMediaDescriptionFile() {
        return this.mediaDescriptionFile;
    }

    public static class FileAdapter
    extends XmlAdapter<String, File> {
        public File unmarshal(String v) throws java.lang.Exception {
            return new File(v);
        }

        public String marshal(File v) throws java.lang.Exception {
            return v.getAbsolutePath();
        }
    }

    public static class CDATAAdapter
    extends XmlAdapter<String, String> {
        public String marshal(String v) {
            StringBuilder builder = new StringBuilder(v.length() + 13);
            builder.append("<![CDATA[").append(v).append("]]>");
            return builder.toString();
        }

        public String unmarshal(String v) {
            return v;
        }
    }

    @XmlAccessorType(value=XmlAccessType.NONE)
    public static final class Exception {
        @XmlElement(name="message")
        @XmlJavaTypeAdapter(value=CDATAAdapter.class)
        private String message;
        @XmlElement(name="stack")
        @XmlJavaTypeAdapter(value=CDATAAdapter.class)
        private String stackTrace;
        @XmlElement(name="error_code")
        private Integer errorCode;

        public Exception() {
        }

        public String toString() {
            return this.errorCode + "[" + this.message + "]";
        }

        public Exception(java.lang.Exception ex) {
            this.message = ex.getMessage();
            this.stackTrace = Exception.exceptionStackTraceToString(ex);
            this.errorCode = Exception.extractErrorCode(ex);
        }

        public Exception(String message, String stackTrace, Integer errorCode) {
            this.message = message;
            this.stackTrace = stackTrace;
            this.errorCode = errorCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getStackTrace() {
            return this.stackTrace;
        }

        public void setStackTrace(String stackTrace) {
            this.stackTrace = stackTrace;
        }

        public void setStackTrace(java.lang.Exception ex) {
            this.stackTrace = Exception.exceptionStackTraceToString(ex);
        }

        public Integer getErrorCode() {
            return this.errorCode;
        }

        public void setErrorCode(Integer errorCode) {
            this.errorCode = errorCode;
        }

        public void setErrorCode(java.lang.Exception ex) {
            this.errorCode = Exception.extractErrorCode(ex);
        }

        public static String exceptionStackTraceToString(java.lang.Exception ex) {
            if (ex == null) {
                return null;
            }
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ex.printStackTrace(new PrintStream(out, true));
            return new String(out.toByteArray());
        }

        public static Integer extractErrorCode(java.lang.Exception ex) {
            Class<?> exClass = ex.getClass();
            try {
                Field errorCodeField = exClass.getField("errorCode");
                if (errorCodeField != null) {
                    return errorCodeField.getInt(ex);
                }
            }
            catch (java.lang.Exception e) {
                // empty catch block
            }
            try {
                Method errorCodeMethod = exClass.getMethod("getErrorCode", new Class[0]);
                if (errorCodeMethod != null) {
                    return (Integer)errorCodeMethod.invoke((Object)ex, new Object[0]);
                }
            }
            catch (java.lang.Exception exception) {
                // empty catch block
            }
            return null;
        }
    }

    @XmlAccessorType(value=XmlAccessType.NONE)
    public static final class Asset {
        @XmlElement(name="file")
        @XmlJavaTypeAdapter(value=CDATAAdapter.class)
        private String file;
        @XmlElement(name="uti")
        @XmlJavaTypeAdapter(value=CDATAAdapter.class)
        private String uti;
        @XmlElement(name="role")
        @XmlJavaTypeAdapter(value=CDATAAdapter.class)
        private String role;

        public Asset() {
        }

        public Asset(String file, String uti, String role) {
            this.file = file;
            this.uti = uti;
            this.role = role;
        }

        public String getFile() {
            return this.file;
        }

        public void setFile(String file) {
            this.file = file;
        }

        public String getUti() {
            return this.uti;
        }

        public void setUti(String uti) {
            this.uti = uti;
        }

        public String getRole() {
            return this.role;
        }

        public void setRole(String role) {
            this.role = role;
        }
    }
}

