/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.media;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DottedString {
    @Nullable
    private final DottedString parent;
    @Nonnull
    private final String shortName;
    @Nonnull
    private final String longName;

    private DottedString(@Nullable DottedString parent, String shortName) {
        this.parent = parent;
        this.shortName = shortName;
        this.longName = null != parent ? parent.longName + '.' + shortName : shortName;
    }

    @Nullable
    public DottedString getParent() {
        return this.parent;
    }

    @Nonnull
    public String getShortName() {
        return this.shortName;
    }

    @Nonnull
    public String getLongName() {
        return this.longName;
    }

    @Nonnull
    public String toString() {
        return this.longName;
    }

    public boolean equals(Object obj) {
        return obj instanceof DottedString && ((DottedString)obj).longName.equals(this.longName);
    }

    public int hashCode() {
        return this.longName.hashCode();
    }

    public static DottedString valueOf(@Nonnull String name) {
        DottedString value = null;
        for (String part : name.split("\\.")) {
            value = new DottedString(value, part);
        }
        return value;
    }
}

