/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.lyrics;

import com.apple.jingle.leghorn.fileformat.exceptions.DescriptionException;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Nonnull;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.io.IOUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class LyricsDocumentDescriberHelper {
    public static Document getLyricsDescriptionDocument(@Nonnull InputStream lyricsDataInputStream) throws IOException, DescriptionException {
        try {
            String lyricsData = IOUtils.toString((InputStream)lyricsDataInputStream);
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            dbFactory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            DocumentBuilder docBuilder = dbFactory.newDocumentBuilder();
            Document document = docBuilder.newDocument();
            Element ldElement = document.createElement("lyrics_description");
            document.appendChild(ldElement);
            ldElement.appendChild(document.createCDATASection(lyricsData));
            return document;
        }
        catch (ParserConfigurationException e) {
            throw new DescriptionException(e);
        }
    }

    public static String getLyricsDataFromDescription(Document descriptionDocument) {
        Element rootElement;
        Element element = rootElement = descriptionDocument != null ? descriptionDocument.getDocumentElement() : null;
        if (rootElement != null && "lyrics_description".equals(rootElement.getNodeName())) {
            return rootElement.getTextContent();
        }
        return null;
    }
}

