/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.image.png.chunks;

import com.apple.jingle.leghorn.image.png.Chunk;
import com.apple.jingle.leghorn.image.png.PNGHeader;
import com.apple.jingle.leghorn.image.png.ValidationIssue;
import com.apple.jingle.media.foundation.io.ByteArraySeekableDataInput;
import java.io.IOException;
import java.util.List;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;

public class ZtxtChunk
extends Chunk {
    String keyword;
    String decompressedText;
    int compressionMethod;

    @Override
    public void parse(PNGHeader header, List<ValidationIssue> issues) throws IOException {
        try (ByteArraySeekableDataInput basdi = new ByteArraySeekableDataInput(this.data, (long)this.data.length);){
            boolean foundNullTerminator = false;
            int index = 0;
            do {
                if (this.data[index] == 0) {
                    foundNullTerminator = true;
                    break;
                }
                ++index;
            } while (!foundNullTerminator);
            byte[] b = new byte[index];
            basdi.readFully(b, 0, index);
            this.keyword = new String(b, "ISO8859-1");
            basdi.readByte();
            this.compressionMethod = basdi.readByte();
            b = new byte[this.data.length - index - 2];
            basdi.readFully(b);
            try {
                int resultLength;
                Inflater decompresser = new Inflater();
                decompresser.setInput(b, 0, b.length);
                this.decompressedText = "";
                byte[] result = new byte[b.length];
                do {
                    resultLength = decompresser.inflate(result);
                    this.decompressedText = this.decompressedText + new String(result, 0, resultLength, "ISO8859-1");
                } while (resultLength != 0);
                decompresser.end();
            }
            catch (DataFormatException e) {
                issues.add(new ValidationIssue(ValidationIssue.Severity.MINOR, "Text compressed with an invalid data format."));
            }
        }
    }

    @Override
    public List<ValidationIssue> validate(List<ValidationIssue> issues, PNGHeader header) {
        issues = super.validate(issues, header);
        return issues;
    }

    @Override
    public String toString() {
        String value = "Keyword: " + this.keyword + "\nText: " + this.decompressedText;
        return super.toString() + value;
    }
}

