/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.image.png.chunks;

import com.apple.jingle.leghorn.image.png.Chunk;
import com.apple.jingle.leghorn.image.png.PNGHeader;
import com.apple.jingle.leghorn.image.png.PNGParser;
import com.apple.jingle.leghorn.image.png.ValidationIssue;
import com.apple.jingle.media.foundation.io.ByteArraySeekableDataInput;
import java.io.DataInput;
import java.io.IOException;
import java.util.List;

public class TrnsChunk
extends Chunk {
    int greySampleValue = -1;
    int redSampleValue = -1;
    int greenSampleValue = -1;
    int blueSampleValue = -1;
    byte[] alphaValueArray = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void parse(PNGHeader header, List<ValidationIssue> issues) throws IOException {
        try (ByteArraySeekableDataInput basdi = new ByteArraySeekableDataInput(this.data, (long)this.data.length);){
            if (header.getColorType() == 0) {
                if (this.size != 2) {
                    issues.add(new ValidationIssue(ValidationIssue.Severity.MINOR, "The size of this chunk is " + this.size + " it should be 2."));
                    return;
                }
                this.greySampleValue = PNGParser.readU16((DataInput)basdi);
            }
            if (header.getColorType() == 2) {
                if (this.size != 6) {
                    issues.add(new ValidationIssue(ValidationIssue.Severity.MINOR, "The size of this chunk is " + this.size + " it should be 6."));
                    return;
                }
                this.redSampleValue = PNGParser.readU16((DataInput)basdi);
                this.greenSampleValue = PNGParser.readU16((DataInput)basdi);
                this.blueSampleValue = PNGParser.readU16((DataInput)basdi);
            }
            if (header.getColorType() == 3) {
                if (this.data.length > header.getNumPaletteEntries()) {
                    issues.add(new ValidationIssue(ValidationIssue.Severity.MINOR, "There are more Alpha entries in the tRNS chunk than entries in the Palette."));
                    return;
                }
                if (this.data.length < header.getNumPaletteEntries()) {
                    this.alphaValueArray = new byte[header.getNumPaletteEntries()];
                    for (int i = 0; i < this.alphaValueArray.length; ++i) {
                        while ((long)i < basdi.length()) {
                            this.alphaValueArray[i] = basdi.readByte();
                            ++i;
                        }
                        this.alphaValueArray[i] = -127;
                    }
                } else {
                    this.alphaValueArray = new byte[header.getNumPaletteEntries()];
                    basdi.readFully(this.alphaValueArray);
                }
            }
        }
    }

    @Override
    public List<ValidationIssue> validate(List<ValidationIssue> issues, PNGHeader header) {
        issues = super.validate(issues, header);
        if (header.getColorType() == 4 || header.getColorType() == 6) {
            issues.add(new ValidationIssue(ValidationIssue.Severity.MINOR, "The color type has an Alpha channel. A tRNS chunk exists shouldn't."));
        }
        return issues;
    }

    @Override
    public String toString() {
        String value = "";
        return super.toString() + value;
    }
}

