/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.image.png.chunks;

import com.apple.jingle.leghorn.image.png.Chunk;
import com.apple.jingle.leghorn.image.png.PNGHeader;
import com.apple.jingle.leghorn.image.png.ValidationIssue;
import com.apple.jingle.media.foundation.io.ByteArraySeekableDataInput;
import java.io.IOException;
import java.util.List;

public class TimeChunk
extends Chunk {
    int year;
    int month;
    int day;
    int hour;
    int minute;
    int second;
    boolean receivedValidData = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void parse(PNGHeader header, List<ValidationIssue> issues) throws IOException {
        if (this.data.length != 7) {
            issues.add(new ValidationIssue(ValidationIssue.Severity.MINOR, "The size of the TimeChunk is not 7 bytes. It is " + this.data.length + "."));
            this.receivedValidData = false;
            return;
        }
        try (ByteArraySeekableDataInput basdi = new ByteArraySeekableDataInput(this.data, (long)this.data.length);){
            this.year = basdi.readShort();
            this.month = basdi.readByte();
            this.day = basdi.readByte();
            this.hour = basdi.readByte();
            this.minute = basdi.readByte();
            this.second = basdi.readByte();
        }
    }

    @Override
    public List<ValidationIssue> validate(List<ValidationIssue> issues, PNGHeader header) {
        if (this.receivedValidData) {
            if (this.month < 1 || this.month > 12) {
                issues.add(new ValidationIssue(ValidationIssue.Severity.MINOR, "The month in the tIME chunk is " + this.month + ". It should be between 1-12 "));
            }
            if (this.day < 1 || this.day > 31) {
                issues.add(new ValidationIssue(ValidationIssue.Severity.MINOR, "The day in the tIME chunk is " + this.day + ". It should be between 1-12 "));
            }
            if (this.hour < 1 || this.hour > 23) {
                issues.add(new ValidationIssue(ValidationIssue.Severity.MINOR, "The hour in the tIME chunk is " + this.hour + ". It should be between 1-12 "));
            }
            if (this.minute < 1 || this.minute > 60) {
                issues.add(new ValidationIssue(ValidationIssue.Severity.MINOR, "The minute in the tIME chunk is " + this.minute + ". It should be between 1-12 "));
            }
            if (this.second < 0 || this.second > 60) {
                issues.add(new ValidationIssue(ValidationIssue.Severity.MINOR, "The second in the tIME chunk is " + this.second + ". It should be between 1-12 "));
            }
        }
        return issues;
    }

    @Override
    public String toString() {
        String value = "Year: " + this.year + "\nMonth: " + this.month + "\nDay: " + this.day + "\nHour: " + this.hour + "\nMinute: " + this.minute + "\nSecond: " + this.second;
        return super.toString() + value;
    }
}

