/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.image.png.chunks;

import com.apple.jingle.leghorn.image.png.Chunk;
import com.apple.jingle.leghorn.image.png.PNGHeader;
import com.apple.jingle.leghorn.image.png.ValidationIssue;
import com.apple.jingle.media.foundation.io.ByteArraySeekableDataInput;
import java.io.IOException;
import java.util.List;

public class PlteChunk
extends Chunk {
    private int paletteEntries;
    private byte[] red;
    private byte[] green;
    private byte[] blue;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void parse(PNGHeader header, List<ValidationIssue> issues) throws IOException {
        try (ByteArraySeekableDataInput basdi = new ByteArraySeekableDataInput(this.data, (long)this.data.length);){
            this.paletteEntries = this.data.length / 3;
            header.setNumPaletteEntries(this.paletteEntries);
            this.red = new byte[this.paletteEntries];
            this.green = new byte[this.paletteEntries];
            this.blue = new byte[this.paletteEntries];
            if (this.paletteEntries > (int)Math.pow(2.0, header.getBitDepth())) {
                issues.add(new ValidationIssue(ValidationIssue.Severity.MINOR, "The number of data bytes in this PLTE chunk is > than 2^bitdepth (" + header.getBitDepth() + ")"));
                return;
            }
            for (int i = 0; i < this.data.length / 3; ++i) {
                this.red[i] = basdi.readByte();
                this.green[i] = basdi.readByte();
                this.blue[i] = basdi.readByte();
            }
        }
    }

    @Override
    public List<ValidationIssue> validate(List<ValidationIssue> issues, PNGHeader header) {
        issues = super.validate(issues, header);
        if (this.data.length % 3 != 0 || this.data.length == 0) {
            issues.add(new ValidationIssue(ValidationIssue.Severity.MAJOR, "The number of bytes" + this.data.length + " in the PLTE Chunk is not a multiple of 3."));
        }
        if (header.getColorType() == 0 || header.getColorType() == 4) {
            issues.add(new ValidationIssue(ValidationIssue.Severity.MINOR, "The image color type is grayscale or grayscale with alpha"));
        }
        if (this.paletteEntries > (int)Math.pow(2.0, header.getBitDepth())) {
            issues.add(new ValidationIssue(ValidationIssue.Severity.MINOR, "THe number of entries (" + this.data.length + ") in the PLTE chunk is greater than 2^bitDepth (" + (int)Math.pow(2.0, header.getBitDepth()) + ")"));
        }
        return issues;
    }

    @Override
    public String toString() {
        int i;
        String value = super.toString();
        value = value + "Red [";
        for (i = 0; i < this.paletteEntries; ++i) {
            value = value + this.red[i] + ", ";
        }
        value = value + "]\nGreen [";
        for (i = 0; i < this.paletteEntries; ++i) {
            value = value + this.green[i] + ", ";
        }
        value = value + "]\nBlue [";
        for (i = 0; i < this.paletteEntries; ++i) {
            value = value + this.blue[i] + ", ";
        }
        value = value + "]\n";
        return value;
    }
}

