/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.image.png.chunks;

import com.apple.jingle.leghorn.image.png.Chunk;
import com.apple.jingle.leghorn.image.png.PNGHeader;
import com.apple.jingle.leghorn.image.png.PNGParser;
import com.apple.jingle.leghorn.image.png.ValidationIssue;
import com.apple.jingle.media.foundation.io.ByteArraySeekableDataInput;
import java.io.DataInput;
import java.io.IOException;
import java.util.List;

public class PhysChunk
extends Chunk {
    long pixelsPerUnitX;
    long pixelsPerUnitY;
    long unitSpecifier;

    @Override
    public void parse(PNGHeader header, List<ValidationIssue> issues) throws IOException {
        ByteArraySeekableDataInput basdi = new ByteArraySeekableDataInput(this.data, (long)this.data.length);
        if (this.data.length != 9) {
            issues.add(new ValidationIssue(ValidationIssue.Severity.MINOR, "The size of this chunk is " + this.size + " it should be 9."));
        } else {
            this.pixelsPerUnitX = PNGParser.readU32((DataInput)basdi);
            this.pixelsPerUnitY = PNGParser.readU32((DataInput)basdi);
            this.unitSpecifier = basdi.readByte();
        }
    }

    @Override
    public List<ValidationIssue> validate(List<ValidationIssue> issues, PNGHeader header) {
        issues = super.validate(issues, header);
        return issues;
    }

    @Override
    public String toString() {
        String value = "Pixels Per Unit X: " + this.pixelsPerUnitX + "\nPixels Per Unit Y: " + this.pixelsPerUnitY + "\nUnit Specifier: " + this.unitSpecifier;
        return super.toString() + value;
    }
}

