/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.image.png.chunks;

import com.apple.jingle.leghorn.image.png.Chunk;
import com.apple.jingle.leghorn.image.png.PNGHeader;
import com.apple.jingle.leghorn.image.png.ValidationIssue;
import com.apple.jingle.leghorn.media.MediaValidationCode;
import com.apple.jingle.media.foundation.io.ByteArraySeekableDataInput;
import java.io.IOException;
import java.util.List;

public class IhdrChunk
extends Chunk {
    private int width = 0;
    private int height = 0;
    private byte bitDepth = 0;
    private byte colorType = 0;
    private byte compressionMethod = 0;
    private byte filterMethod = 0;
    private byte interlaceMethod = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void parse(PNGHeader header, List<ValidationIssue> issues) throws IOException {
        try (ByteArraySeekableDataInput basdi = new ByteArraySeekableDataInput(this.data, (long)this.data.length);){
            this.width = basdi.readInt();
            this.height = basdi.readInt();
            this.bitDepth = basdi.readByte();
            this.colorType = basdi.readByte();
            this.compressionMethod = basdi.readByte();
            this.filterMethod = basdi.readByte();
            this.interlaceMethod = basdi.readByte();
        }
    }

    @Override
    public List<ValidationIssue> validate(List<ValidationIssue> issues, PNGHeader header) {
        issues = super.validate(issues, header);
        if (this.height < 1) {
            issues.add(new ValidationIssue(ValidationIssue.Severity.MAJOR, "Image height is invalid.", MediaValidationCode.IMG_APPEARS_CORRUPT));
        }
        if (this.width < 1) {
            issues.add(new ValidationIssue(ValidationIssue.Severity.MAJOR, "Image width is invalid.", MediaValidationCode.IMG_APPEARS_CORRUPT));
        }
        if ((this.colorType == 2 || this.colorType == 4 || this.colorType == 6) && this.bitDepth < 8) {
            issues.add(new ValidationIssue(ValidationIssue.Severity.MAJOR, "Sample precision " + this.bitDepth + " and color type " + this.colorType + " are not consistent.", MediaValidationCode.IMG_APPEARS_CORRUPT));
        }
        if (this.compressionMethod != 0) {
            issues.add(new ValidationIssue(ValidationIssue.Severity.MAJOR, "Compression method is " + this.compressionMethod + ". It should be 0.", MediaValidationCode.IMG_APPEARS_CORRUPT));
        }
        if (this.filterMethod != 0) {
            issues.add(new ValidationIssue(ValidationIssue.Severity.MAJOR, "Filter method is " + this.filterMethod + ". It should be 0.", MediaValidationCode.IMG_APPEARS_CORRUPT));
        }
        if (this.interlaceMethod != 0 && this.interlaceMethod != 1) {
            issues.add(new ValidationIssue(ValidationIssue.Severity.MAJOR, "Interlace method is " + this.interlaceMethod + ". It should be 0 or 1.", MediaValidationCode.IMG_APPEARS_CORRUPT));
        }
        if (this.colorType != 0 && this.colorType != 2 && this.colorType != 3 && this.colorType != 4 && this.colorType != 6) {
            issues.add(new ValidationIssue(ValidationIssue.Severity.MAJOR, "Color type is " + this.colorType + ". It should be 0, 2, 3, 4, or 6.", MediaValidationCode.IMG_APPEARS_CORRUPT));
        }
        if (this.bitDepth != 1 && this.bitDepth != 2 && this.bitDepth != 4 && this.bitDepth != 8 && this.bitDepth != 16) {
            issues.add(new ValidationIssue(ValidationIssue.Severity.MAJOR, "Bit depth is " + this.bitDepth + ". It should be 1, 2, 4, 8, or 16.", MediaValidationCode.IMG_APPEARS_CORRUPT));
        }
        if (this.colorType == 6 && this.bitDepth != 8 && this.bitDepth != 16) {
            issues.add(new ValidationIssue(ValidationIssue.Severity.MAJOR, "Bit depth is " + this.bitDepth + ". It should be 1, 2, 4, 8, or 16.", MediaValidationCode.IMG_APPEARS_CORRUPT));
        }
        return issues;
    }

    @Override
    public String toString() {
        return super.toString() + "width: " + this.width + "\nheight: " + this.height + "\nbitDepth: " + this.bitDepth + "\ncolorType: " + this.colorType + "\ncompressionMethod: " + this.compressionMethod + "\nfilterMethod: " + this.filterMethod + "\ninterlaceMethod: " + this.interlaceMethod + "\n";
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public byte getBitDepth() {
        return this.bitDepth;
    }

    public void setBitDepth(byte bitDepth) {
        this.bitDepth = bitDepth;
    }

    public byte getColorType() {
        return this.colorType;
    }

    public void setColorType(byte colorType) {
        this.colorType = colorType;
    }

    public byte getCompressionMethod() {
        return this.compressionMethod;
    }

    public void setCompressionMethod(byte compressionMethod) {
        this.compressionMethod = compressionMethod;
    }

    public byte getFilterMethod() {
        return this.filterMethod;
    }

    public void setFilterMethod(byte filterMethod) {
        this.filterMethod = filterMethod;
    }

    public byte getInterlaceMethod() {
        return this.interlaceMethod;
    }

    public void setInterlaceMethod(byte interlaceMethod) {
        this.interlaceMethod = interlaceMethod;
    }
}

